/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.listener;

import com.plotsquared.core.util.WEManager;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.entity.Entity;
import com.sk89q.worldedit.extent.AbstractDelegateExtent;
import com.sk89q.worldedit.extent.Extent;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.util.Set;

public class WEExtent
extends AbstractDelegateExtent {
    public static BlockState AIRSTATE = BlockTypes.AIR.getDefaultState();
    public static BaseBlock AIRBASE = BlockTypes.AIR.getDefaultState().toBaseBlock();
    private final Set<CuboidRegion> mask;

    public WEExtent(Set<CuboidRegion> set, Extent extent) {
        super(extent);
        this.mask = set;
    }

    public boolean setBlock(BlockVector3 blockVector3, BlockStateHolder blockStateHolder) {
        return WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ()) && super.setBlock(blockVector3, blockStateHolder);
    }

    public Entity createEntity(Location location, BaseEntity baseEntity) {
        if (WEManager.maskContains(this.mask, location.getBlockX(), location.getBlockY(), location.getBlockZ())) {
            return super.createEntity(location, baseEntity);
        }
        return null;
    }

    public boolean setBiome(BlockVector2 blockVector2, BiomeType biomeType) {
        return WEManager.maskContains(this.mask, blockVector2.getX(), blockVector2.getZ()) && super.setBiome(blockVector2, biomeType);
    }

    public BlockState getBlock(BlockVector3 blockVector3) {
        if (WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ())) {
            return super.getBlock(blockVector3);
        }
        return AIRSTATE;
    }

    public BaseBlock getFullBlock(BlockVector3 blockVector3) {
        if (WEManager.maskContains(this.mask, blockVector3.getX(), blockVector3.getY(), blockVector3.getZ())) {
            return super.getFullBlock(blockVector3);
        }
        return AIRBASE;
    }
}

