/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.World;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.prtree.MBR;
import com.plotsquared.prtree.SimpleMBR;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public class Location
extends BlockLoc
implements Comparable<Location> {
    private final float yaw;
    private final float pitch;
    private final BlockVector3 blockVector3;
    private final World<?> world;

    protected Location(@NonNull World<?> world, @NonNull BlockVector3 blockVector3, float f, float f2) {
        super(blockVector3.getX(), blockVector3.getY(), blockVector3.getZ(), f, f2);
        this.world = (World)Preconditions.checkNotNull(world, (Object)"World may not be null");
        this.blockVector3 = (BlockVector3)Preconditions.checkNotNull((Object)blockVector3, (Object)"Vector may not be null");
        this.yaw = f;
        this.pitch = f2;
    }

    private Location(@NonNull String string, @NonNull BlockVector3 blockVector3, float f, float f2) {
        super(blockVector3.getX(), blockVector3.getY(), blockVector3.getZ(), f, f2);
        Preconditions.checkNotNull((Object)string, (Object)"World name may not be null");
        this.world = string.isEmpty() ? World.nullWorld() : PlotSquared.platform().getPlatformWorld(string);
        this.blockVector3 = (BlockVector3)Preconditions.checkNotNull((Object)blockVector3, (Object)"Vector may not be null");
        this.yaw = f;
        this.pitch = f2;
    }

    public static @NonNull Location at(@NonNull String string, @NonNull BlockVector3 blockVector3, float f, float f2) {
        return new Location(string, blockVector3, f, f2);
    }

    public static @NonNull Location at(@NonNull String string, @NonNull BlockVector3 blockVector3) {
        return Location.at(string, blockVector3, 0.0f, 0.0f);
    }

    public static @NonNull Location at(@NonNull String string, int n, int n2, int n3, float f, float f2) {
        return Location.at(string, BlockVector3.at((int)n, (int)n2, (int)n3), f, f2);
    }

    public static @NonNull Location at(@NonNull String string, int n, int n2, int n3) {
        return Location.at(string, BlockVector3.at((int)n, (int)n2, (int)n3));
    }

    public static @NonNull Location at(@NonNull World<?> world, @NonNull BlockVector3 blockVector3, float f, float f2) {
        return new Location(world, blockVector3, f, f2);
    }

    public static @NonNull Location at(@NonNull World<?> world, @NonNull BlockVector3 blockVector3) {
        return Location.at(world, blockVector3, 0.0f, 0.0f);
    }

    public static @NonNull Location at(@NonNull World<?> world, int n, int n2, int n3, float f, float f2) {
        return Location.at(world, BlockVector3.at((int)n, (int)n2, (int)n3), f, f2);
    }

    public static @NonNull Location at(@NonNull World<?> world, int n, int n2, int n3) {
        return Location.at(world, BlockVector3.at((int)n, (int)n2, (int)n3));
    }

    public @NonNull World<?> getWorld() {
        return this.world;
    }

    public @NonNull String getWorldName() {
        return this.world.getName();
    }

    @Override
    public int getX() {
        return this.blockVector3.getBlockX();
    }

    @Override
    public int getY() {
        return this.blockVector3.getY();
    }

    @Override
    public int getZ() {
        return this.blockVector3.getZ();
    }

    public @Nullable PlotArea getPlotArea() {
        return PlotSquared.get().getPlotAreaManager().getPlotArea(this);
    }

    public @Nullable Plot getOwnedPlot() {
        PlotArea plotArea = this.getPlotArea();
        if (plotArea != null) {
            return plotArea.getOwnedPlot(this);
        }
        return null;
    }

    public @Nullable Plot getOwnedPlotAbs() {
        PlotArea plotArea = this.getPlotArea();
        if (plotArea != null) {
            return plotArea.getOwnedPlotAbs(this);
        }
        return null;
    }

    public boolean isPlotArea() {
        return this.getPlotArea() != null;
    }

    public boolean isPlotRoad() {
        PlotArea plotArea = this.getPlotArea();
        return plotArea != null && plotArea.getPlotAbs(this) == null;
    }

    public boolean isUnownedPlotArea() {
        PlotArea plotArea = this.getPlotArea();
        return plotArea != null && plotArea.getOwnedPlotAbs(this) == null;
    }

    public @Nullable Plot getPlotAbs() {
        PlotArea plotArea = this.getPlotArea();
        if (plotArea != null) {
            return plotArea.getPlotAbs(this);
        }
        return null;
    }

    public @Nullable Plot getPlot() {
        PlotArea plotArea = this.getPlotArea();
        if (plotArea != null) {
            return plotArea.getPlot(this);
        }
        return null;
    }

    public @NonNull BlockVector2 getChunkLocation() {
        return BlockVector2.at((int)(this.getX() >> 4), (int)(this.getZ() >> 4));
    }

    public @NonNull Location add(int n, int n2, int n3) {
        return new Location(this.world, this.blockVector3.add(n, n2, n3), this.yaw, this.pitch);
    }

    public @NonNull Location withX(int n) {
        return new Location(this.world, this.blockVector3.withX(n), this.yaw, this.pitch);
    }

    public @NonNull Location withY(int n) {
        return new Location(this.world, this.blockVector3.withY(n), this.yaw, this.pitch);
    }

    public @NonNull Location withZ(int n) {
        return new Location(this.world, this.blockVector3.withZ(n), this.yaw, this.pitch);
    }

    public @NonNull Location withYaw(float f) {
        return new Location(this.world, this.blockVector3, f, this.pitch);
    }

    public @NonNull Location withPitch(float f) {
        return new Location(this.world, this.blockVector3, this.yaw, f);
    }

    public @NonNull Location withWorld(@NonNull String string) {
        return new Location(string, this.blockVector3, this.yaw, this.pitch);
    }

    public double getEuclideanDistanceSquared(@NonNull Location location) {
        double d = this.getX() - location.getX();
        double d2 = this.getY() - location.getY();
        double d3 = this.getZ() - location.getZ();
        return d * d + d2 * d2 + d3 * d3;
    }

    public double getEuclideanDistance(@NonNull Location location) {
        return Math.sqrt(this.getEuclideanDistanceSquared(location));
    }

    public @NonNull Location subtract(int n, int n2, int n3) {
        return this.add(-n, -n2, -n3);
    }

    public @NonNull MBR toMBR() {
        return new SimpleMBR(this.getX(), this.getX(), this.getY(), this.getY(), this.getZ(), this.getZ());
    }

    @Override
    public int compareTo(@NonNull Location location) {
        if (this.getX() == location.getX() && this.getY() == location.getY() || this.getZ() == location.getZ()) {
            return 0;
        }
        if (this.getX() < location.getX() && this.getY() < location.getY() && this.getZ() < location.getZ()) {
            return -1;
        }
        return 1;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        Location location = (Location)object;
        return Float.compare(location.getYaw(), this.getYaw()) == 0 && Float.compare(location.getPitch(), this.getPitch()) == 0 && Objects.equal((Object)this.getBlockVector3(), (Object)location.getBlockVector3()) && Objects.equal(this.getWorld(), location.getWorld());
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), Float.valueOf(this.getYaw()), Float.valueOf(this.getPitch()), this.getBlockVector3(), this.getWorld()});
    }

    @Override
    public String toString() {
        return "\"plotsquaredlocation\":{\"x\":" + this.getX() + ",\"y\":" + this.getY() + ",\"z\":" + this.getZ() + ",\"yaw\":" + this.yaw + ",\"pitch\":" + this.pitch + ",\"world\":\"" + this.world + "\"}";
    }

    @Override
    public float getYaw() {
        return this.yaw;
    }

    @Override
    public float getPitch() {
        return this.pitch;
    }

    public BlockVector3 getBlockVector3() {
        return this.blockVector3;
    }
}

