/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.location;

import com.plotsquared.core.util.StringMan;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotLoc {
    private final int x;
    private final int y;
    private final int z;

    public PlotLoc(int n, int n2) {
        this(n, -1, n2);
    }

    public PlotLoc(int n, int n2, int n3) {
        this.x = n;
        this.y = n2;
        this.z = n3;
    }

    public static @Nullable PlotLoc fromString(String string) {
        if (string == null || "side".equalsIgnoreCase(string)) {
            return null;
        }
        if (StringMan.isEqualIgnoreCaseToAny(string, "center", "middle", "centre")) {
            return new PlotLoc(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        try {
            String[] stringArray = string.split(",");
            if (stringArray.length == 2) {
                return new PlotLoc(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]));
            }
            if (stringArray.length == 3) {
                return new PlotLoc(Integer.parseInt(stringArray[0]), Integer.parseInt(stringArray[1]), Integer.parseInt(stringArray[2]));
            }
            throw new IllegalArgumentException(String.format("Unable to deserialize: %s", string));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int hashCode() {
        int n = 31;
        int n2 = 1;
        n2 = 31 * n2 + this.getX();
        n2 = 31 * n2 + this.getY();
        n2 = 31 * n2 + this.getZ();
        return n2;
    }

    public String toString() {
        if (this.getY() == -1) {
            return String.format("%d,%d", this.x, this.z);
        }
        return String.format("%d,%d,%d", this.x, this.y, this.z);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlotLoc plotLoc = (PlotLoc)object;
        return this.getX() == plotLoc.getX() && this.getY() == plotLoc.getY() && this.getZ() == plotLoc.getZ();
    }
}

