/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.player;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.command.RequiredType;
import com.plotsquared.core.configuration.adventure.audience.Audience;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.CaptionUtility;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.database.DBFunc;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.inject.annotations.ConsoleActor;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.PermissionHandler;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotWeather;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlotAreaManager;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.google.Inject;
import com.sk89q.worldedit.extension.platform.Actor;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import com.sk89q.worldedit.world.item.ItemType;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ConsolePlayer
extends PlotPlayer<Actor> {
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static ConsolePlayer instance;
    private final Actor actor;

    @Inject
    private ConsolePlayer(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @ConsoleActor @NonNull Actor actor, @NonNull PermissionHandler permissionHandler) {
        super(plotAreaManager, eventDispatcher, permissionHandler);
        Location location;
        this.actor = actor;
        this.setupPermissionProfile();
        PlotArea[] plotAreaArray = plotAreaManager.getAllPlotAreas();
        PlotArea plotArea = plotAreaArray.length > 0 ? plotAreaArray[0] : null;
        if (plotArea != null && !(plotAreaManager instanceof SinglePlotAreaManager)) {
            CuboidRegion cuboidRegion = plotArea.getRegion();
            location = Location.at(plotArea.getWorldName(), cuboidRegion.getMinimumPoint().getX() + cuboidRegion.getMaximumPoint().getX() / 2, 0, cuboidRegion.getMinimumPoint().getZ() + cuboidRegion.getMaximumPoint().getZ() / 2);
        } else {
            location = Location.at("", 0, 0, 0);
        }
        this.setMeta("location", location);
    }

    public static ConsolePlayer getConsole() {
        if (instance == null) {
            instance = PlotSquared.platform().injector().getInstance(ConsolePlayer.class);
            instance.teleport(instance.getLocation());
        }
        return instance;
    }

    @Override
    public Actor toActor() {
        return this.actor;
    }

    @Override
    public Actor getPlatformPlayer() {
        return this.toActor();
    }

    @Override
    public boolean canTeleport(@NonNull Location location) {
        return true;
    }

    @Override
    public void sendTitle(@NonNull Caption caption, @NonNull Caption caption2, int n, int n2, int n3, TagResolver ... tagResolverArray) {
    }

    @Override
    public @NonNull Location getLocation() {
        return (Location)this.getMeta("location");
    }

    @Override
    public Location getLocationFull() {
        return this.getLocation();
    }

    @Override
    public @NonNull UUID getUUID() {
        return DBFunc.EVERYONE;
    }

    @Override
    public long getLastPlayed() {
        return System.currentTimeMillis();
    }

    @Override
    public boolean hasPermission(@NonNull String string) {
        return true;
    }

    @Override
    public void sendMessage(@NonNull Caption caption, TagResolver ... tagResolverArray) {
        String string = caption.getComponent(this);
        if (string.isEmpty()) {
            return;
        }
        string = CaptionUtility.format(this, string).replace('\u2010', '%').replace('\u2020', '&').replace('\u2030', '&').replace("<prefix>", TranslatableCaption.of("core.prefix").getComponent(this));
        PlotSquared.platform().consoleAudience().sendMessage(MINI_MESSAGE.deserialize(string, tagResolverArray));
    }

    @Override
    public void teleport(Location location, TeleportCause teleportCause) {
        try (MetaDataAccess<Object> metaDataAccess = this.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);){
            if (location.getPlot() == null) {
                metaDataAccess.remove();
            } else {
                metaDataAccess.set(location.getPlot());
            }
        }
        metaDataAccess = this.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LOCATION);
        try {
            metaDataAccess.set((Plot)((Object)location));
        }
        finally {
            if (metaDataAccess != null) {
                metaDataAccess.close();
            }
        }
    }

    @Override
    public String getName() {
        return "*";
    }

    @Override
    public void setCompassTarget(Location location) {
    }

    @Override
    public void setAttribute(String string) {
    }

    @Override
    public boolean getAttribute(String string) {
        return false;
    }

    @Override
    public void removeAttribute(String string) {
    }

    @Override
    public @NonNull RequiredType getSuperCaller() {
        return RequiredType.CONSOLE;
    }

    @Override
    public void setWeather(@NonNull PlotWeather plotWeather) {
    }

    @Override
    public @NonNull GameMode getGameMode() {
        return GameModes.SPECTATOR;
    }

    @Override
    public void setGameMode(@NonNull GameMode gameMode) {
    }

    @Override
    public void setTime(long l) {
    }

    @Override
    public boolean getFlight() {
        return true;
    }

    @Override
    public void setFlight(boolean bl) {
    }

    @Override
    public void playMusic(@NonNull Location location, @NonNull ItemType itemType) {
    }

    @Override
    public void kick(String string) {
    }

    @Override
    public void stopSpectating() {
    }

    @Override
    public boolean isBanned() {
        return false;
    }

    @Override
    public @NonNull Audience getAudience() {
        return PlotSquared.platform().consoleAudience();
    }

    @Override
    public void removeEffect(@NonNull String string) {
    }

    @Override
    public boolean canSee(PlotPlayer<?> plotPlayer) {
        return true;
    }
}

