/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.annotations.annotations.NotNull;
import com.plotsquared.core.collection.QuadMap;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.ComponentLike;
import com.plotsquared.core.configuration.adventure.text.minimessage.MiniMessage;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GridPlotWorld;
import com.plotsquared.core.generator.IndependentPlotGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.permissions.Permission;
import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotCluster;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.GlobalFlagContainer;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.DoneFlag;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.PlotExpression;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.StringMan;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.TaskTime;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.biome.BiomeTypes;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class PlotArea
implements ComponentLike {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotArea.class.getSimpleName()));
    private static final MiniMessage MINI_MESSAGE = MiniMessage.builder().build();
    private static final DecimalFormat FLAG_DECIMAL_FORMAT = new DecimalFormat("0");
    protected final ConcurrentHashMap<PlotId, Plot> plots = new ConcurrentHashMap();
    private final @NonNull String worldName;
    private final String id;
    private final @NonNull PlotManager plotManager;
    private final int worldHash;
    private final PlotId min;
    private final PlotId max;
    private final @NonNull IndependentPlotGenerator generator;
    private final FlagContainer flagContainer = new FlagContainer(GlobalFlagContainer.getInstance());
    private final FlagContainer roadFlagContainer = new FlagContainer(GlobalFlagContainer.getInstance());
    private final YamlConfiguration worldConfiguration;
    private final GlobalBlockQueue globalBlockQueue;
    private boolean roadFlags = false;
    private boolean autoMerge = false;
    private boolean allowSigns = true;
    private boolean miscSpawnUnowned = false;
    private boolean mobSpawning = false;
    private boolean mobSpawnerSpawning = false;
    private BiomeType plotBiome = BiomeTypes.FOREST;
    private boolean plotChat = true;
    private boolean forcingPlotChat = false;
    private boolean schematicClaimSpecify = false;
    private boolean schematicOnClaim = false;
    private String schematicFile = "null";
    private boolean spawnEggs = false;
    private boolean spawnCustom = true;
    private boolean spawnBreeding = false;
    private PlotAreaType type = PlotAreaType.NORMAL;
    private PlotAreaTerrainType terrain = PlotAreaTerrainType.NONE;
    private boolean homeAllowNonmember = false;
    private BlockLoc nonmemberHome;
    private BlockLoc defaultHome;
    private int maxBuildHeight = PlotSquared.platform().versionMaxHeight() + 1;
    private int minBuildHeight = PlotSquared.platform().versionMinHeight() + 1;
    private int maxGenHeight = PlotSquared.platform().versionMaxHeight();
    private int minGenHeight = PlotSquared.platform().versionMinHeight();
    private GameMode gameMode = GameModes.CREATIVE;
    private Map<String, PlotExpression> prices = new HashMap<String, PlotExpression>();
    private List<String> schematics = new ArrayList<String>();
    private boolean worldBorder = false;
    private int borderSize = 1;
    private boolean useEconomy = false;
    private int hash;
    private CuboidRegion region;
    private ConcurrentHashMap<String, Object> meta;
    private QuadMap<PlotCluster> clusters;
    private String signMaterial = "OAK_WALL_SIGN";
    private String legacySignMaterial = "WALL_SIGN";

    public PlotArea(@NonNull String string, @Nullable String string2, @NonNull IndependentPlotGenerator independentPlotGenerator, @Nullable PlotId plotId, @Nullable PlotId plotId2, @WorldConfig @Nullable YamlConfiguration yamlConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        this.worldName = string;
        this.id = string2;
        this.plotManager = this.createManager();
        this.generator = independentPlotGenerator;
        this.globalBlockQueue = globalBlockQueue;
        if (plotId == null || plotId2 == null) {
            if (plotId != plotId2) {
                throw new IllegalArgumentException("None of the ids can be null for this constructor");
            }
            this.min = null;
            this.max = null;
        } else {
            this.min = plotId;
            this.max = plotId2;
        }
        this.worldHash = string.hashCode();
        this.worldConfiguration = yamlConfiguration;
    }

    private static void parseFlags(FlagContainer flagContainer, List<String> list) {
        for (String string : list) {
            String[] stringArray = string.contains(";") ? string.split(";") : string.split(":");
            PlotFlag<?, ?> plotFlag = GlobalFlagContainer.getInstance().getFlagFromString(stringArray[0]);
            if (plotFlag != null) {
                try {
                    flagContainer.addFlag(plotFlag.parse(stringArray[1]));
                }
                catch (FlagParseException flagParseException) {
                    LOGGER.warn("Failed to parse default flag with key '{}' and value '{}'. Reason: {}. This flag will not be added as a default flag.", (Object)flagParseException.getFlag().getName(), (Object)flagParseException.getValue(), (Object)flagParseException.getErrorMessage());
                    flagParseException.printStackTrace();
                }
                continue;
            }
            flagContainer.addUnknownFlag(stringArray[0], stringArray[1]);
        }
    }

    protected abstract @NonNull PlotManager createManager();

    public QueueCoordinator getQueue() {
        return this.globalBlockQueue.getNewQueue(PlotSquared.platform().worldUtil().getWeWorld(this.worldName));
    }

    public CuboidRegion getRegion() {
        this.region = this.getRegionAbs();
        if (this.region == null) {
            return new CuboidRegion(BlockVector3.at((int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE, (int)Integer.MIN_VALUE), BlockVector3.at((int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE, (int)Integer.MAX_VALUE));
        }
        return this.region;
    }

    private CuboidRegion getRegionAbs() {
        if (this.region == null && this.min != null) {
            Location location = this.getPlotManager().getPlotBottomLocAbs(this.min);
            Location location2 = this.getPlotManager().getPlotTopLocAbs(this.max);
            BlockVector3 blockVector3 = location.getBlockVector3().subtract(BlockVector3.ONE);
            BlockVector3 blockVector32 = location2.getBlockVector3().add(BlockVector3.ONE);
            this.region = new CuboidRegion(blockVector3, blockVector32);
        }
        return this.region;
    }

    public @NonNull PlotId getMin() {
        return this.min == null ? PlotId.of(Integer.MIN_VALUE, Integer.MIN_VALUE) : this.min;
    }

    public @NonNull PlotId getMax() {
        return this.max == null ? PlotId.of(Integer.MAX_VALUE, Integer.MAX_VALUE) : this.max;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        PlotArea plotArea = (PlotArea)object;
        return this.getWorldHash() == plotArea.getWorldHash() && this.getWorldName().equals(plotArea.getWorldName()) && StringMan.isEqual(this.getId(), plotArea.getId());
    }

    public Set<PlotCluster> getClusters() {
        return this.clusters == null ? new HashSet() : this.clusters.getAll();
    }

    public boolean isCompatible(@NonNull PlotArea plotArea) {
        ConfigurationSection configurationSection = this.worldConfiguration.getConfigurationSection("worlds");
        for (ConfigurationNode configurationNode : plotArea.getSettingNodes()) {
            Object object = configurationSection.get(plotArea.worldName + "." + configurationNode.getConstant());
            if (object != null && object.equals(configurationSection.get(this.worldName + "." + configurationNode.getConstant()))) continue;
            return false;
        }
        return true;
    }

    public void loadDefaultConfiguration(ConfigurationSection configurationSection) {
        if (!(this.min == null && this.max == null || this instanceof GridPlotWorld)) {
            throw new IllegalArgumentException("Must extend GridPlotWorld to provide");
        }
        if (configurationSection.contains("generator.terrain")) {
            this.terrain = ConfigurationUtil.getTerrain(configurationSection);
            this.type = ConfigurationUtil.getType(configurationSection);
        }
        this.mobSpawning = configurationSection.getBoolean("natural_mob_spawning");
        this.miscSpawnUnowned = configurationSection.getBoolean("misc_spawn_unowned");
        this.mobSpawnerSpawning = configurationSection.getBoolean("mob_spawner_spawning");
        this.autoMerge = configurationSection.getBoolean("plot.auto_merge");
        this.allowSigns = configurationSection.getBoolean("plot.create_signs");
        if (PlotSquared.platform().serverVersion()[1] == 13) {
            this.legacySignMaterial = configurationSection.getString("plot.legacy_sign_material");
        } else {
            this.signMaterial = configurationSection.getString("plot.sign_material");
        }
        Object object = configurationSection.getString("plot.biome");
        if (!((String)object).startsWith("minecraft:")) {
            object = "minecraft:" + (String)object;
            configurationSection.set("plot.biome", ((String)object).toLowerCase());
        }
        this.plotBiome = ConfigurationUtil.BIOME.parseString(((String)object).toLowerCase());
        this.schematicOnClaim = configurationSection.getBoolean("schematic.on_claim");
        this.schematicFile = configurationSection.getString("schematic.file");
        this.schematicClaimSpecify = configurationSection.getBoolean("schematic.specify_on_claim");
        this.schematics = new ArrayList<String>(configurationSection.getStringList("schematic.schematics"));
        this.schematics.replaceAll(String::toLowerCase);
        this.useEconomy = configurationSection.getBoolean("economy.use");
        ConfigurationSection configurationSection2 = configurationSection.getConfigurationSection("economy.prices");
        if (this.useEconomy) {
            this.prices = new HashMap<String, PlotExpression>();
            for (String string : configurationSection2.getKeys(false)) {
                String string2 = configurationSection2.getString(string);
                if (string2.contains("{arg}")) {
                    string2 = string2.replace("{arg}", "plots");
                    configurationSection2.set(string, string2);
                }
                this.prices.put(string, PlotExpression.compile(string2, "plots"));
            }
        }
        this.plotChat = configurationSection.getBoolean("chat.enabled");
        this.forcingPlotChat = configurationSection.getBoolean("chat.forced");
        this.worldBorder = configurationSection.getBoolean("world.border");
        this.borderSize = configurationSection.getInt("world.border_size");
        this.maxBuildHeight = configurationSection.getInt("world.max_height");
        this.minBuildHeight = configurationSection.getInt("world.min_height");
        this.minGenHeight = configurationSection.getInt("world.min_gen_height");
        this.maxGenHeight = configurationSection.getInt("world.max_gen_height");
        switch (configurationSection.getString("world.gamemode").toLowerCase()) {
            case "creative": 
            case "c": 
            case "1": {
                this.gameMode = GameModes.CREATIVE;
                break;
            }
            case "adventure": 
            case "a": 
            case "2": {
                this.gameMode = GameModes.ADVENTURE;
                break;
            }
            case "spectator": 
            case "3": {
                this.gameMode = GameModes.SPECTATOR;
                break;
            }
            default: {
                this.gameMode = GameModes.SURVIVAL;
            }
        }
        Object object2 = configurationSection.getString("home.nonmembers");
        String string = configurationSection.getString("home.default");
        this.defaultHome = BlockLoc.fromString(string);
        this.homeAllowNonmember = ((String)object2).equalsIgnoreCase(string);
        this.nonmemberHome = this.homeAllowNonmember ? this.defaultHome : BlockLoc.fromString((String)object2);
        if ("side".equalsIgnoreCase(string)) {
            this.defaultHome = null;
        } else if (StringMan.isEqualIgnoreCaseToAny(string, "center", "middle", "centre")) {
            this.defaultHome = new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        } else {
            try {
                this.defaultHome = BlockLoc.fromString(string);
            }
            catch (NumberFormatException numberFormatException) {
                this.defaultHome = null;
            }
        }
        this.spawnEggs = configurationSection.getBoolean("event.spawn.egg");
        this.spawnCustom = configurationSection.getBoolean("event.spawn.custom");
        this.spawnBreeding = configurationSection.getBoolean("event.spawn.breeding");
        if (PlotSquared.get().isWeInitialised()) {
            this.loadFlags(configurationSection);
        } else {
            ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.delaying_loading_area_flags"), TagResolver.resolver("area", Tag.inserting(Component.text(this.id == null ? this.worldName : this.id))));
            TaskManager.runTaskLater(() -> this.loadFlags(configurationSection), TaskTime.ticks(1L));
        }
        this.loadConfiguration(configurationSection);
    }

    private void loadFlags(ConfigurationSection configurationSection) {
        Object object;
        Object object2;
        Object object3;
        ArrayList<String> arrayList;
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.loading_area_flags"), TagResolver.resolver("area", Tag.inserting(Component.text(this.id == null ? this.worldName : this.id))));
        List<String> list = configurationSection.getStringList("flags.default");
        if (list.isEmpty() && (list = configurationSection.getStringList("flags")).isEmpty()) {
            list = new ArrayList<String>();
            arrayList = configurationSection.getConfigurationSection("flags");
            object3 = arrayList.getKeys(false);
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = object2.next();
                if ("default".equals(object)) continue;
                list.add((String)object + ";" + arrayList.get((String)object));
            }
        }
        PlotArea.parseFlags(this.getFlagContainer(), list);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.area_flags"), TagResolver.resolver("flags", Tag.inserting(Component.text(list.toString()))));
        arrayList = configurationSection.getStringList("road.flags");
        if (arrayList.isEmpty()) {
            arrayList = new ArrayList<String>();
            object3 = configurationSection.getConfigurationSection("road.flags");
            object2 = object3.getKeys(false);
            object = object2.iterator();
            while (object.hasNext()) {
                String string = (String)object.next();
                if ("default".equals(string)) continue;
                arrayList.add(string + ";" + object3.get(string));
            }
        }
        this.roadFlags = !arrayList.isEmpty();
        PlotArea.parseFlags(this.getRoadFlagContainer(), arrayList);
        ConsolePlayer.getConsole().sendMessage((Caption)TranslatableCaption.of("flags.road_flags"), TagResolver.resolver("flags", Tag.inserting(Component.text(((Object)arrayList).toString()))));
    }

    public abstract void loadConfiguration(ConfigurationSection var1);

    public void saveConfiguration(ConfigurationSection configurationSection) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("natural_mob_spawning", this.isMobSpawning());
        hashMap.put("misc_spawn_unowned", this.isMiscSpawnUnowned());
        hashMap.put("mob_spawner_spawning", this.isMobSpawnerSpawning());
        hashMap.put("plot.auto_merge", this.isAutoMerge());
        hashMap.put("plot.create_signs", this.allowSigns());
        if (PlotSquared.platform().serverVersion()[1] == 13) {
            hashMap.put("plot.legacy_sign_material", this.legacySignMaterial);
        } else {
            hashMap.put("plot.sign_material", this.signMaterial());
        }
        hashMap.put("plot.biome", "minecraft:forest");
        hashMap.put("schematic.on_claim", this.isSchematicOnClaim());
        hashMap.put("schematic.file", this.getSchematicFile());
        hashMap.put("schematic.specify_on_claim", this.isSchematicClaimSpecify());
        hashMap.put("schematic.schematics", this.getSchematics());
        hashMap.put("economy.use", this.useEconomy());
        hashMap.put("economy.prices.claim", 100);
        hashMap.put("economy.prices.merge", 100);
        hashMap.put("economy.prices.sell", 100);
        hashMap.put("chat.enabled", this.isPlotChat());
        hashMap.put("chat.forced", this.isForcingPlotChat());
        hashMap.put("flags.default", null);
        hashMap.put("event.spawn.egg", this.isSpawnEggs());
        hashMap.put("event.spawn.custom", this.isSpawnCustom());
        hashMap.put("event.spawn.breeding", this.isSpawnBreeding());
        hashMap.put("world.border", this.hasWorldBorder());
        hashMap.put("world.border_size", this.getBorderSize());
        hashMap.put("home.default", "side");
        String string = configurationSection.getString("home.nonmembers", configurationSection.getBoolean("home.allow-nonmembers", false) ? configurationSection.getString("home.default", "side") : "side");
        hashMap.put("home.nonmembers", string);
        hashMap.put("world.max_height", this.getMaxBuildHeight());
        hashMap.put("world.min_height", this.getMinBuildHeight());
        hashMap.put("world.min_gen_height", this.getMinGenHeight());
        hashMap.put("world.max_gen_height", this.getMaxGenHeight());
        hashMap.put("world.gamemode", this.getGameMode().getName().toLowerCase());
        hashMap.put("road.flags.default", null);
        if (this.getType() != PlotAreaType.NORMAL) {
            hashMap.put("generator.terrain", (Object)this.getTerrain());
            hashMap.put("generator.type", this.getType().toString());
        }
        ConfigurationNode[] configurationNodeArray = this.getSettingNodes();
        for (ConfigurationNode configurationNode : configurationNodeArray) {
            hashMap.put(configurationNode.getConstant(), configurationNode.getValue());
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            if (configurationSection.contains((String)entry.getKey())) continue;
            configurationSection.set((String)entry.getKey(), entry.getValue());
        }
        if (!configurationSection.contains("flags")) {
            configurationSection.set("flags.use", "63,64,68,69,71,77,96,143,167,193,194,195,196,197,77,143,69,70,72,147,148,107,183,184,185,186,187,132");
        }
        if (!configurationSection.contains("road.flags")) {
            configurationSection.set("road.flags.liquid-flow", false);
        }
    }

    public @NonNull String toString() {
        if (this.getId() == null) {
            return this.getWorldName();
        }
        return this.getWorldName() + ";" + this.getId();
    }

    @Override
    @NotNull
    public Component asComponent() {
        return Component.text(this.toString());
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.toString().hashCode();
        return this.hash;
    }

    public abstract ConfigurationNode[] getSettingNodes();

    public @Nullable Plot getPlotAbs(@NonNull Location location) {
        PlotId plotId = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (plotId == null) {
            return null;
        }
        return this.getPlotAbs(plotId);
    }

    public @Nullable Plot getPlot(@NonNull Location location) {
        PlotId plotId = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (plotId == null) {
            return null;
        }
        return this.getPlot(plotId);
    }

    public @Nullable Plot getOwnedPlot(@NonNull Location location) {
        PlotId plotId = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (plotId == null) {
            return null;
        }
        Plot plot = this.plots.get(plotId);
        return plot == null ? null : plot.getBasePlot(false);
    }

    public @Nullable Plot getOwnedPlotAbs(@NonNull Location location) {
        PlotId plotId = this.getPlotManager().getPlotId(location.getX(), location.getY(), location.getZ());
        if (plotId == null) {
            return null;
        }
        return this.plots.get(plotId);
    }

    public @Nullable Plot getOwnedPlotAbs(@NonNull PlotId plotId) {
        return this.plots.get(plotId);
    }

    public @Nullable Plot getOwnedPlot(@NonNull PlotId plotId) {
        Plot plot = this.plots.get(plotId);
        return plot == null ? null : plot.getBasePlot(false);
    }

    public boolean contains(int n, int n2) {
        return this.getType() != PlotAreaType.PARTIAL || RegionUtil.contains(this.getRegionAbs(), n, n2);
    }

    public boolean contains(@NonNull PlotId plotId) {
        return this.min == null || plotId.getX() >= this.min.getX() && plotId.getX() <= this.max.getX() && plotId.getY() >= this.min.getY() && plotId.getY() <= this.max.getY();
    }

    public boolean contains(@NonNull Location location) {
        return StringMan.isEqual(location.getWorldName(), this.getWorldName()) && (this.getRegionAbs() == null || this.region.contains(location.getBlockVector3()));
    }

    public boolean buildRangeContainsY(int n) {
        return n >= this.minBuildHeight && n < this.maxBuildHeight;
    }

    public boolean notifyIfOutsideBuildArea(PlotPlayer<?> plotPlayer, int n) {
        if (!this.buildRangeContainsY(n) && !plotPlayer.hasPermission(Permission.PERMISSION_ADMIN_BUILD_HEIGHT_LIMIT)) {
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("height.height_limit"), TagResolver.builder().tag("minheight", Tag.inserting(Component.text(this.minBuildHeight))).tag("maxheight", Tag.inserting(Component.text(this.maxBuildHeight))).build());
            return true;
        }
        return false;
    }

    public @NonNull Set<Plot> getPlotsAbs(UUID uUID) {
        if (uUID == null) {
            return Collections.emptySet();
        }
        HashSet<Plot> hashSet = new HashSet<Plot>();
        this.forEachPlotAbs(plot -> {
            if (uUID.equals(plot.getOwnerAbs())) {
                hashSet.add((Plot)plot);
            }
        });
        return hashSet;
    }

    public @NonNull Set<Plot> getPlots(@NonNull UUID uUID) {
        return (Set)this.getPlots().stream().filter(plot -> plot.isBasePlot() && plot.isOwner(uUID)).collect(ImmutableSet.toImmutableSet());
    }

    public Collection<Plot> getPlots() {
        return this.plots.values();
    }

    public int getPlotCount(@NonNull UUID uUID) {
        if (!Settings.Done.COUNTS_TOWARDS_LIMIT) {
            return (int)this.getPlotsAbs(uUID).stream().filter(plot -> !DoneFlag.isDone(plot)).count();
        }
        return this.getPlotsAbs(uUID).size();
    }

    @Deprecated
    public Set<Plot> getPlots(@NonNull PlotPlayer<?> plotPlayer) {
        return this.getPlots(plotPlayer.getUUID());
    }

    public boolean hasPlot(@NonNull UUID uUID) {
        return this.plots.entrySet().stream().anyMatch(entry -> ((Plot)entry.getValue()).isOwner(uUID));
    }

    public int getPlotCount(@Nullable PlotPlayer<?> plotPlayer) {
        return plotPlayer != null ? this.getPlotCount(plotPlayer.getUUID()) : 0;
    }

    public @Nullable Plot getPlotAbs(@NonNull PlotId plotId) {
        Plot plot = this.getOwnedPlotAbs(plotId);
        if (plot == null) {
            if (this.min != null && (plotId.getX() < this.min.getX() || plotId.getX() > this.max.getX() || plotId.getY() < this.min.getY() || plotId.getY() > this.max.getY())) {
                return null;
            }
            return new Plot(this, plotId);
        }
        return plot;
    }

    public @Nullable Plot getPlot(@NonNull PlotId plotId) {
        Plot plot = this.getOwnedPlotAbs(plotId);
        if (plot == null) {
            if (this.min != null && (plotId.getX() < this.min.getX() || plotId.getX() > this.max.getX() || plotId.getY() < this.min.getY() || plotId.getY() > this.max.getY())) {
                return null;
            }
            return new Plot(this, plotId);
        }
        return plot.getBasePlot(false);
    }

    public int getPlotCount() {
        return this.plots.size();
    }

    public @Nullable PlotCluster getCluster(@NonNull Location location) {
        Plot plot = this.getPlot(location);
        if (plot == null) {
            return null;
        }
        return this.clusters != null ? this.clusters.get(plot.getId().getX(), plot.getId().getY()) : null;
    }

    public @Nullable PlotCluster getFirstIntersectingCluster(@NonNull PlotId plotId, @NonNull PlotId plotId2) {
        if (this.clusters == null) {
            return null;
        }
        for (PlotCluster plotCluster : this.clusters.getAll()) {
            if (!plotCluster.intersects(plotId, plotId2)) continue;
            return plotCluster;
        }
        return null;
    }

    @Nullable PlotCluster getCluster(@NonNull PlotId plotId) {
        return this.clusters != null ? this.clusters.get(plotId.getX(), plotId.getY()) : null;
    }

    public void setMeta(@NonNull String string, @Nullable Object object) {
        if (this.meta == null) {
            this.meta = new ConcurrentHashMap();
        }
        this.meta.put(string, object);
    }

    public <T> @NonNull T getMeta(@NonNull String string, @NonNull T t) {
        Object object = this.getMeta(string);
        return (T)(object == null ? t : object);
    }

    public @Nullable Object getMeta(@NonNull String string) {
        if (this.meta != null) {
            return this.meta.get(string);
        }
        return null;
    }

    public @NonNull Set<Plot> getBasePlots() {
        HashSet<Plot> hashSet = new HashSet<Plot>(this.getPlots());
        hashSet.removeIf(plot -> !plot.isBasePlot());
        return hashSet;
    }

    private void forEachPlotAbs(Consumer<Plot> consumer) {
        for (Map.Entry<PlotId, Plot> entry : this.plots.entrySet()) {
            consumer.accept(entry.getValue());
        }
    }

    public void forEachBasePlot(Consumer<Plot> consumer) {
        for (Plot plot : this.getPlots()) {
            if (!plot.isBasePlot()) continue;
            consumer.accept(plot);
        }
    }

    @Deprecated
    public @NonNull Map<PlotId, Plot> getPlotsRaw() {
        return ImmutableMap.copyOf(this.plots);
    }

    public @NonNull Set<Map.Entry<PlotId, Plot>> getPlotEntries() {
        return this.plots.entrySet();
    }

    public boolean addPlot(@NonNull Plot plot) {
        for (PlotPlayer<?> plotPlayer : plot.getPlayersInPlot()) {
            MetaDataAccess<Plot> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
            try {
                metaDataAccess.set(plot);
            }
            finally {
                if (metaDataAccess == null) continue;
                metaDataAccess.close();
            }
        }
        return this.plots.put(plot.getId(), plot) == null;
    }

    public Plot getNextFreePlot(PlotPlayer<?> plotPlayer, @Nullable PlotId plotId) {
        int n;
        PlotId plotId2;
        PlotId plotId3 = this.getMin();
        PlotId plotId4 = this.getMax();
        if (this.getType() == PlotAreaType.PARTIAL) {
            plotId2 = PlotId.of(MathMan.average(plotId3.getX(), plotId4.getX()), MathMan.average(plotId3.getY(), plotId4.getY()));
            n = Math.max(plotId4.getX() - plotId3.getX() + 1, plotId4.getY() - plotId3.getY() + 1) + 1;
            if (plotId != null) {
                plotId = PlotId.of(plotId.getX() - plotId2.getX(), plotId.getY() - plotId2.getY());
            }
        } else {
            plotId2 = PlotId.of(0, 0);
            n = Integer.MAX_VALUE;
        }
        for (int i = 0; i < n; ++i) {
            plotId = plotId == null ? this.getMeta("lastPlot", PlotId.of(0, 0)) : plotId.getNextId();
            PlotId plotId5 = PlotId.of(plotId2.getX() + plotId.getX(), plotId2.getY() + plotId.getY());
            Plot plot = this.getPlotAbs(plotId5);
            if (plot == null || !plot.canClaim(plotPlayer)) continue;
            this.setMeta("lastPlot", plotId);
            return plot;
        }
        return null;
    }

    public boolean addPlotIfAbsent(@NonNull Plot plot) {
        if (this.plots.putIfAbsent(plot.getId(), plot) == null) {
            for (PlotPlayer<?> plotPlayer : plot.getPlayersInPlot()) {
                MetaDataAccess<Plot> metaDataAccess = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_LAST_PLOT);
                try {
                    metaDataAccess.set(plot);
                }
                finally {
                    if (metaDataAccess == null) continue;
                    metaDataAccess.close();
                }
            }
            return true;
        }
        return false;
    }

    public boolean addPlotAbs(@NonNull Plot plot) {
        return this.plots.put(plot.getId(), plot) == null;
    }

    @Deprecated(forRemoval=true, since="7.2.0")
    public int getBorder() {
        Integer n = (Integer)this.getMeta("worldBorder");
        if (n != null) {
            int n2 = n + 1;
            if (n2 == 0) {
                return Integer.MAX_VALUE;
            }
            return n2;
        }
        return Integer.MAX_VALUE;
    }

    public int getBorder(boolean bl) {
        Integer n = (Integer)this.getMeta("worldBorder");
        if (n != null) {
            int n2 = n + 1;
            if (n2 == 0) {
                return Integer.MAX_VALUE;
            }
            return bl ? n2 + this.borderSize : n2;
        }
        return Integer.MAX_VALUE;
    }

    public void setupBorder() {
        if (!this.hasWorldBorder()) {
            return;
        }
        Integer n = (Integer)this.getMeta("worldBorder");
        if (n == null) {
            this.setMeta("worldBorder", 1);
        }
        for (Plot plot : this.getPlots()) {
            plot.updateWorldBorder();
        }
    }

    public void deleteMeta(@NonNull String string) {
        if (this.meta != null) {
            this.meta.remove(string);
        }
    }

    public @Nullable List<Plot> canClaim(@Nullable PlotPlayer<?> plotPlayer, @NonNull PlotId plotId, @NonNull PlotId plotId2) {
        if (plotId.getX() == plotId2.getX() && plotId.getY() == plotId2.getY()) {
            if (this.getOwnedPlot(plotId) != null) {
                return null;
            }
            Plot plot = this.getPlotAbs(plotId);
            if (plot == null) {
                return null;
            }
            if (plot.canClaim(plotPlayer)) {
                return Collections.singletonList(plot);
            }
            return null;
        }
        LinkedList<Plot> linkedList = new LinkedList<Plot>();
        for (int i = plotId.getX(); i <= plotId2.getX(); ++i) {
            for (int j = plotId.getY(); j <= plotId2.getY(); ++j) {
                PlotId plotId3 = PlotId.of(i, j);
                Plot plot = this.getPlotAbs(plotId3);
                if (plot == null) {
                    return null;
                }
                if (!plot.canClaim(plotPlayer)) {
                    return null;
                }
                linkedList.add(plot);
            }
        }
        return linkedList;
    }

    public boolean removePlot(@NonNull PlotId plotId) {
        return this.plots.remove(plotId) != null;
    }

    public boolean mergePlots(@NonNull List<PlotId> list, boolean bl) {
        return this.mergePlots(list, bl, null);
    }

    public boolean mergePlots(@NonNull List<PlotId> list, boolean bl, @Nullable Runnable runnable) {
        int n;
        int n2;
        if (list.size() < 2) {
            return false;
        }
        PlotId plotId = list.get(0);
        PlotId plotId2 = list.get(list.size() - 1);
        PlotManager plotManager = this.getPlotManager();
        QueueCoordinator queueCoordinator = this.getQueue();
        plotManager.startPlotMerge(list, queueCoordinator);
        HashSet<UUID> hashSet = new HashSet<UUID>();
        HashSet<UUID> hashSet2 = new HashSet<UUID>();
        HashSet<UUID> hashSet3 = new HashSet<UUID>();
        for (n2 = plotId.getX(); n2 <= plotId2.getX(); ++n2) {
            for (n = plotId.getY(); n <= plotId2.getY(); ++n) {
                PlotId plotId3 = PlotId.of(n2, n);
                Plot plot = this.getPlotAbs(plotId3);
                hashSet.addAll(plot.getTrusted());
                hashSet2.addAll(plot.getMembers());
                hashSet3.addAll(plot.getDenied());
                if (!bl) continue;
                plot.getPlotModificationManager().removeSign();
            }
        }
        hashSet2.removeAll(hashSet);
        hashSet3.removeAll(hashSet);
        hashSet3.removeAll(hashSet2);
        for (n2 = plotId.getX(); n2 <= plotId2.getX(); ++n2) {
            for (n = plotId.getY(); n <= plotId2.getY(); ++n) {
                Plot plot;
                boolean bl2 = n2 < plotId2.getX();
                boolean bl3 = n < plotId2.getY();
                PlotId plotId4 = PlotId.of(n2, n);
                Plot plot2 = this.getPlotAbs(plotId4);
                plot2.setTrusted(hashSet);
                plot2.setMembers(hashSet2);
                plot2.setDenied(hashSet3);
                if (bl2) {
                    if (bl3 && (!plot2.isMerged(Direction.EAST) || !plot2.isMerged(Direction.SOUTH)) && bl) {
                        plot2.getPlotModificationManager().removeRoadSouthEast(queueCoordinator);
                    }
                    if (!plot2.isMerged(Direction.EAST)) {
                        plot = plot2.getRelative(1, 0);
                        plot2.mergePlot(plot, bl, queueCoordinator);
                    }
                }
                if (!bl3 || plot2.isMerged(Direction.SOUTH)) continue;
                plot = plot2.getRelative(0, 1);
                plot2.mergePlot(plot, bl, queueCoordinator);
            }
        }
        plotManager.finishPlotMerge(list, queueCoordinator);
        if (runnable != null) {
            queueCoordinator.setCompleteTask(runnable);
        }
        queueCoordinator.enqueue();
        return true;
    }

    public Set<Plot> getPlotSelectionOwned(@NonNull PlotId plotId, @NonNull PlotId plotId2) {
        int n = (1 + plotId2.getX() - plotId.getX()) * (1 + plotId2.getY() - plotId.getY());
        HashSet<Plot> hashSet = new HashSet<Plot>();
        if (n < 16 || n < this.getPlotCount()) {
            for (PlotId plotId3 : Lists.newArrayList((Iterable)PlotId.PlotRangeIterator.range(plotId, plotId2))) {
                Plot plot = this.getPlotAbs(plotId3);
                if (!plot.hasOwner() || plot.getId().getX() <= plotId.getX() && plot.getId().getY() <= plotId.getY() && plot.getId().getX() >= plotId2.getX() && plot.getId().getY() >= plotId2.getY()) continue;
                hashSet.add(plot);
            }
        } else {
            for (Plot plot : this.getPlots()) {
                if (plot.getId().getX() <= plotId.getX() && plot.getId().getY() <= plotId.getY() && plot.getId().getX() >= plotId2.getX() && plot.getId().getY() >= plotId2.getY()) continue;
                hashSet.add(plot);
            }
        }
        return hashSet;
    }

    public void removeCluster(@Nullable PlotCluster plotCluster) {
        if (this.clusters == null) {
            throw new IllegalAccessError("Clusters not enabled!");
        }
        this.clusters.remove(plotCluster);
    }

    public void addCluster(@Nullable PlotCluster plotCluster) {
        if (this.clusters == null) {
            this.clusters = new QuadMap<PlotCluster>(Integer.MAX_VALUE, 0, 0, 62){

                @Override
                public CuboidRegion getRegion(PlotCluster plotCluster) {
                    BlockVector2 blockVector2 = BlockVector2.at((int)plotCluster.getP1().getX(), (int)plotCluster.getP1().getY());
                    BlockVector2 blockVector22 = BlockVector2.at((int)plotCluster.getP2().getX(), (int)plotCluster.getP2().getY());
                    return new CuboidRegion(blockVector2.toBlockVector3(PlotArea.this.getMinGenHeight()), blockVector22.toBlockVector3(PlotArea.this.getMaxGenHeight()));
                }
            };
        }
        this.clusters.add(plotCluster);
    }

    public @Nullable PlotCluster getCluster(String string) {
        for (PlotCluster plotCluster : this.getClusters()) {
            if (!plotCluster.getName().equalsIgnoreCase(string)) continue;
            return plotCluster;
        }
        return null;
    }

    public boolean hasSchematic(@NonNull String string) {
        return this.getSchematics().contains(string.toLowerCase());
    }

    public boolean useEconomy() {
        return this.useEconomy;
    }

    public boolean hasWorldBorder() {
        return this.worldBorder;
    }

    public int getBorderSize() {
        return this.borderSize;
    }

    public boolean allowSigns() {
        return this.allowSigns;
    }

    public String signMaterial() {
        return this.signMaterial;
    }

    public String legacySignMaterial() {
        return this.legacySignMaterial;
    }

    public <T> T getFlag(Class<? extends PlotFlag<T, ?>> clazz) {
        return this.flagContainer.getFlag(clazz).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> T getFlag(V v) {
        Class<?> clazz = v.getClass();
        PlotFlag<?, ?> plotFlag = this.flagContainer.getFlagErased(clazz);
        return ((PlotFlag)FlagContainer.castUnsafe(plotFlag)).getValue();
    }

    public <T> T getRoadFlag(Class<? extends PlotFlag<T, ?>> clazz) {
        return this.roadFlagContainer.getFlag(clazz).getValue();
    }

    public <T, V extends PlotFlag<T, ?>> T getRoadFlag(V v) {
        Class<?> clazz = v.getClass();
        PlotFlag<?, ?> plotFlag = this.roadFlagContainer.getFlagErased(clazz);
        return ((PlotFlag)FlagContainer.castUnsafe(plotFlag)).getValue();
    }

    public @NonNull String getWorldName() {
        return this.worldName;
    }

    public String getId() {
        return this.id;
    }

    public @NonNull PlotManager getPlotManager() {
        return this.plotManager;
    }

    public int getWorldHash() {
        return this.worldHash;
    }

    public @NonNull IndependentPlotGenerator getGenerator() {
        return this.generator;
    }

    public boolean isAutoMerge() {
        return this.autoMerge;
    }

    public boolean isMiscSpawnUnowned() {
        return this.miscSpawnUnowned;
    }

    public boolean isMobSpawning() {
        return this.mobSpawning;
    }

    public boolean isMobSpawnerSpawning() {
        return this.mobSpawnerSpawning;
    }

    public BiomeType getPlotBiome() {
        return this.plotBiome;
    }

    public boolean isPlotChat() {
        return this.plotChat;
    }

    public boolean isForcingPlotChat() {
        return this.forcingPlotChat;
    }

    public boolean isSchematicClaimSpecify() {
        return this.schematicClaimSpecify;
    }

    public boolean isSchematicOnClaim() {
        return this.schematicOnClaim;
    }

    public String getSchematicFile() {
        return this.schematicFile;
    }

    public boolean isSpawnEggs() {
        return this.spawnEggs;
    }

    public String getSignMaterial() {
        return this.signMaterial;
    }

    public boolean isSpawnCustom() {
        return this.spawnCustom;
    }

    public boolean isSpawnBreeding() {
        return this.spawnBreeding;
    }

    public PlotAreaType getType() {
        return this.type;
    }

    public void setType(PlotAreaType plotAreaType) {
        this.type = plotAreaType;
    }

    public PlotAreaTerrainType getTerrain() {
        return this.terrain;
    }

    public void setTerrain(PlotAreaTerrainType plotAreaTerrainType) {
        this.terrain = plotAreaTerrainType;
    }

    public boolean isHomeAllowNonmember() {
        return this.homeAllowNonmember;
    }

    public BlockLoc nonmemberHome() {
        return this.nonmemberHome;
    }

    public BlockLoc defaultHome() {
        return this.defaultHome;
    }

    protected void setDefaultHome(BlockLoc blockLoc) {
        this.defaultHome = blockLoc;
    }

    public int getMaxBuildHeight() {
        return this.maxBuildHeight;
    }

    public int getMinBuildHeight() {
        return this.minBuildHeight;
    }

    public int getMinGenHeight() {
        return this.minGenHeight;
    }

    public int getMaxGenHeight() {
        return this.maxGenHeight;
    }

    public GameMode getGameMode() {
        return this.gameMode;
    }

    public Map<String, PlotExpression> getPrices() {
        return this.prices;
    }

    protected List<String> getSchematics() {
        return this.schematics;
    }

    public boolean isRoadFlags() {
        return this.roadFlags;
    }

    public FlagContainer getFlagContainer() {
        return this.flagContainer;
    }

    public FlagContainer getRoadFlagContainer() {
        return this.roadFlagContainer;
    }

    public void setAllowSigns(boolean bl) {
        this.allowSigns = bl;
    }

    static {
        FLAG_DECIMAL_FORMAT.setMaximumFractionDigits(340);
    }
}

