/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.comment.PlotComment;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PlotCommentContainer {
    private final Plot plot;

    PlotCommentContainer(@NonNull Plot plot) {
        this.plot = plot;
    }

    public boolean removeComment(@NonNull PlotComment plotComment) {
        return this.getSettings().removeComment(plotComment);
    }

    public void removeComments(@NonNull List<PlotComment> list) {
        this.getSettings().removeComments(list);
    }

    public @NonNull List<PlotComment> getComments(@NonNull String string) {
        return this.getSettings().getComments(string);
    }

    public void addComment(@NonNull PlotComment plotComment) {
        this.getSettings().addComment(plotComment);
    }

    public void setComments(@NonNull List<PlotComment> list) {
        this.getSettings().setComments(list);
    }

    private @NonNull PlotSettings getSettings() {
        if (this.plot.getSettings() == null) {
            throw new IllegalStateException("Cannot access comments for unowned plots");
        }
        return this.plot.getSettings();
    }
}

