/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.plotsquared.core.location.Direction;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class PlotId {
    private final int x;
    private final int y;
    private final int hash;

    private PlotId(int n, int n2) {
        this.x = n;
        this.y = n2;
        this.hash = this.getX() << 16 | this.getY() & 0xFFFF;
    }

    public static @NonNull PlotId of(int n, int n2) {
        return new PlotId(n, n2);
    }

    public static @NonNull PlotId fromString(@NonNull String string) {
        PlotId plotId = PlotId.fromStringOrNull(string);
        if (plotId == null) {
            throw new IllegalArgumentException("Cannot create PlotID. String invalid.");
        }
        return plotId;
    }

    public static @Nullable PlotId fromStringOrNull(@NonNull String string) {
        int n;
        int n2;
        String[] stringArray = string.split("[;_,.]");
        if (stringArray.length < 2) {
            return null;
        }
        try {
            n2 = Integer.parseInt(stringArray[0]);
            n = Integer.parseInt(stringArray[1]);
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        return PlotId.of(n2, n);
    }

    public static @NonNull PlotId unpair(int n) {
        return PlotId.of(n >> 16, n & 0xFFFF);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public @NonNull PlotId getNextId() {
        int n;
        int n2 = Math.abs(this.x);
        if (n2 > (n = Math.abs(this.y))) {
            if (this.x > 0) {
                return PlotId.of(this.x, this.y + 1);
            }
            return PlotId.of(this.x, this.y - 1);
        }
        if (n > n2) {
            if (this.y > 0) {
                return PlotId.of(this.x - 1, this.y);
            }
            return PlotId.of(this.x + 1, this.y);
        }
        if (this.x == this.y && this.x > 0) {
            return PlotId.of(this.x, this.y + 1);
        }
        if (this.x == n2) {
            return PlotId.of(this.x, this.y + 1);
        }
        if (this.y == n) {
            return PlotId.of(this.x, this.y - 1);
        }
        return PlotId.of(this.x + 1, this.y);
    }

    public @NonNull PlotId getRelative(@NonNull Direction direction) {
        return switch (direction) {
            case Direction.NORTH -> PlotId.of(this.getX(), this.getY() - 1);
            case Direction.EAST -> PlotId.of(this.getX() + 1, this.getY());
            case Direction.SOUTH -> PlotId.of(this.getX(), this.getY() + 1);
            case Direction.WEST -> PlotId.of(this.getX() - 1, this.getY());
            default -> this;
        };
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.hashCode() != object.hashCode()) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        PlotId plotId = (PlotId)object;
        return this.getX() == plotId.getX() && this.getY() == plotId.getY();
    }

    public @NonNull String toString() {
        return this.getX() + ";" + this.getY();
    }

    public @NonNull String toSeparatedString(String string) {
        return this.getX() + string + this.getY();
    }

    public @NonNull String toCommaSeparatedString() {
        return this.getX() + "," + this.getY();
    }

    public @NonNull String toUnderscoreSeparatedString() {
        return this.getX() + "_" + this.getY();
    }

    public @NonNull String toDashSeparatedString() {
        return this.getX() + "-" + this.getY();
    }

    public int hashCode() {
        return this.hash;
    }

    public static final class PlotRangeIterator
    implements Iterator<PlotId>,
    Iterable<PlotId> {
        private final PlotId start;
        private final PlotId end;
        private int x;
        private int y;

        private PlotRangeIterator(@NonNull PlotId plotId, @NonNull PlotId plotId2) {
            this.start = plotId;
            this.end = plotId2;
            this.x = this.start.getX();
            this.y = this.start.getY();
        }

        public static PlotRangeIterator range(@NonNull PlotId plotId, @NonNull PlotId plotId2) {
            return new PlotRangeIterator(plotId, plotId2);
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.end.getX() && this.y <= this.end.getY();
        }

        @Override
        public PlotId next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("The iterator has no more entries");
            }
            PlotId plotId = PlotId.of(this.x, this.y);
            if (this.y == this.end.getY()) {
                ++this.x;
                this.y = this.start.getY();
            } else {
                ++this.y;
            }
            return plotId;
        }

        @Override
        public @NonNull Iterator<PlotId> iterator() {
            return this;
        }
    }
}

