/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot;

import com.google.common.collect.ImmutableList;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.plot.comment.PlotComment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class PlotSettings {
    private boolean[] merged = new boolean[]{false, false, false, false};
    private String alias = "";
    private HashMap<UUID, Integer> ratings;
    private List<PlotComment> comments = null;
    private BlockLoc position;

    public boolean getMerged(int n) {
        return this.merged[n];
    }

    public Map<UUID, Integer> getRatings() {
        if (this.ratings == null) {
            this.ratings = new HashMap();
        }
        return this.ratings;
    }

    public void setRatings(HashMap<UUID, Integer> hashMap) {
        this.ratings = hashMap;
    }

    public boolean setMerged(Direction direction, boolean bl) {
        if (Direction.ALL == direction) {
            throw new IllegalArgumentException("You cannot use Direction.ALL in this method!");
        }
        if (this.merged[direction.getIndex()] != bl) {
            this.merged[direction.getIndex()] = bl;
            return true;
        }
        return false;
    }

    public BlockLoc getPosition() {
        if (this.position == null) {
            return BlockLoc.MINY;
        }
        return this.position;
    }

    public void setPosition(BlockLoc blockLoc) {
        if (blockLoc != null && blockLoc.getX() == 0 && blockLoc.getY() == 0 && blockLoc.getZ() == 0) {
            blockLoc = null;
        }
        this.position = blockLoc;
    }

    public List<PlotComment> getComments(String string) {
        if (this.comments == null) {
            return Collections.emptyList();
        }
        return (List)this.comments.stream().filter(plotComment -> plotComment.inbox().equals(string)).collect(ImmutableList.toImmutableList());
    }

    boolean removeComment(PlotComment plotComment) {
        if (this.comments == null) {
            return false;
        }
        return this.comments.remove(plotComment);
    }

    void removeComments(List<PlotComment> list) {
        list.forEach(this::removeComment);
    }

    void addComment(PlotComment plotComment) {
        if (this.comments == null) {
            this.comments = new ArrayList<PlotComment>();
        }
        this.comments.add(plotComment);
    }

    public boolean[] getMerged() {
        return this.merged;
    }

    public void setMerged(boolean[] blArray) {
        this.merged = blArray;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String string) {
        this.alias = string;
    }

    public void setComments(List<PlotComment> list) {
        this.comments = list;
    }
}

