/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.expiration.ExpireManager;
import com.plotsquared.core.plot.expiration.PlotAnalysis;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.util.query.PlotQuery;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;

public class ExpiryTask {
    private final Settings.Auto_Clear settings;
    private final PlotAreaManager plotAreaManager;
    private long cutoffThreshold = Long.MIN_VALUE;

    public ExpiryTask(Settings.Auto_Clear auto_Clear, @NonNull PlotAreaManager plotAreaManager) {
        this.settings = auto_Clear;
        this.plotAreaManager = plotAreaManager;
    }

    public Settings.Auto_Clear getSettings() {
        return this.settings;
    }

    public boolean allowsArea(PlotArea plotArea) {
        return this.settings.WORLDS.contains(plotArea.toString()) || this.settings.WORLDS.contains(plotArea.getWorldName()) || this.settings.WORLDS.contains("*");
    }

    public boolean applies(PlotArea plotArea) {
        if (this.allowsArea(plotArea)) {
            if (this.settings.REQUIRED_PLOTS <= 0) {
                return true;
            }
            Set<Plot> set = null;
            if (this.cutoffThreshold != Long.MAX_VALUE && plotArea.getPlots().size() > this.settings.REQUIRED_PLOTS || (set = this.getPlotsToCheck()).size() > this.settings.REQUIRED_PLOTS) {
                if (this.cutoffThreshold == Long.MIN_VALUE) {
                    set = set != null ? set : this.getPlotsToCheck();
                    int n = this.settings.REQUIRED_PLOTS;
                    boolean bl = true;
                    if (set.size() > this.settings.REQUIRED_PLOTS) {
                        bl = false;
                        n = set.size() - this.settings.REQUIRED_PLOTS;
                    }
                    ExpireManager expireManager = PlotSquared.platform().expireManager();
                    List list = set.stream().map(plot -> expireManager.getAge((Plot)plot, this.settings.DELETE_IF_OWNER_IS_UNKNOWN)).collect(Collectors.toList());
                    ArrayList<Long> arrayList = new ArrayList<Long>(n + 1);
                    if (n > 1000) {
                        Collections.sort(list);
                        this.cutoffThreshold = (Long)list.get(this.settings.REQUIRED_PLOTS);
                    } else {
                        Iterator iterator = list.iterator();
                        block0: while (iterator.hasNext()) {
                            long l = (Long)iterator.next();
                            int n2 = arrayList.size();
                            if (n2 == 0) {
                                arrayList.add(l);
                                continue;
                            }
                            long l2 = (Long)arrayList.get(n2 - 1);
                            if (bl ? l < l2 : l > l2) {
                                for (int i = 0; i < n2; ++i) {
                                    long l3 = (Long)arrayList.get(i);
                                    if (!(bl ? l < l3 : l > l3)) continue;
                                    arrayList.add(i, l);
                                    if (n2 != n) continue block0;
                                    arrayList.remove(n2);
                                    continue block0;
                                }
                            }
                            if (n2 >= n) continue;
                            arrayList.add(l);
                        }
                        this.cutoffThreshold = (Long)arrayList.get(arrayList.size() - 1);
                    }
                    this.cutoffThreshold += TimeUnit.DAYS.toMillis(1L) / 2L;
                }
                return true;
            }
            this.cutoffThreshold = Long.MAX_VALUE;
        }
        return false;
    }

    public Set<Plot> getPlotsToCheck() {
        LinkedList<PlotArea> linkedList = new LinkedList<PlotArea>();
        for (PlotArea plotArea : this.plotAreaManager.getAllPlotAreas()) {
            if (!this.allowsArea(plotArea)) continue;
            linkedList.add(plotArea);
        }
        return PlotQuery.newQuery().inAreas(linkedList).asSet();
    }

    public boolean applies(long l) {
        return l > TimeUnit.DAYS.toMillis(this.settings.DAYS) && l > this.cutoffThreshold;
    }

    public boolean appliesAccountAge(long l) {
        if (this.settings.SKIP_ACCOUNT_AGE_DAYS != -1) {
            return l <= TimeUnit.DAYS.toMillis(this.settings.SKIP_ACCOUNT_AGE_DAYS);
        }
        return false;
    }

    public boolean needsAnalysis() {
        return this.settings.THRESHOLD > 0;
    }

    public boolean applies(PlotAnalysis plotAnalysis) {
        return plotAnalysis.getComplexity(this.settings) <= this.settings.THRESHOLD;
    }

    public boolean requiresConfirmation() {
        return this.settings.CONFIRMATION;
    }

    public boolean shouldDeleteForUnknownOwner() {
        return this.settings.DELETE_IF_OWNER_IS_UNKNOWN;
    }
}

