/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.expiration;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.generator.HybridUtils;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.flag.implementations.AnalysisFlag;
import com.plotsquared.core.util.MathMan;
import com.plotsquared.core.util.query.PlotQuery;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import java.lang.reflect.Array;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlotAnalysis {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + PlotAnalysis.class.getSimpleName()));
    public static boolean running = false;
    public int changes;
    public int faces;
    public int data;
    public int air;
    public int variety;
    public int changes_sd;
    public int faces_sd;
    public int data_sd;
    public int air_sd;
    public int variety_sd;
    private int complexity;

    public static PlotAnalysis getAnalysis(Plot plot, Settings.Auto_Clear auto_Clear) {
        List list = (List)plot.getFlag(AnalysisFlag.class);
        if (!list.isEmpty()) {
            PlotAnalysis plotAnalysis = new PlotAnalysis();
            plotAnalysis.changes = (Integer)list.get(0);
            plotAnalysis.faces = (Integer)list.get(1);
            plotAnalysis.data = (Integer)list.get(2);
            plotAnalysis.air = (Integer)list.get(3);
            plotAnalysis.variety = (Integer)list.get(4);
            plotAnalysis.changes_sd = (Integer)list.get(5);
            plotAnalysis.faces_sd = (Integer)list.get(6);
            plotAnalysis.data_sd = (Integer)list.get(7);
            plotAnalysis.air_sd = (Integer)list.get(8);
            plotAnalysis.variety_sd = (Integer)list.get(9);
            plotAnalysis.complexity = auto_Clear != null ? plotAnalysis.getComplexity(auto_Clear) : 0;
            return plotAnalysis;
        }
        return null;
    }

    public static void analyzePlot(Plot plot, RunnableVal<PlotAnalysis> runnableVal) {
        PlotSquared.platform().injector().getInstance(HybridUtils.class).analyzePlot(plot, runnableVal);
    }

    public static void calcOptimalModifiers(final Runnable runnable, final double d) {
        if (running) {
            LOGGER.info("Calibration task already in progress!");
            return;
        }
        if (d <= 0.0 || d >= 1.0) {
            LOGGER.info("Invalid threshold provided! (Cannot be 0 or 100 as then there's no point in calibrating)");
            return;
        }
        running = true;
        final List<Plot> list = PlotQuery.newQuery().allPlots().asList();
        TaskManager.runTaskAsync(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Iterator iterator;
                int n;
                Object object;
                Object object2;
                Plot plot;
                Object object3;
                Iterator iterator2 = list.iterator();
                LOGGER.info("- Reducing {} plots to those with sufficient data", (Object)list.size());
                while (iterator2.hasNext()) {
                    object3 = (Plot)iterator2.next();
                    if (((Plot)object3).getSettings().getRatings() == null || ((Plot)object3).getSettings().getRatings().isEmpty()) {
                        iterator2.remove();
                        continue;
                    }
                    ((Plot)object3).addRunning();
                }
                if (list.size() < 3) {
                    LOGGER.info("Calibration cancelled due to insufficient comparison data, please try again later");
                    running = false;
                    for (Plot plot2 : list) {
                        plot2.removeRunning();
                    }
                    return;
                }
                LOGGER.info("- Analyzing plot contents (this may take a while)");
                object3 = new int[list.size()];
                int[] nArray = new int[list.size()];
                int[] nArray2 = new int[list.size()];
                int[] nArray3 = new int[list.size()];
                int[] nArray4 = new int[list.size()];
                int[] nArray5 = new int[list.size()];
                int[] nArray6 = new int[list.size()];
                int[] nArray7 = new int[list.size()];
                int[] nArray8 = new int[list.size()];
                int[] nArray9 = new int[list.size()];
                int[] nArray10 = new int[list.size()];
                AtomicInteger atomicInteger = new AtomicInteger(0);
                Thread thread = new Thread(() -> {
                    while (atomicInteger.intValue() < list.size()) {
                        int n = atomicInteger.intValue();
                        Plot plot = (Plot)list.get(n);
                        nArray[n] = (int)((plot.getAverageRating() + (double)plot.getSettings().getRatings().size()) * 100.0);
                        LOGGER.info(" | {} (rating) {}", (Object)plot, (Object)nArray10[n]);
                        atomicInteger.incrementAndGet();
                    }
                });
                thread.start();
                ArrayDeque arrayDeque = new ArrayDeque(list);
                while ((plot = (Plot)arrayDeque.poll()) != null) {
                    LOGGER.info(" | {}", (Object)plot);
                    object2 = new Object();
                    TaskManager.runTask(new Runnable(){

                        @Override
                        public void run() {
                            PlotAnalysis.analyzePlot(plot, new RunnableVal<PlotAnalysis>(){

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public void run(PlotAnalysis plotAnalysis) {
                                    Object object;
                                    try {
                                        object = this;
                                        synchronized (object) {
                                            this.wait(10000L);
                                        }
                                    }
                                    catch (InterruptedException interruptedException) {
                                        interruptedException.printStackTrace();
                                    }
                                    object = object2;
                                    synchronized (object) {
                                        plot.removeRunning();
                                        object2.notify();
                                    }
                                }
                            });
                        }
                    });
                    try {
                        object = object2;
                        synchronized (object) {
                            object2.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
                LOGGER.info("- Waiting on plot rating thread: {}%", (Object)(atomicInteger.intValue() * 100 / list.size()));
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                }
                LOGGER.info("- Processing and grouping single plot analysis for bulk processing");
                for (int i = 0; i < list.size(); ++i) {
                    object2 = (Plot)list.get(i);
                    LOGGER.info("| {}", object2);
                    object = ((Plot)object2).getComplexity(null);
                    object3[i] = (Iterator)((PlotAnalysis)object).changes;
                    nArray[i] = ((PlotAnalysis)object).faces;
                    nArray2[i] = ((PlotAnalysis)object).data;
                    nArray3[i] = ((PlotAnalysis)object).air;
                    nArray4[i] = ((PlotAnalysis)object).variety;
                    nArray5[i] = ((PlotAnalysis)object).changes_sd;
                    nArray6[i] = ((PlotAnalysis)object).faces_sd;
                    nArray7[i] = ((PlotAnalysis)object).data_sd;
                    nArray8[i] = ((PlotAnalysis)object).air_sd;
                    nArray9[i] = ((PlotAnalysis)object).variety_sd;
                }
                LOGGER.info("- Calculating rankings");
                int[] nArray11 = PlotAnalysis.rank(nArray10);
                int n2 = nArray11.length;
                int n3 = (int)Math.round((1.0 - d) * (double)(n2 - 1));
                LOGGER.info("- Calculating rank correlation: ");
                LOGGER.info("- The analyzed plots which were processed and put into bulk data will be compared and correlated to the plot ranking");
                LOGGER.info("- The calculated correlation constant will then be used to calibrate the threshold for auto plot clearing");
                Settings.Auto_Clear auto_Clear = new Settings.Auto_Clear();
                int[] nArray12 = PlotAnalysis.rank(object3);
                int[] nArray13 = PlotAnalysis.getSD(nArray12, nArray11);
                int[] nArray14 = PlotAnalysis.square(nArray13);
                int n4 = PlotAnalysis.sum(nArray14);
                double d11 = PlotAnalysis.getCC(n2, n4);
                auto_Clear.CALIBRATION.CHANGES = d11 == 1.0 ? 0 : (int)(d11 * 1000.0 / MathMan.getMean(object3));
                LOGGER.info("- | changes {}", (Object)d11);
                int[] nArray15 = PlotAnalysis.rank(nArray);
                int[] nArray16 = PlotAnalysis.getSD(nArray15, nArray11);
                int[] nArray17 = PlotAnalysis.square(nArray16);
                int n5 = PlotAnalysis.sum(nArray17);
                double d2 = PlotAnalysis.getCC(n2, n5);
                auto_Clear.CALIBRATION.FACES = d2 == 1.0 ? 0 : (int)(d2 * 1000.0 / MathMan.getMean(nArray));
                LOGGER.info("- | faces {}", (Object)d2);
                int[] nArray18 = PlotAnalysis.rank(nArray2);
                int[] nArray19 = PlotAnalysis.getSD(nArray18, nArray11);
                int[] nArray20 = PlotAnalysis.square(nArray19);
                int n6 = PlotAnalysis.sum(nArray20);
                double d3 = PlotAnalysis.getCC(n2, n6);
                auto_Clear.CALIBRATION.DATA = d3 == 1.0 ? 0 : (int)(d3 * 1000.0 / MathMan.getMean(nArray2));
                LOGGER.info("- | data {}", (Object)d3);
                int[] nArray21 = PlotAnalysis.rank(nArray3);
                int[] nArray22 = PlotAnalysis.getSD(nArray21, nArray11);
                int[] nArray23 = PlotAnalysis.square(nArray22);
                int n7 = PlotAnalysis.sum(nArray23);
                double d4 = PlotAnalysis.getCC(n2, n7);
                auto_Clear.CALIBRATION.AIR = d4 == 1.0 ? 0 : (int)(d4 * 1000.0 / MathMan.getMean(nArray3));
                LOGGER.info("- | air {}", (Object)d4);
                int[] nArray24 = PlotAnalysis.rank(nArray4);
                int[] nArray25 = PlotAnalysis.getSD(nArray24, nArray11);
                int[] nArray26 = PlotAnalysis.square(nArray25);
                int n8 = PlotAnalysis.sum(nArray26);
                double d5 = PlotAnalysis.getCC(n2, n8);
                auto_Clear.CALIBRATION.VARIETY = d5 == 1.0 ? 0 : (int)(d5 * 1000.0 / MathMan.getMean(nArray4));
                LOGGER.info("- | variety {}", (Object)d5);
                int[] nArray27 = PlotAnalysis.rank(nArray5);
                int[] nArray28 = PlotAnalysis.getSD(nArray27, nArray11);
                int[] nArray29 = PlotAnalysis.square(nArray28);
                int n9 = PlotAnalysis.sum(nArray29);
                double d6 = PlotAnalysis.getCC(n2, n9);
                auto_Clear.CALIBRATION.CHANGES_SD = d6 == 1.0 ? 0 : (int)(d6 * 1000.0 / MathMan.getMean(nArray5));
                LOGGER.info("- | changed_sd {}", (Object)d6);
                int[] nArray30 = PlotAnalysis.rank(nArray6);
                int[] nArray31 = PlotAnalysis.getSD(nArray30, nArray11);
                int[] nArray32 = PlotAnalysis.square(nArray31);
                int n10 = PlotAnalysis.sum(nArray32);
                double d7 = PlotAnalysis.getCC(n2, n10);
                auto_Clear.CALIBRATION.FACES_SD = d7 == 1.0 ? 0 : (int)(d7 * 1000.0 / MathMan.getMean(nArray6));
                LOGGER.info("- | faced_sd {}", (Object)d7);
                int[] nArray33 = PlotAnalysis.rank(nArray7);
                int[] nArray34 = PlotAnalysis.getSD(nArray33, nArray11);
                int[] nArray35 = PlotAnalysis.square(nArray34);
                int n11 = PlotAnalysis.sum(nArray35);
                double d8 = PlotAnalysis.getCC(n2, n11);
                auto_Clear.CALIBRATION.DATA_SD = d8 == 1.0 ? 0 : (int)(d8 * 1000.0 / MathMan.getMean(nArray7));
                LOGGER.info("- | data_sd {}", (Object)d8);
                int[] nArray36 = PlotAnalysis.rank(nArray8);
                int[] nArray37 = PlotAnalysis.getSD(nArray36, nArray11);
                int[] nArray38 = PlotAnalysis.square(nArray37);
                int n12 = PlotAnalysis.sum(nArray38);
                double d9 = PlotAnalysis.getCC(n2, n12);
                auto_Clear.CALIBRATION.AIR_SD = d9 == 1.0 ? 0 : (int)(d9 * 1000.0 / MathMan.getMean(nArray8));
                LOGGER.info("- | air_sd {}", (Object)d9);
                int[] nArray39 = PlotAnalysis.rank(nArray9);
                int[] nArray40 = PlotAnalysis.getSD(nArray39, nArray11);
                int[] nArray41 = PlotAnalysis.square(nArray40);
                int n13 = PlotAnalysis.sum(nArray41);
                double d10 = PlotAnalysis.getCC(n2, n13);
                auto_Clear.CALIBRATION.VARIETY_SD = d10 == 1.0 ? 0 : (int)(d10 * 1000.0 / MathMan.getMean(nArray9));
                LOGGER.info("- | variety_sd {}", (Object)d10);
                int[] nArray42 = new int[n2];
                LOGGER.info("Calculating threshold");
                int n14 = 0;
                int n15 = 0;
                for (n = 0; n < n2; ++n) {
                    iterator = (Plot)list.get(n);
                    PlotAnalysis plotAnalysis = ((Plot)((Object)iterator)).getComplexity(auto_Clear);
                    nArray42[n] = plotAnalysis.complexity;
                    if (plotAnalysis.complexity < n15) {
                        n15 = plotAnalysis.complexity;
                        continue;
                    }
                    if (plotAnalysis.complexity <= n14) continue;
                    n14 = plotAnalysis.complexity;
                }
                n = Integer.MAX_VALUE;
                if (n15 > 0 && n14 < 102400) {
                    iterator = (Iterator)PlotAnalysis.rank(nArray42, n14 + 1);
                    for (int i = 0; i < n2; ++i) {
                        if (iterator[i] != n3) continue;
                        n = nArray42[i];
                        break;
                    }
                    PlotAnalysis.logln("Complexity: ");
                    PlotAnalysis.logln(iterator);
                    PlotAnalysis.logln("Ratings: ");
                    PlotAnalysis.logln(nArray11);
                    PlotAnalysis.logln("Correlation: ");
                    PlotAnalysis.logln(PlotAnalysis.getCC(n2, PlotAnalysis.sum(PlotAnalysis.square(PlotAnalysis.getSD((int[])iterator, nArray11)))));
                    if (n == Integer.MAX_VALUE) {
                        LOGGER.info("Insufficient data to determine correlation! {} | {}", (Object)n3, (Object)n2);
                        running = false;
                        for (Plot plot3 : list) {
                            plot3.removeRunning();
                        }
                        return;
                    }
                } else {
                    iterator = (Iterator)((int[])nArray42.clone());
                    PlotAnalysis.sort((int[])iterator);
                    PlotAnalysis.logln("Complexity: ");
                    PlotAnalysis.logln(nArray42);
                    PlotAnalysis.logln("Ratings: ");
                    PlotAnalysis.logln(nArray11);
                }
                LOGGER.info("Saving calibration");
                Settings.AUTO_CLEAR.put("auto-calibrated", auto_Clear);
                Settings.save(PlotSquared.get().getWorldsFile());
                running = false;
                for (Plot plot4 : list) {
                    plot4.removeRunning();
                }
                LOGGER.info("Done!");
                runnable.run();
            }
        });
    }

    public static void logln(Object object) {
        LOGGER.info(PlotAnalysis.log(object));
    }

    public static String log(Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        if (object.getClass().isArray()) {
            String string = "";
            for (int i = 0; i < Array.getLength(object); ++i) {
                stringBuilder.append(string).append(PlotAnalysis.log(Array.get(object, i)));
                string = ",";
            }
            return "( " + stringBuilder + " )";
        }
        if (object instanceof List) {
            String string = "";
            for (Object e : (List)object) {
                stringBuilder.append(string).append(PlotAnalysis.log(e));
                string = ",";
            }
            return "[ " + stringBuilder + " ]";
        }
        return object.toString();
    }

    public static double getCC(int n, int n2) {
        return 1.0 - 6.0 * (double)n2 / (double)(n * (n * n - 1));
    }

    public static int sum(int[] nArray) {
        return Arrays.stream(nArray).sum();
    }

    public static int[] square(int[] nArray) {
        nArray = (int[])nArray.clone();
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            nArray[n] = nArray[n] * nArray[i];
        }
        return nArray;
    }

    public static int[] getSD(int[] ... nArray) {
        if (nArray.length == 0) {
            return null;
        }
        int[] nArray2 = new int[nArray[0].length];
        for (int i = 0; i < nArray[0].length; ++i) {
            int n = 0;
            for (int[] nArray3 : nArray) {
                n += nArray3[i];
            }
            int n2 = n / nArray.length;
            int n3 = 0;
            for (int[] nArray4 : nArray) {
                int n4 = nArray4[i];
                n3 += n4 < n2 ? n2 - n4 : n4 - n2;
            }
            nArray2[i] = n3;
        }
        return nArray2;
    }

    public static int[] rank(int[] nArray) {
        return PlotAnalysis.rank(nArray, 102400);
    }

    public static int[] rank(int[] nArray, int n) {
        int n2;
        int n3;
        int n4;
        int[] nArray2 = new int[n];
        int n5 = 0;
        if (nArray.length < n) {
            var4_4 = nArray;
            n4 = var4_4.length;
            for (n3 = 0; n3 < n4; ++n3) {
                n2 = var4_4[n3];
                if (n2 > n5) {
                    n5 = n2;
                }
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + 1;
            }
        } else {
            n5 = nArray2.length - 1;
            var4_4 = nArray;
            n4 = var4_4.length;
            for (n3 = 0; n3 < n4; ++n3) {
                int n7 = n2 = var4_4[n3];
                nArray2[n7] = nArray2[n7] + 1;
            }
        }
        int n8 = 0;
        for (n4 = n5; n4 >= 0; --n4) {
            if (nArray2[n4] == 0) continue;
            int n9 = n4;
            nArray2[n9] = nArray2[n9] + n8;
            n8 = nArray2[n4];
            if (n8 == nArray.length) break;
        }
        int[] nArray3 = new int[nArray.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            n2 = nArray[n3];
            nArray3[n3] = nArray2[n2];
            int n10 = n2;
            nArray2[n10] = nArray2[n10] - 1;
        }
        return nArray3;
    }

    public static void sort(int[] nArray) {
        int n;
        int n2 = 10;
        ArrayList[] arrayListArray = new ArrayList[n2];
        for (n = 0; n < arrayListArray.length; ++n) {
            arrayListArray[n] = new ArrayList();
        }
        n = 0;
        int n3 = 1;
        while (n == 0) {
            n = 1;
            int[] nArray2 = nArray;
            int n4 = nArray2.length;
            for (int i = 0; i < n4; ++i) {
                Integer n5 = nArray2[i];
                int n6 = n5 / n3;
                arrayListArray[n6 % n2].add(n5);
                if (n == 0 || n6 <= 0) continue;
                n = 0;
            }
            int n7 = 0;
            for (n4 = 0; n4 < n2; ++n4) {
                for (Integer n5 : arrayListArray[n4]) {
                    nArray[n7++] = n5;
                }
                arrayListArray[n4].clear();
            }
            n3 *= n2;
        }
    }

    public List<Integer> asList() {
        return Arrays.asList(this.changes, this.faces, this.data, this.air, this.variety, this.changes_sd, this.faces_sd, this.data_sd, this.air_sd, this.variety_sd);
    }

    public int getComplexity(Settings.Auto_Clear auto_Clear) {
        Settings.Auto_Clear.CALIBRATION cALIBRATION = auto_Clear.CALIBRATION;
        if (this.complexity != 0) {
            return this.complexity;
        }
        this.complexity = this.changes * cALIBRATION.CHANGES + this.faces * cALIBRATION.FACES + this.data * cALIBRATION.DATA + this.air * cALIBRATION.AIR + this.variety * cALIBRATION.VARIETY + this.changes_sd * cALIBRATION.CHANGES_SD + this.faces_sd * cALIBRATION.FACES_SD + this.data_sd * cALIBRATION.DATA_SD + this.air_sd * cALIBRATION.AIR_SD + this.variety_sd * cALIBRATION.VARIETY_SD;
        return this.complexity;
    }
}

