/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import java.util.Arrays;
import java.util.Collection;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GamemodeFlag
extends PlotFlag<GameMode, GamemodeFlag> {
    public static final GameMode DEFAULT = new GameMode("default");
    public static final GamemodeFlag GAMEMODE_FLAG_CREATIVE = new GamemodeFlag(GameModes.CREATIVE);
    public static final GamemodeFlag GAMEMODE_FLAG_ADVENTURE = new GamemodeFlag(GameModes.ADVENTURE);
    public static final GamemodeFlag GAMEMODE_FLAG_SPECTATOR = new GamemodeFlag(GameModes.SPECTATOR);
    public static final GamemodeFlag GAMEMODE_FLAG_SURVIVAL = new GamemodeFlag(GameModes.SURVIVAL);
    public static final GamemodeFlag GAMEMODE_FLAG_DEFAULT = new GamemodeFlag(DEFAULT);

    protected GamemodeFlag(@NonNull GameMode gameMode) {
        super(gameMode, TranslatableCaption.of("flags.flag_category_gamemode"), TranslatableCaption.of("flags.flag_description_gamemode"));
    }

    @Override
    public GamemodeFlag parse(@NonNull String string) {
        return switch (string) {
            case "creative", "c", "1" -> this.flagOf(GameModes.CREATIVE);
            case "adventure", "a", "2" -> this.flagOf(GameModes.ADVENTURE);
            case "spectator", "sp", "3" -> this.flagOf(GameModes.SPECTATOR);
            case "survival", "s", "0" -> this.flagOf(GameModes.SURVIVAL);
            default -> this.flagOf(DEFAULT);
        };
    }

    @Override
    public GamemodeFlag merge(@NonNull GameMode gameMode) {
        return this.flagOf(gameMode);
    }

    @Override
    public String toString() {
        return ((GameMode)this.getValue()).getId();
    }

    @Override
    public String getExample() {
        return "survival";
    }

    @Override
    protected GamemodeFlag flagOf(@NonNull GameMode gameMode) {
        return switch (gameMode.getId()) {
            case "creative" -> GAMEMODE_FLAG_CREATIVE;
            case "adventure" -> GAMEMODE_FLAG_ADVENTURE;
            case "spectator" -> GAMEMODE_FLAG_SPECTATOR;
            case "survival" -> GAMEMODE_FLAG_SURVIVAL;
            default -> GAMEMODE_FLAG_DEFAULT;
        };
    }

    @Override
    public Collection<String> getTabCompletions() {
        return Arrays.asList("survival", "creative", "adventure", "spectator");
    }

    static {
        GameModes.register((GameMode)DEFAULT);
    }
}

