/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.implementations;

import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.PlotFlag;
import com.plotsquared.core.plot.flag.implementations.GamemodeFlag;
import com.sk89q.worldedit.world.gamemode.GameMode;
import com.sk89q.worldedit.world.gamemode.GameModes;
import org.checkerframework.checker.nullness.qual.NonNull;

public class GuestGamemodeFlag
extends PlotFlag<GameMode, GuestGamemodeFlag> {
    public static final GuestGamemodeFlag GUEST_GAMEMODE_FLAG_CREATIVE = new GuestGamemodeFlag(GameModes.CREATIVE);
    public static final GuestGamemodeFlag GUEST_GAMEMODE_FLAG_ADVENTURE = new GuestGamemodeFlag(GameModes.ADVENTURE);
    public static final GuestGamemodeFlag GUEST_GAMEMODE_FLAG_SPECTATOR = new GuestGamemodeFlag(GameModes.SPECTATOR);
    public static final GuestGamemodeFlag GUEST_GAMEMODE_FLAG_SURVIVAL = new GuestGamemodeFlag(GameModes.SURVIVAL);
    public static final GuestGamemodeFlag GUEST_GAMEMODE_FLAG_DEFAULT = new GuestGamemodeFlag(GamemodeFlag.DEFAULT);

    protected GuestGamemodeFlag(@NonNull GameMode gameMode) {
        super(gameMode, TranslatableCaption.of("flags.flag_category_gamemode"), TranslatableCaption.of("flags.flag_description_guest_gamemode"));
    }

    @Override
    public GuestGamemodeFlag parse(@NonNull String string) {
        return switch (string) {
            case "creative", "c", "1" -> this.flagOf(GameModes.CREATIVE);
            case "adventure", "a", "2" -> this.flagOf(GameModes.ADVENTURE);
            case "spectator", "sp", "3" -> this.flagOf(GameModes.SPECTATOR);
            case "survival", "s", "0" -> this.flagOf(GameModes.SURVIVAL);
            default -> this.flagOf(GamemodeFlag.DEFAULT);
        };
    }

    @Override
    public GuestGamemodeFlag merge(@NonNull GameMode gameMode) {
        return this.flagOf(gameMode);
    }

    @Override
    public String toString() {
        return ((GameMode)this.getValue()).getId();
    }

    @Override
    public String getExample() {
        return "survival";
    }

    @Override
    protected GuestGamemodeFlag flagOf(@NonNull GameMode gameMode) {
        return switch (gameMode.getId()) {
            case "creative" -> GUEST_GAMEMODE_FLAG_CREATIVE;
            case "adventure" -> GUEST_GAMEMODE_FLAG_ADVENTURE;
            case "spectator" -> GUEST_GAMEMODE_FLAG_SPECTATOR;
            case "survival" -> GUEST_GAMEMODE_FLAG_SURVIVAL;
            default -> GUEST_GAMEMODE_FLAG_DEFAULT;
        };
    }
}

