/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.flag.types;

import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.plot.flag.FlagParseException;
import com.plotsquared.core.plot.flag.types.NumberFlag;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class LongFlag<F extends NumberFlag<Long, F>>
extends NumberFlag<Long, F> {
    protected LongFlag(@NonNull Long l, Long l2, Long l3, @NonNull Caption caption) {
        super(l, l2, l3, TranslatableCaption.of("flags.flag_category_integers"), caption);
    }

    protected LongFlag(@NonNull Long l, @NonNull Caption caption) {
        this(l, Long.MIN_VALUE, Long.MAX_VALUE, caption);
    }

    @Override
    public F merge(@NonNull Long l) {
        return (F)((NumberFlag)this.flagOf((Long)this.getValue() + l));
    }

    @Override
    public String toString() {
        return ((Long)this.getValue()).toString();
    }

    @Override
    public String getExample() {
        return "123456789";
    }

    @Override
    protected @NonNull Long parseNumber(String string) {
        try {
            return Long.parseLong(string);
        }
        catch (Throwable throwable) {
            throw new FlagParseException(this, string, TranslatableCaption.of("flags.flag_error_long"), new TagResolver[0]);
        }
    }

    @Override
    public boolean isValuedPermission() {
        return false;
    }
}

