/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.schematic;

import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicWriter;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockStateHolder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class Schematic {
    private final Clipboard clipboard;
    private Map<String, Tag> flags = new HashMap<String, Tag>();

    public Schematic(Clipboard clipboard) {
        this.clipboard = clipboard;
    }

    public boolean setBlock(BlockVector3 blockVector3, BaseBlock baseBlock) {
        if (this.clipboard.getRegion().contains(blockVector3)) {
            BlockVector3 blockVector32 = blockVector3.subtract(this.clipboard.getRegion().getMinimumPoint());
            this.clipboard.setBlock(blockVector32, (BlockStateHolder)baseBlock);
            return true;
        }
        return false;
    }

    public void save(File file) {
        try (SpongeSchematicWriter spongeSchematicWriter = new SpongeSchematicWriter(new NBTOutputStream((OutputStream)new FileOutputStream(file)));){
            spongeSchematicWriter.write(this.clipboard);
        }
    }

    public Clipboard getClipboard() {
        return this.clipboard;
    }

    public Map<String, Tag> getFlags() {
        return this.flags;
    }

    public void setFlags(Map<String, Tag> hashMap) {
        this.flags = hashMap == null ? new HashMap() : hashMap;
    }
}

