/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.plot.world;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.ConfigurationNode;
import com.plotsquared.core.configuration.ConfigurationSection;
import com.plotsquared.core.configuration.ConfigurationUtil;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.configuration.file.YamlConfiguration;
import com.plotsquared.core.generator.GridPlotWorld;
import com.plotsquared.core.generator.SingleWorldGenerator;
import com.plotsquared.core.inject.annotations.WorldConfig;
import com.plotsquared.core.listener.PlotListener;
import com.plotsquared.core.location.BlockLoc;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.plot.PlotManager;
import com.plotsquared.core.plot.PlotSettings;
import com.plotsquared.core.plot.flag.FlagContainer;
import com.plotsquared.core.plot.world.PlotAreaManager;
import com.plotsquared.core.plot.world.SinglePlot;
import com.plotsquared.core.plot.world.SinglePlotManager;
import com.plotsquared.core.queue.GlobalBlockQueue;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.util.EventDispatcher;
import com.plotsquared.core.util.task.TaskManager;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SinglePlotArea
extends GridPlotWorld {
    private final EventDispatcher eventDispatcher;
    private final PlotListener plotListener;
    public boolean VOID = false;

    public SinglePlotArea(@NonNull PlotAreaManager plotAreaManager, @NonNull EventDispatcher eventDispatcher, @NonNull PlotListener plotListener, @WorldConfig @NonNull YamlConfiguration yamlConfiguration, @NonNull GlobalBlockQueue globalBlockQueue) {
        super("*", null, new SingleWorldGenerator(plotAreaManager), null, null, yamlConfiguration, globalBlockQueue);
        this.eventDispatcher = eventDispatcher;
        this.plotListener = plotListener;
        this.setAllowSigns(false);
        this.setDefaultHome(new BlockLoc(Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE));
    }

    public static boolean isSinglePlotWorld(String string) {
        int n = string.length();
        int n2 = 0;
        block4: for (int i = 0; i < n; ++i) {
            switch (string.charAt(i)) {
                case '_': {
                    ++n2;
                    continue block4;
                }
                case '-': 
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    continue block4;
                }
                default: {
                    return false;
                }
            }
        }
        return n2 == 1;
    }

    @Override
    protected @NonNull PlotManager createManager() {
        return new SinglePlotManager(this);
    }

    @Override
    public void loadConfiguration(ConfigurationSection configurationSection) {
        this.VOID = configurationSection.getBoolean("void", false);
    }

    @Override
    public void saveConfiguration(ConfigurationSection configurationSection) {
        super.saveConfiguration(configurationSection);
    }

    public void loadWorld(PlotId plotId) {
        String string = plotId.toUnderscoreSeparatedString();
        if (PlotSquared.platform().worldUtil().isWorld(string)) {
            return;
        }
        PlotAreaBuilder plotAreaBuilder = PlotAreaBuilder.newBuilder().plotManager("PlotSquared:single").generatorName("PlotSquared:single").plotAreaType(this.getType()).terrainType(this.getTerrain()).settingsNodesWrapper(new SettingsNodesWrapper(new ConfigurationNode[0], null)).worldName(string);
        File file = PlotSquared.platform().worldContainer();
        File file2 = new File(file, string);
        File file3 = new File(file, plotId.toCommaSeparatedString());
        if (file3.exists()) {
            file3.renameTo(file2);
        } else {
            file3 = new File(file, plotId.toSeparatedString("."));
            if (file3.exists()) {
                file3.renameTo(file2);
            }
        }
        if (plotAreaBuilder.plotAreaType() != PlotAreaType.NORMAL && !file2.exists() && (file3 = new File(file, "0_0")).exists()) {
            File file4;
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if ((file4 = new File(file3, "level.dat")).exists()) {
                try {
                    Files.copy(file4.toPath(), new File(file2, file4.getName()).toPath(), new CopyOption[0]);
                    File file5 = new File(file3, "data");
                    if (file5.exists()) {
                        File file6 = new File(file2, "data");
                        file6.mkdirs();
                        for (File file7 : file5.listFiles()) {
                            Files.copy(file7.toPath(), new File(file6, file7.getName()).toPath(), new CopyOption[0]);
                        }
                    }
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        try {
            TaskManager.getPlatformImplementation().sync(() -> {
                String string = plotId.toUnderscoreSeparatedString();
                if (!PlotSquared.platform().worldUtil().isWorld(string)) {
                    PlotSquared.platform().setupUtils().setupWorld(plotAreaBuilder);
                }
                return null;
            });
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @Override
    public ConfigurationNode[] getSettingNodes() {
        return new ConfigurationNode[]{new ConfigurationNode("void", this.VOID, TranslatableCaption.of("setup.singleplotarea_void_world"), ConfigurationUtil.BOOLEAN)};
    }

    @Override
    public @Nullable Plot getOwnedPlot(@NonNull Location location) {
        PlotId plotId = PlotId.fromStringOrNull(location.getWorldName());
        Plot plot = plotId == null ? null : (Plot)this.plots.get(plotId);
        return plot == null ? null : plot.getBasePlot(false);
    }

    @Override
    public @Nullable Plot getOwnedPlotAbs(@NonNull Location location) {
        PlotId plotId = PlotId.fromStringOrNull(location.getWorldName());
        return plotId == null ? null : (Plot)this.plots.get(plotId);
    }

    @Override
    public @Nullable Plot getPlot(@NonNull Location location) {
        PlotId plotId = PlotId.fromStringOrNull(location.getWorldName());
        return plotId == null ? null : this.getPlot(plotId);
    }

    @Override
    public @Nullable Plot getPlotAbs(@NonNull Location location) {
        PlotId plotId = PlotId.fromStringOrNull(location.getWorldName());
        return plotId == null ? null : this.getPlotAbs(plotId);
    }

    @Override
    public boolean addPlot(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlot(plot);
    }

    @Override
    public boolean addPlotAbs(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlotAbs(plot);
    }

    @Override
    public boolean addPlotIfAbsent(@NonNull Plot plot) {
        plot = this.adapt(plot);
        return super.addPlotIfAbsent(plot);
    }

    @Override
    public boolean allowSigns() {
        return false;
    }

    protected Plot adapt(Plot plot) {
        if (plot instanceof SinglePlot) {
            return plot;
        }
        PlotSettings plotSettings = plot.getSettings();
        FlagContainer flagContainer = plot.getFlagContainer();
        plot = new SinglePlot(plot.getId(), plot.getOwnerAbs(), plot.getTrusted(), plot.getMembers(), plot.getDenied(), plotSettings.getAlias(), plotSettings.getPosition(), null, this, plotSettings.getMerged(), plot.getTimestamp(), plot.temp);
        plot.getFlagContainer().addAll(flagContainer);
        return plot;
    }

    @Override
    public @Nullable Plot getPlotAbs(@NonNull PlotId plotId) {
        Plot plot = this.getOwnedPlotAbs(plotId);
        if (plot == null) {
            return new SinglePlot(this, plotId);
        }
        return plot;
    }

    @Override
    public @Nullable Plot getPlot(@NonNull PlotId plotId) {
        Plot plot = this.getOwnedPlotAbs(plotId);
        if (plot == null) {
            return new SinglePlot(this, plotId);
        }
        return plot.getBasePlot(false);
    }
}

