/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.queue.DelegateQueueCoordinator;
import com.plotsquared.core.queue.QueueCoordinator;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.function.pattern.Pattern;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockState;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AreaBoundDelegateQueueCoordinator
extends DelegateQueueCoordinator {
    private final PlotArea area;

    public AreaBoundDelegateQueueCoordinator(@NonNull PlotArea plotArea, @Nullable QueueCoordinator queueCoordinator) {
        super(queueCoordinator);
        this.area = Objects.requireNonNull(plotArea);
    }

    public PlotArea getArea() {
        return this.area;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BlockState blockState) {
        if (this.area.contains(n, n3)) {
            return super.setBlock(n, n2, n3, blockState);
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        if (this.area.contains(n, n3)) {
            return super.setBlock(n, n2, n3, baseBlock);
        }
        return false;
    }

    @Override
    public boolean setBlock(int n, int n2, int n3, @NonNull Pattern pattern) {
        if (this.area.contains(n, n3)) {
            return super.setBlock(n, n2, n3, pattern);
        }
        return false;
    }

    @Override
    public boolean setBiome(int n, int n2, @NonNull BiomeType biomeType) {
        if (this.area.contains(n, n2)) {
            return super.setBiome(n, n2, biomeType);
        }
        return false;
    }

    @Override
    public boolean setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        if (this.area.contains(n, n3)) {
            return super.setBiome(n, n2, n3, biomeType);
        }
        return false;
    }

    @Override
    public boolean setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        if (this.area.contains(n, n3)) {
            return super.setTile(n, n2, n3, compoundTag);
        }
        return false;
    }
}

