/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.queue;

import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.ChunkUtil;
import com.plotsquared.core.util.MathMan;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.worldedit.entity.BaseEntity;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.util.Location;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import java.util.HashMap;
import org.checkerframework.checker.nullness.qual.NonNull;

public class LocalChunk {
    private final QueueCoordinator parent;
    private final int x;
    private final int z;
    private final int minSection;
    private final BaseBlock[][] baseblocks;
    private final BiomeType[][] biomes;
    private final HashMap<BlockVector3, CompoundTag> tiles = new HashMap();
    private final HashMap<Location, BaseEntity> entities = new HashMap();

    public LocalChunk(@NonNull QueueCoordinator queueCoordinator, int n, int n2) {
        this.parent = queueCoordinator;
        this.x = n;
        this.z = n2;
        this.minSection = queueCoordinator.getMinLayer();
        int n3 = queueCoordinator.getMaxLayer() - queueCoordinator.getMinLayer() + 1;
        this.baseblocks = new BaseBlock[n3][];
        this.biomes = new BiomeType[n3][];
    }

    public @NonNull QueueCoordinator getParent() {
        return this.parent;
    }

    public int getX() {
        return this.x;
    }

    public int getZ() {
        return this.z;
    }

    public int getMinSection() {
        return this.minSection;
    }

    public @NonNull BaseBlock[][] getBaseblocks() {
        return this.baseblocks;
    }

    public @NonNull BiomeType[][] getBiomes() {
        return this.biomes;
    }

    public @NonNull HashMap<BlockVector3, CompoundTag> getTiles() {
        return this.tiles;
    }

    public void setBiome(int n, int n2, int n3, @NonNull BiomeType biomeType) {
        int n4 = this.getLayerIndex(n2);
        int n5 = ChunkUtil.getJ(n, n2, n3);
        BiomeType[] biomeTypeArray = this.biomes[n4];
        if (biomeTypeArray == null) {
            this.biomes[n4] = new BiomeType[4096];
            biomeTypeArray = this.biomes[n4];
        }
        biomeTypeArray[n5] = biomeType;
    }

    public int hashCode() {
        return MathMan.pair((short)this.x, (short)this.z);
    }

    public void setBlock(int n, int n2, int n3, @NonNull BaseBlock baseBlock) {
        int n4 = this.getLayerIndex(n2);
        int n5 = ChunkUtil.getJ(n, n2, n3);
        BaseBlock[] baseBlockArray = this.baseblocks[n4];
        if (baseBlockArray == null) {
            this.baseblocks[n4] = new BaseBlock[4096];
            baseBlockArray = this.baseblocks[n4];
        }
        baseBlockArray[n5] = baseBlock;
    }

    public void setTile(int n, int n2, int n3, @NonNull CompoundTag compoundTag) {
        this.tiles.put(BlockVector3.at((int)n, (int)n2, (int)n3), compoundTag);
    }

    public void setEntity(@NonNull Location location, @NonNull BaseEntity baseEntity) {
        this.entities.put(location, baseEntity);
    }

    public @NonNull HashMap<Location, BaseEntity> getEntities() {
        return this.entities;
    }

    private int getLayerIndex(int n) {
        return (n >> 4) - this.minSection;
    }
}

