/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.setup;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.TeleportCause;
import com.plotsquared.core.generator.GeneratorWrapper;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.PlotAreaTerrainType;
import com.plotsquared.core.plot.PlotAreaType;
import com.plotsquared.core.plot.PlotId;
import com.plotsquared.core.setup.PlotAreaBuilder;
import com.plotsquared.core.setup.SettingsNodesWrapper;
import com.plotsquared.core.setup.SetupStep;
import com.plotsquared.core.util.SetupUtils;
import com.plotsquared.core.util.StringMan;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public enum CommonSetupSteps implements SetupStep
{
    CHOOSE_GENERATOR(TranslatableCaption.of("setup.setup_init")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            if (!SetupUtils.generators.containsKey(string)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_generator_error"), new TagResolver[0]);
                return this;
            }
            plotAreaBuilder.generatorName(string);
            return CHOOSE_PLOT_AREA_TYPE;
        }

        @Override
        public Collection<String> getSuggestions() {
            return Collections.unmodifiableSet(SetupUtils.generators.keySet());
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotSquared.platform().pluginName();
        }
    }
    ,
    CHOOSE_PLOT_AREA_TYPE(PlotAreaType.class, (Caption)TranslatableCaption.of("setup.setup_world_type")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            Optional<PlotAreaType> optional = PlotAreaType.fromString(string);
            if (!optional.isPresent()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_type_error"), new TagResolver[0]);
                return this;
            }
            plotAreaBuilder.plotAreaType(optional.get());
            GeneratorWrapper<?> generatorWrapper = SetupUtils.generators.get(plotAreaBuilder.generatorName());
            if (plotAreaBuilder.plotAreaType() == PlotAreaType.NORMAL) {
                if (plotAreaBuilder.settingsNodesWrapper() == null) {
                    plotAreaBuilder.plotManager(plotAreaBuilder.generatorName());
                    plotAreaBuilder.settingsNodesWrapper(CommonSetupSteps.wrap(plotAreaBuilder.plotManager()));
                    SetupUtils.generators.get(plotAreaBuilder.plotManager()).getPlotGenerator().processAreaSetup(plotAreaBuilder);
                }
                return plotAreaBuilder.settingsNodesWrapper().getFirstStep();
            }
            if (generatorWrapper.isFull()) {
                plotAreaBuilder.plotManager(plotAreaBuilder.generatorName());
                plotAreaBuilder.generatorName(null);
                plotAreaBuilder.settingsNodesWrapper(CommonSetupSteps.wrap(plotAreaBuilder.plotManager()));
                SetupUtils.generators.get(plotAreaBuilder.plotManager()).getPlotGenerator().processAreaSetup(plotAreaBuilder);
            } else {
                plotAreaBuilder.plotManager(PlotSquared.platform().pluginName());
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_generator_error"), new TagResolver[0]);
                plotAreaBuilder.settingsNodesWrapper(CommonSetupSteps.wrap(plotAreaBuilder.plotManager()));
            }
            if (plotAreaBuilder.plotAreaType() == PlotAreaType.PARTIAL) {
                return CHOOSE_AREA_ID;
            }
            return CHOOSE_TERRAIN_TYPE;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotAreaType.NORMAL.toString();
        }
    }
    ,
    CHOOSE_AREA_ID(TranslatableCaption.of("setup.setup_area_name")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            if (!StringMan.isAlphanumericUnd(string)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_non_alphanumerical"), new TagResolver[0]);
                return this;
            }
            for (PlotArea plotArea : PlotSquared.get().getPlotAreaManager().getAllPlotAreas()) {
                if (plotArea.getId() == null || !plotArea.getId().equalsIgnoreCase(string)) continue;
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_invalid_id"), new TagResolver[0]);
                return this;
            }
            plotAreaBuilder.areaName(string);
            return CHOOSE_MINIMUM_PLOT_ID;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return null;
        }
    }
    ,
    CHOOSE_MINIMUM_PLOT_ID(TranslatableCaption.of("setup.setup_area_min_plot_id")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            try {
                plotAreaBuilder.minimumId(PlotId.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_min_plot_id_error"), new TagResolver[0]);
                return this;
            }
            catch (IllegalStateException illegalStateException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_plot_id_greater_than_minimum"), new TagResolver[0]);
                return this;
            }
            return CHOOSE_MAXIMUM_PLOT_ID;
        }

        @Override
        public String getDefaultValue() {
            return "0;0";
        }
    }
    ,
    CHOOSE_MAXIMUM_PLOT_ID(TranslatableCaption.of("setup.setup_area_max_plot_id")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            try {
                plotAreaBuilder.maximumId(PlotId.fromString(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_max_plot_id_error"), new TagResolver[0]);
                return this;
            }
            catch (IllegalStateException illegalStateException) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_area_plot_id_greater_than_minimum"), new TagResolver[0]);
                return this;
            }
            return CHOOSE_TERRAIN_TYPE;
        }

        @Override
        public String getDefaultValue() {
            return "0;0";
        }
    }
    ,
    CHOOSE_TERRAIN_TYPE(PlotAreaTerrainType.class, (Caption)TranslatableCaption.of("setup.setup_partial_area")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            Optional<PlotAreaTerrainType> optional = PlotAreaTerrainType.fromString(string);
            if (!optional.isPresent()) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_partial_area_error"), new TagResolver[0]);
                return this;
            }
            plotAreaBuilder.terrainType(optional.get());
            if (plotAreaBuilder.settingsNodesWrapper() == null) {
                plotAreaBuilder.settingsNodesWrapper(CommonSetupSteps.wrap(plotAreaBuilder.plotManager()));
            }
            SettingsNodesWrapper settingsNodesWrapper = plotAreaBuilder.settingsNodesWrapper();
            return settingsNodesWrapper.getFirstStep();
        }

        @Override
        public @Nullable String getDefaultValue() {
            return PlotAreaTerrainType.NONE.toString();
        }
    }
    ,
    CHOOSE_WORLD_NAME(TranslatableCaption.of("setup.setup_world_name")){

        @Override
        public SetupStep handleInput(PlotPlayer<?> plotPlayer, PlotAreaBuilder plotAreaBuilder, String string) {
            if (!CommonSetupSteps.isValidWorldName(string)) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_name_format"), new TagResolver[0]);
                return this;
            }
            if (PlotSquared.platform().worldUtil().isWorld(string)) {
                if (PlotSquared.get().getPlotAreaManager().hasPlotArea(string)) {
                    plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_taken"), TagResolver.resolver("value", Tag.inserting(Component.text(string))));
                    return this;
                }
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_world_apply_plotsquared"), new TagResolver[0]);
            }
            plotAreaBuilder.worldName(string);
            try (Object object = plotPlayer.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_SETUP);){
                ((MetaDataAccess)object).remove();
            }
            object = plotAreaBuilder.setupManager() == null ? PlotSquared.platform().injector().getInstance(SetupUtils.class).setupWorld(plotAreaBuilder) : plotAreaBuilder.setupManager().setupWorld(plotAreaBuilder);
            try {
                plotPlayer.teleport(PlotSquared.platform().worldUtil().getSpawn((String)object), TeleportCause.COMMAND_SETUP);
            }
            catch (Exception exception) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("errors.error_console"), new TagResolver[0]);
                exception.printStackTrace();
            }
            plotPlayer.sendMessage((Caption)TranslatableCaption.of("setup.setup_finished"), new TagResolver[0]);
            return null;
        }

        @Override
        public @Nullable String getDefaultValue() {
            return null;
        }
    };

    private final @NonNull Collection<String> suggestions;
    private final Caption description;

    private CommonSetupSteps(Collection<String> collection, Caption caption) {
        this.suggestions = collection;
        this.description = caption;
    }

    private CommonSetupSteps(Caption caption) {
        this.description = caption;
        this.suggestions = Collections.emptyList();
    }

    private <E extends Enum<E>> CommonSetupSteps(Class<E> clazz, Caption caption) {
        this(CommonSetupSteps.enumToStrings(clazz), caption);
    }

    private static <E extends Enum<E>> Collection<String> enumToStrings(Class<E> clazz) {
        return Arrays.stream((Enum[])clazz.getEnumConstants()).map(enum_ -> enum_.toString().toLowerCase()).collect(Collectors.toList());
    }

    private static SettingsNodesWrapper wrap(String string) {
        return new SettingsNodesWrapper(SetupUtils.generators.get(string).getPlotGenerator().getNewPlotArea("CheckingPlotSquaredGenerator", null, null, null).getSettingNodes(), CHOOSE_WORLD_NAME);
    }

    private static boolean isValidWorldName(String string) {
        return string.chars().allMatch(n -> n == 95 || n == 45 || n >= 97 && n <= 122 || n >= 65 && n <= 90 || n >= 48 && n <= 57 || n == 46);
    }

    @Override
    public void announce(PlotPlayer<?> plotPlayer) {
        plotPlayer.sendMessage(this.description, new TagResolver[0]);
    }

    @Override
    public @NonNull Collection<String> getSuggestions() {
        return this.suggestions;
    }
}

