/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.synchronization;

import com.google.common.util.concurrent.Striped;
import com.plotsquared.core.synchronization.LockKey;
import java.util.concurrent.locks.Lock;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class LockRepository {
    private final Striped<Lock> striped = Striped.lock((int)LockKey.recognizedKeys().size());

    public @NonNull Lock getLock(@NonNull LockKey lockKey) {
        return (Lock)this.striped.get((Object)lockKey);
    }

    public void useLock(@NonNull LockKey lockKey, @NonNull Consumer<Lock> consumer) {
        consumer.accept(this.getLock(lockKey));
    }

    public void useLock(@NonNull LockKey lockKey, @NonNull Runnable runnable) {
        try (LockAccess lockAccess = this.lock(lockKey);){
            runnable.run();
        }
    }

    public @NonNull LockAccess lock(@NonNull LockKey lockKey) {
        Lock lock = this.getLock(lockKey);
        lock.lock();
        return new LockAccess(lock);
    }

    public static class LockAccess
    implements AutoCloseable {
        private final Lock lock;

        private LockAccess(@NonNull Lock lock) {
            this.lock = lock;
        }

        @Override
        public void close() {
            this.lock.unlock();
        }
    }
}

