/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.location.Location;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.queue.ZeroedDelegateScopedQueueCoordinator;
import com.plotsquared.core.util.task.RunnableVal;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.world.World;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;

public abstract class ChunkManager {
    private static final Map<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>> forceChunks = new ConcurrentHashMap<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>>();
    private static final Map<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>> addChunks = new ConcurrentHashMap<BlockVector2, RunnableVal<ZeroedDelegateScopedQueueCoordinator>>();

    public static void setChunkInPlotArea(RunnableVal<ZeroedDelegateScopedQueueCoordinator> runnableVal, RunnableVal<ZeroedDelegateScopedQueueCoordinator> runnableVal2, String string, BlockVector2 blockVector2) {
        World world = PlotSquared.platform().worldUtil().getWeWorld(string);
        QueueCoordinator queueCoordinator = PlotSquared.platform().globalBlockQueue().getNewQueue(world);
        if (PlotSquared.get().getPlotAreaManager().isAugmented(string) && PlotSquared.get().isNonStandardGeneration(string, blockVector2)) {
            int n = blockVector2.getX() << 4;
            int n2 = blockVector2.getZ() << 4;
            ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator = new ZeroedDelegateScopedQueueCoordinator(queueCoordinator, Location.at(string, n, world.getMinY(), n2), Location.at(string, n + 15, world.getMaxY(), n2 + 15));
            if (runnableVal != null) {
                runnableVal.run(zeroedDelegateScopedQueueCoordinator);
            } else {
                zeroedDelegateScopedQueueCoordinator.regenChunk(blockVector2.getX(), blockVector2.getZ());
                if (runnableVal2 != null) {
                    runnableVal2.run(zeroedDelegateScopedQueueCoordinator);
                }
            }
            queueCoordinator.enqueue();
        } else {
            if (runnableVal != null) {
                forceChunks.put(blockVector2, runnableVal);
            }
            addChunks.put(blockVector2, runnableVal2);
            queueCoordinator.regenChunk(blockVector2.getX(), blockVector2.getZ());
            forceChunks.remove(blockVector2);
            addChunks.remove(blockVector2);
        }
    }

    public static boolean preProcessChunk(BlockVector2 blockVector2, ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator) {
        RunnableVal<ZeroedDelegateScopedQueueCoordinator> runnableVal = forceChunks.get(blockVector2);
        if (runnableVal != null) {
            runnableVal.run(zeroedDelegateScopedQueueCoordinator);
            forceChunks.remove(blockVector2);
            return true;
        }
        return false;
    }

    public static boolean postProcessChunk(BlockVector2 blockVector2, ZeroedDelegateScopedQueueCoordinator zeroedDelegateScopedQueueCoordinator) {
        RunnableVal<ZeroedDelegateScopedQueueCoordinator> runnableVal = forceChunks.get(blockVector2);
        if (runnableVal != null) {
            runnableVal.run(zeroedDelegateScopedQueueCoordinator);
            addChunks.remove(blockVector2);
            return true;
        }
        return false;
    }

    @Deprecated
    public abstract CompletableFuture<?> loadChunk(String var1, BlockVector2 var2, boolean var3);
}

