/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.player.ConsolePlayer;
import com.plotsquared.core.player.OfflinePlotPlayer;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.PlotArea;
import org.checkerframework.checker.nullness.qual.NonNull;

public abstract class EconHandler {
    public static EconHandler nullEconHandler() {
        return new NullEconHandler();
    }

    public abstract boolean init();

    public double getMoney(PlotPlayer<?> plotPlayer) {
        if (plotPlayer instanceof ConsolePlayer) {
            return Double.MAX_VALUE;
        }
        return this.getBalance(plotPlayer);
    }

    public abstract double getBalance(PlotPlayer<?> var1);

    public abstract void withdrawMoney(PlotPlayer<?> var1, double var2);

    public abstract void depositMoney(PlotPlayer<?> var1, double var2);

    public abstract void depositMoney(OfflinePlotPlayer var1, double var2);

    public abstract boolean isEnabled(PlotArea var1);

    public abstract @NonNull String format(double var1);

    public abstract boolean isSupported();

    private static final class NullEconHandler
    extends EconHandler {
        private NullEconHandler() {
        }

        @Override
        public boolean init() {
            return false;
        }

        @Override
        public double getBalance(PlotPlayer<?> plotPlayer) {
            return Double.MIN_VALUE;
        }

        @Override
        public void withdrawMoney(PlotPlayer<?> plotPlayer, double d) {
        }

        @Override
        public void depositMoney(PlotPlayer<?> plotPlayer, double d) {
        }

        @Override
        public void depositMoney(OfflinePlotPlayer offlinePlotPlayer, double d) {
        }

        @Override
        public boolean isEnabled(PlotArea plotArea) {
            return false;
        }

        @Override
        public @NonNull String format(double d) {
            return "";
        }

        @Override
        public boolean isSupported() {
            return false;
        }
    }
}

