/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.plotsquared.core.location.Location;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import java.util.Collection;
import java.util.Iterator;
import org.checkerframework.checker.nullness.qual.NonNull;

public class RegionUtil {
    public static @NonNull Location[] getCorners(@NonNull String string, @NonNull CuboidRegion cuboidRegion) {
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        return new Location[]{Location.at(string, blockVector3), Location.at(string, blockVector32)};
    }

    public static @NonNull Location[] getCorners(String string, Collection<CuboidRegion> collection) {
        CuboidRegion cuboidRegion = RegionUtil.getAxisAlignedBoundingBox(collection);
        return RegionUtil.getCorners(string, cuboidRegion);
    }

    public static @NonNull CuboidRegion getAxisAlignedBoundingBox(Iterable<CuboidRegion> iterable) {
        Iterator<CuboidRegion> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            throw new IllegalArgumentException("No regions given");
        }
        CuboidRegion cuboidRegion = iterator.next();
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        while (iterator.hasNext()) {
            cuboidRegion = iterator.next();
            blockVector3 = blockVector3.getMinimum(cuboidRegion.getMinimumPoint());
            blockVector32 = blockVector32.getMaximum(cuboidRegion.getMaximumPoint());
        }
        return new CuboidRegion(blockVector3, blockVector32);
    }

    public static CuboidRegion createRegion(int n, int n2, int n3, int n4, int n5, int n6) {
        BlockVector3 blockVector3 = BlockVector3.at((int)n, (int)n3, (int)n5);
        BlockVector3 blockVector32 = BlockVector3.at((int)n2, (int)n4, (int)n6);
        return new CuboidRegion(blockVector3, blockVector32);
    }

    public static boolean contains(CuboidRegion cuboidRegion, int n, int n2) {
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        return n >= blockVector3.getX() && n <= blockVector32.getX() && n2 >= blockVector3.getZ() && n2 <= blockVector32.getZ();
    }

    public static boolean contains(CuboidRegion cuboidRegion, int n, int n2, int n3) {
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        return n >= blockVector3.getX() && n <= blockVector32.getX() && n3 >= blockVector3.getZ() && n3 <= blockVector32.getZ() && n2 >= blockVector3.getY() && n2 <= blockVector32.getY();
    }

    public static boolean intersects(CuboidRegion cuboidRegion, CuboidRegion cuboidRegion2) {
        BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
        BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
        BlockVector3 blockVector33 = cuboidRegion2.getMinimumPoint();
        BlockVector3 blockVector34 = cuboidRegion2.getMaximumPoint();
        return blockVector33.getX() <= blockVector32.getX() && blockVector34.getX() >= blockVector3.getX() && blockVector33.getZ() <= blockVector32.getZ() && blockVector34.getZ() >= blockVector3.getZ();
    }
}

