/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonParseException;
import com.plotsquared.core.PlotSquared;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.generator.ClassicPlotWorld;
import com.plotsquared.core.inject.factory.ProgressSubscriberFactory;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.plot.schematic.Schematic;
import com.plotsquared.core.queue.QueueCoordinator;
import com.plotsquared.core.util.FileUtils;
import com.plotsquared.core.util.RegionUtil;
import com.plotsquared.core.util.WorldUtil;
import com.plotsquared.core.util.net.AbstractDelegateOutputStream;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskManager;
import com.plotsquared.core.util.task.YieldRunnable;
import com.plotsquared.google.Inject;
import com.sk89q.jnbt.ByteArrayTag;
import com.sk89q.jnbt.CompoundTag;
import com.sk89q.jnbt.IntArrayTag;
import com.sk89q.jnbt.IntTag;
import com.sk89q.jnbt.ListTag;
import com.sk89q.jnbt.NBTInputStream;
import com.sk89q.jnbt.NBTOutputStream;
import com.sk89q.jnbt.ShortTag;
import com.sk89q.jnbt.StringTag;
import com.sk89q.jnbt.Tag;
import com.sk89q.worldedit.WorldEdit;
import com.sk89q.worldedit.extension.platform.Capability;
import com.sk89q.worldedit.extent.clipboard.Clipboard;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormat;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardFormats;
import com.sk89q.worldedit.extent.clipboard.io.ClipboardReader;
import com.sk89q.worldedit.extent.clipboard.io.MCEditSchematicReader;
import com.sk89q.worldedit.extent.clipboard.io.SpongeSchematicReader;
import com.sk89q.worldedit.math.BlockVector2;
import com.sk89q.worldedit.math.BlockVector3;
import com.sk89q.worldedit.regions.CuboidRegion;
import com.sk89q.worldedit.regions.Region;
import com.sk89q.worldedit.regions.RegionIntersection;
import com.sk89q.worldedit.world.World;
import com.sk89q.worldedit.world.biome.BiomeType;
import com.sk89q.worldedit.world.block.BaseBlock;
import com.sk89q.worldedit.world.block.BlockTypes;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class SchematicHandler {
    private static final Logger LOGGER = LogManager.getLogger((String)("PlotSquared/" + SchematicHandler.class.getSimpleName()));
    private static final Gson GSON = new Gson();
    public static SchematicHandler manager;
    private final WorldUtil worldUtil;
    private final ProgressSubscriberFactory subscriberFactory;
    private boolean exportAll = false;

    @Inject
    public SchematicHandler(@NonNull WorldUtil worldUtil, @NonNull ProgressSubscriberFactory progressSubscriberFactory) {
        this.worldUtil = worldUtil;
        this.subscriberFactory = progressSubscriberFactory;
    }

    @Deprecated(forRemoval=true, since="6.0.0")
    public static void upload(@Nullable UUID uUID, @Nullable String string, @NonNull String string2, @Nullable RunnableVal<OutputStream> runnableVal, @NonNull RunnableVal<URL> runnableVal2) {
        URL uRL;
        String string3;
        String string4;
        if (runnableVal == null) {
            TaskManager.runTask(runnableVal2);
            return;
        }
        if (uUID == null) {
            uUID = UUID.randomUUID();
            string4 = Settings.Web.URL + "upload.php?" + uUID;
            string3 = "plot." + string2;
        } else {
            string4 = Settings.Web.URL + "save.php?" + uUID;
            string3 = string + "." + string2;
        }
        try {
            uRL = URI.create(Settings.Web.URL + "?key=" + uUID + "&type=" + string2).toURL();
        }
        catch (MalformedURLException malformedURLException) {
            malformedURLException.printStackTrace();
            runnableVal2.run();
            return;
        }
        TaskManager.runTaskAsync(() -> {
            try {
                int n;
                Closeable closeable;
                String string3 = Long.toHexString(System.currentTimeMillis());
                URLConnection uRLConnection = URI.create(string4).toURL().openConnection();
                uRLConnection.setDoOutput(true);
                uRLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + string3);
                try (Object object = uRLConnection.getOutputStream();){
                    closeable = new PrintWriter((Writer)new OutputStreamWriter((OutputStream)object, StandardCharsets.UTF_8), true);
                    try {
                        String string4 = "\r\n";
                        ((PrintWriter)closeable).append("--").append(string3).append(string4);
                        ((PrintWriter)closeable).append("Content-Disposition: form-data; name=\"param\"").append(string4);
                        ((PrintWriter)closeable).append("Content-Type: text/plain; charset=").append(StandardCharsets.UTF_8.displayName()).append(string4);
                        String string5 = "value";
                        ((PrintWriter)closeable).append(string4).append(string5).append(string4).flush();
                        ((PrintWriter)closeable).append("--").append(string3).append(string4);
                        ((PrintWriter)closeable).append("Content-Disposition: form-data; name=\"schematicFile\"; filename=\"").append(string3).append(String.valueOf('\"')).append(string4);
                        ((PrintWriter)closeable).append("Content-Type: ").append(URLConnection.guessContentTypeFromName(string3)).append(string4);
                        ((PrintWriter)closeable).append("Content-Transfer-Encoding: binary").append(string4);
                        ((PrintWriter)closeable).append(string4).flush();
                        runnableVal.value = new AbstractDelegateOutputStream((OutputStream)object){

                            @Override
                            public void close() {
                            }
                        };
                        runnableVal.run();
                        ((OutputStream)object).flush();
                        ((PrintWriter)closeable).append(string4).flush();
                        ((PrintWriter)closeable).append("--").append(string3).append("--").append(string4).flush();
                    }
                    finally {
                        ((PrintWriter)closeable).close();
                    }
                }
                closeable = new Scanner(uRLConnection.getInputStream()).useDelimiter("\\A");
                try {
                    object = ((Scanner)closeable).next().trim();
                }
                finally {
                    if (closeable != null) {
                        ((Scanner)closeable).close();
                    }
                }
                if (!((String)object).startsWith("<")) {
                    // empty if block
                }
                if ((n = ((HttpURLConnection)uRLConnection).getResponseCode()) == 200) {
                    runnableVal2.value = uRL;
                }
                TaskManager.runTask(runnableVal2);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                TaskManager.runTask(runnableVal2);
            }
        });
    }

    public boolean exportAll(Collection<Plot> collection, final File file, final String string, final Runnable runnable) {
        if (this.exportAll) {
            return false;
        }
        if (collection.isEmpty()) {
            return false;
        }
        this.exportAll = true;
        final ArrayList<Plot> arrayList = new ArrayList<Plot>(collection);
        TaskManager.runTaskAsync(new Runnable(){

            @Override
            public void run() {
                if (arrayList.isEmpty()) {
                    SchematicHandler.this.exportAll = false;
                    TaskManager.runTask(runnable);
                    return;
                }
                Iterator iterator = arrayList.iterator();
                Plot plot = (Plot)iterator.next();
                iterator.remove();
                String string3 = plot.hasOwner() ? plot.getOwnerAbs().toString() : "unknown";
                Object object = string == null ? plot.getId().getX() + ";" + plot.getId().getY() + "," + plot.getArea() + "," + string3 : string.replaceAll("%id%", plot.getId().toString()).replaceAll("%idx%", "" + plot.getId().getX()).replaceAll("%idy%", "" + plot.getId().getY()).replaceAll("%world%", plot.getArea().toString());
                String string2 = file == null ? Settings.Paths.SCHEMATICS : file.getAbsolutePath();
                2 var6_6 = this;
                SchematicHandler.this.getCompoundTag(plot).whenComplete((arg_0, arg_1) -> this.lambda$run$1(string2, (String)object, plot, var6_6, arg_0, arg_1));
            }

            private /* synthetic */ void lambda$run$1(String string3, String string2, Plot plot, Runnable runnable2, CompoundTag compoundTag, Throwable throwable) {
                if (compoundTag != null) {
                    TaskManager.runTaskAsync(() -> {
                        boolean bl = SchematicHandler.this.save(compoundTag, string3 + File.separator + string2 + ".schem");
                        if (!bl) {
                            LOGGER.error("Failed to save {}", (Object)plot.getId());
                        }
                        TaskManager.runTask(runnable2);
                    });
                }
            }
        });
        return true;
    }

    public void paste(Schematic schematic, Plot plot, int n, int n2, int n3, boolean bl, PlotPlayer<?> plotPlayer, RunnableVal<Boolean> runnableVal) {
        if (runnableVal != null) {
            runnableVal.value = false;
        }
        if (schematic == null) {
            TaskManager.runTask(runnableVal);
            return;
        }
        try {
            Object object;
            CuboidRegion cuboidRegion;
            int n4;
            int n5;
            int n6;
            int n7;
            PlotArea plotArea;
            boolean bl2;
            BlockVector3 blockVector3 = schematic.getClipboard().getDimensions();
            int n8 = blockVector3.getX();
            int n9 = blockVector3.getZ();
            int n10 = blockVector3.getY();
            int n11 = plot.getArea().getMaxGenHeight() - plot.getArea().getMinGenHeight() + 1;
            CuboidRegion cuboidRegion2 = plot.getLargestRegion();
            boolean bl3 = bl2 = cuboidRegion2.getMaximumPoint().getX() - cuboidRegion2.getMinimumPoint().getX() + n + 1 < n8 || cuboidRegion2.getMaximumPoint().getZ() - cuboidRegion2.getMinimumPoint().getZ() + n3 + 1 < n9 || n10 > n11;
            if (!Settings.Schematics.PASTE_MISMATCHES && bl2) {
                plotPlayer.sendMessage((Caption)TranslatableCaption.of("schematics.schematic_size_mismatch"), new TagResolver[0]);
                TaskManager.runTask(runnableVal);
                return;
            }
            Clipboard clipboard = schematic.getClipboard();
            int n12 = bl ? (n10 >= n11 ? n2 : ((plotArea = plot.getArea()) instanceof ClassicPlotWorld ? n2 + plotArea.getMinBuildHeight() + ((ClassicPlotWorld)plotArea).PLOT_HEIGHT : n2 + plotArea.getMinBuildHeight() + this.worldUtil.getHighestBlockSynchronous(plot.getWorldName(), cuboidRegion2.getMinimumPoint().getX() + 1, cuboidRegion2.getMinimumPoint().getZ() + 1))) : n2;
            if (!bl2 || plot.getRegions().size() == 1) {
                n7 = cuboidRegion2.getMinimumPoint().getX() + n;
                n6 = cuboidRegion2.getMinimumPoint().getZ() + n3;
                n5 = cuboidRegion2.getMaximumPoint().getX() + n;
                n4 = cuboidRegion2.getMaximumPoint().getZ() + n3;
                cuboidRegion = cuboidRegion2;
            } else {
                object = plot.getCorners();
                n7 = object[0].getX() + n;
                n6 = object[0].getZ() + n3;
                n5 = object[1].getX() + n;
                n4 = object[1].getZ() + n3;
                cuboidRegion = new RegionIntersection(null, (Region[])plot.getRegions().toArray(new CuboidRegion[0]));
            }
            object = plot.getArea().getQueue();
            for (int i = 0; i < Math.min(n11, n10); ++i) {
                int n13 = n12 + i;
                if (n13 > plot.getArea().getMaxGenHeight() || n13 < plot.getArea().getMinGenHeight()) continue;
                for (int j = 0; j < clipboard.getDimensions().getZ(); ++j) {
                    for (int k = 0; k < clipboard.getDimensions().getX(); ++k) {
                        int n14 = n7 + k;
                        int n15 = n6 + j;
                        if (bl2 && (n14 < n7 || n14 > n5 || n15 < n6 || n15 > n4 || !cuboidRegion.contains(BlockVector3.at((int)n14, (int)i, (int)n15)))) continue;
                        BlockVector3 blockVector32 = BlockVector3.at((int)k, (int)i, (int)j);
                        BaseBlock baseBlock = clipboard.getFullBlock(blockVector32);
                        ((QueueCoordinator)object).setBlock(n14, n13, n15, baseBlock);
                        BiomeType biomeType = clipboard.getBiome(blockVector32);
                        ((QueueCoordinator)object).setBiome(n14, n13, n15, biomeType);
                    }
                }
            }
            if (plotPlayer != null && Settings.QUEUE.NOTIFY_PROGRESS) {
                ((QueueCoordinator)object).addProgressSubscriber(this.subscriberFactory.createWithActor(plotPlayer));
            }
            if (runnableVal != null) {
                runnableVal.value = true;
                ((QueueCoordinator)object).setCompleteTask(runnableVal);
            }
            ((QueueCoordinator)object).enqueue();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            TaskManager.runTask(runnableVal);
        }
    }

    public abstract boolean restoreTile(QueueCoordinator var1, CompoundTag var2, int var3, int var4, int var5);

    public Schematic getSchematic(String object) {
        File file;
        File file2 = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS);
        if (!file2.exists() && !file2.mkdir()) {
            throw new RuntimeException("Could not create schematic parent directory");
        }
        if (!((String)object).endsWith(".schem") && !((String)object).endsWith(".schematic")) {
            object = (String)object + ".schem";
        }
        if (!(file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + (String)object)).exists()) {
            file = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS + File.separator + (String)object);
        }
        return this.getSchematic(file);
    }

    public Collection<String> getSchematicNames() {
        String[] stringArray;
        File file2 = FileUtils.getFile(PlotSquared.platform().getDirectory(), Settings.Paths.SCHEMATICS);
        ArrayList arrayList = new ArrayList();
        if (file2.exists() && (stringArray = file2.list((file, string) -> string.endsWith(".schematic") || string.endsWith(".schem"))) != null) {
            List list = Arrays.stream(stringArray).collect(Collectors.toList());
            arrayList.addAll(list);
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Schematic getSchematic(File file) {
        if (!file.exists()) {
            return null;
        }
        ClipboardFormat clipboardFormat = ClipboardFormats.findByFile((File)file);
        if (clipboardFormat != null) {
            Schematic schematic;
            block11: {
                ClipboardReader clipboardReader = clipboardFormat.getReader((InputStream)new FileInputStream(file));
                try {
                    Clipboard clipboard = clipboardReader.read();
                    schematic = new Schematic(clipboard);
                    if (clipboardReader == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (clipboardReader != null) {
                            try {
                                clipboardReader.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                clipboardReader.close();
            }
            return schematic;
        } else {
            throw new UnsupportedFormatException("This schematic format is not recognised or supported.");
        }
        return null;
    }

    public Schematic getSchematic(@NonNull URL uRL) {
        try {
            ReadableByteChannel readableByteChannel = Channels.newChannel(uRL.openStream());
            InputStream inputStream = Channels.newInputStream(readableByteChannel);
            return this.getSchematic(inputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public Schematic getSchematic(@NonNull InputStream inputStream) {
        try {
            SpongeSchematicReader spongeSchematicReader = new SpongeSchematicReader(new NBTInputStream((InputStream)new GZIPInputStream(inputStream)));
            Clipboard clipboard = spongeSchematicReader.read();
            return new Schematic(clipboard);
        }
        catch (IOException iOException) {
            try {
                MCEditSchematicReader mCEditSchematicReader = new MCEditSchematicReader(new NBTInputStream((InputStream)new GZIPInputStream(inputStream)));
                Clipboard clipboard = mCEditSchematicReader.read();
                return new Schematic(clipboard);
            }
            catch (IOException iOException2) {
                iOException2.printStackTrace();
                return null;
            }
        }
    }

    @Deprecated(forRemoval=true, since="6.11.0")
    public List<String> getSaves(UUID uUID) {
        try {
            String string;
            URLConnection uRLConnection = URI.create(Settings.Web.URL + "list.php?" + uUID.toString()).toURL().openConnection();
            uRLConnection.setRequestProperty("User-Agent", "Mozilla/5.0");
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRLConnection.getInputStream()));){
                string = bufferedReader.lines().collect(Collectors.joining());
            }
            bufferedReader = (JsonArray)GSON.fromJson(string, JsonArray.class);
            ArrayList<String> arrayList = new ArrayList<String>();
            for (int i = 0; i < bufferedReader.size(); ++i) {
                String string2 = bufferedReader.get(i).getAsString();
                arrayList.add(string2);
            }
            return arrayList;
        }
        catch (JsonParseException | IOException throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    @Deprecated(forRemoval=true, since="6.0.0")
    public void upload(final CompoundTag compoundTag, UUID uUID, String string, RunnableVal<URL> runnableVal) {
        if (compoundTag == null) {
            TaskManager.runTask(runnableVal);
            return;
        }
        SchematicHandler.upload(uUID, string, "schem", new RunnableVal<OutputStream>(){

            @Override
            public void run(OutputStream outputStream) {
                try (NBTOutputStream nBTOutputStream = new NBTOutputStream((OutputStream)new GZIPOutputStream(outputStream, true));){
                    nBTOutputStream.writeNamedTag("Schematic", (Tag)compoundTag);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }, runnableVal);
    }

    public boolean save(CompoundTag compoundTag, String string) {
        if (compoundTag == null) {
            return false;
        }
        try {
            File file = FileUtils.getFile(PlotSquared.platform().getDirectory(), string);
            file.getParentFile().mkdirs();
            try (NBTOutputStream nBTOutputStream = new NBTOutputStream((OutputStream)new GZIPOutputStream(new FileOutputStream(file)));){
                nBTOutputStream.writeNamedTag("Schematic", (Tag)compoundTag);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
        return true;
    }

    private void writeSchematicData(@NonNull Map<String, Tag> map, @NonNull Map<String, Integer> map2, @NonNull Map<String, Integer> map3, @NonNull List<CompoundTag> list, @NonNull ByteArrayOutputStream byteArrayOutputStream, @NonNull ByteArrayOutputStream byteArrayOutputStream2) {
        map.put("PaletteMax", (Tag)new IntTag(map2.size()));
        HashMap hashMap = new HashMap();
        map2.forEach((string, n) -> hashMap.put(string, new IntTag(n.intValue())));
        map.put("Palette", (Tag)new CompoundTag(hashMap));
        map.put("BlockData", (Tag)new ByteArrayTag(byteArrayOutputStream.toByteArray()));
        map.put("BlockEntities", (Tag)new ListTag(CompoundTag.class, list));
        if (byteArrayOutputStream2.size() == 0 || map3.size() == 0) {
            return;
        }
        map.put("BiomePaletteMax", (Tag)new IntTag(map3.size()));
        HashMap hashMap2 = new HashMap();
        map3.forEach((string, n) -> hashMap2.put(string, new IntTag(n.intValue())));
        map.put("BiomePalette", (Tag)new CompoundTag(hashMap2));
        map.put("BiomeData", (Tag)new ByteArrayTag(byteArrayOutputStream2.toByteArray()));
    }

    private @NonNull Map<String, Tag> initSchematic(short s, short s2, short s3) {
        HashMap<String, Tag> hashMap = new HashMap<String, Tag>();
        hashMap.put("Version", (Tag)new IntTag(2));
        hashMap.put("DataVersion", (Tag)new IntTag(WorldEdit.getInstance().getPlatformManager().queryCapability(Capability.WORLD_EDITING).getDataVersion()));
        HashMap<String, IntTag> hashMap2 = new HashMap<String, IntTag>();
        hashMap2.put("WEOffsetX", new IntTag(0));
        hashMap2.put("WEOffsetY", new IntTag(0));
        hashMap2.put("WEOffsetZ", new IntTag(0));
        hashMap.put("Metadata", (Tag)new CompoundTag(hashMap2));
        hashMap.put("Width", (Tag)new ShortTag(s));
        hashMap.put("Height", (Tag)new ShortTag(s2));
        hashMap.put("Length", (Tag)new ShortTag(s3));
        hashMap.put("Offset", (Tag)new IntArrayTag(new int[]{0, 0, 0}));
        return hashMap;
    }

    public CompletableFuture<CompoundTag> getCompoundTag(@NonNull Plot plot) {
        return this.getCompoundTag(Objects.requireNonNull(plot.getWorldName()), plot.getRegions());
    }

    public @NonNull CompletableFuture<CompoundTag> getCompoundTag(@NonNull String string, @NonNull Set<CuboidRegion> set) {
        final CompletableFuture<CompoundTag> completableFuture = new CompletableFuture<CompoundTag>();
        TaskManager.runTaskAsync(() -> {
            World world = this.worldUtil.getWeWorld(string);
            final CuboidRegion cuboidRegion = RegionUtil.getAxisAlignedBoundingBox(set);
            cuboidRegion.setWorld(world);
            final RegionIntersection regionIntersection = new RegionIntersection(new ArrayList(set));
            int n = cuboidRegion.getWidth();
            int n2 = cuboidRegion.getHeight();
            int n3 = cuboidRegion.getLength();
            final boolean bl = set.size() > 1;
            final Map<String, Tag> map = this.initSchematic((short)n, (short)n2, (short)n3);
            final HashMap hashMap = new HashMap();
            final HashMap hashMap2 = new HashMap();
            final ArrayList arrayList = new ArrayList();
            final ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n * n2 * n3);
            final ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(n * n3);
            TaskManager.runTaskAsync(() -> {
                BlockVector3 blockVector3 = cuboidRegion.getMinimumPoint();
                BlockVector3 blockVector32 = cuboidRegion.getMaximumPoint();
                final int n = blockVector3.getX();
                final int n2 = blockVector3.getZ();
                final int n3 = blockVector3.getY();
                final int n4 = blockVector32.getX();
                final int n5 = blockVector32.getZ();
                final int n6 = blockVector32.getY();
                YieldRunnable yieldRunnable = new YieldRunnable(){
                    int currentY;
                    int currentX;
                    int currentZ;
                    {
                        this.currentY = n3;
                        this.currentX = n;
                        this.currentZ = n2;
                    }

                    @Override
                    public void run() {
                        long l = System.currentTimeMillis();
                        int n7 = 0;
                        while (this.currentY <= n6) {
                            int n22 = this.currentY - n3;
                            while (this.currentZ <= n5) {
                                int n32 = this.currentZ - n2;
                                while (this.currentX <= n4) {
                                    if (System.currentTimeMillis() - l > 40L) {
                                        this.yield();
                                        return;
                                    }
                                    int n42 = this.currentX - n;
                                    BlockVector3 blockVector3 = BlockVector3.at((int)this.currentX, (int)this.currentY, (int)this.currentZ);
                                    if (bl && !regionIntersection.contains(blockVector3)) {
                                        int n52;
                                        var8_7 = BlockTypes.AIR.getDefaultState().getAsString();
                                        if (hashMap.containsKey(var8_7)) {
                                            n52 = (Integer)hashMap.get(var8_7);
                                        } else {
                                            n52 = hashMap.size();
                                            hashMap.put(var8_7, hashMap.size());
                                        }
                                        while ((n52 & 0xFFFFFF80) != 0) {
                                            byteArrayOutputStream.write(n52 & 0x7F | 0x80);
                                            n52 >>>= 7;
                                        }
                                        byteArrayOutputStream.write(n52);
                                        if (n22 <= 0) {
                                            var10_11 = n7;
                                            while ((var10_11 & 0xFFFFFF80) != 0) {
                                                byteArrayOutputStream2.write(var10_11 & 0x7F | 0x80);
                                                var10_11 >>>= 7;
                                            }
                                            byteArrayOutputStream2.write(var10_11);
                                        }
                                    } else {
                                        String string;
                                        var8_7 = cuboidRegion.getWorld().getFullBlock(blockVector3);
                                        if (var8_7.getNbtData() != null) {
                                            HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                                            for (Map.Entry entry : var8_7.getNbtData().getValue().entrySet()) {
                                                hashMap3.put((String)entry.getKey(), (Tag)entry.getValue());
                                            }
                                            hashMap3.remove("x");
                                            hashMap3.remove("y");
                                            hashMap3.remove("z");
                                            hashMap3.put("Id", new StringTag(var8_7.getNbtId()));
                                            hashMap3.remove("id");
                                            hashMap3.put("Pos", new IntArrayTag(new int[]{n42, n22, n32}));
                                            arrayList.add(new CompoundTag(hashMap3));
                                        }
                                        if (hashMap.containsKey(string = var8_7.toImmutableState().getAsString())) {
                                            var10_11 = (Integer)hashMap.get(string);
                                        } else {
                                            var10_11 = hashMap.size();
                                            hashMap.put(string, hashMap.size());
                                        }
                                        while ((var10_11 & 0xFFFFFF80) != 0) {
                                            byteArrayOutputStream.write(var10_11 & 0x7F | 0x80);
                                            var10_11 >>>= 7;
                                        }
                                        byteArrayOutputStream.write(var10_11);
                                        if (n22 <= 0) {
                                            int n53;
                                            BlockVector2 blockVector2 = BlockVector2.at((int)this.currentX, (int)this.currentZ);
                                            BiomeType biomeType = cuboidRegion.getWorld().getBiome(blockVector2);
                                            String string2 = biomeType.getId();
                                            if (hashMap2.containsKey(string2)) {
                                                n53 = n7 = ((Integer)hashMap2.get(string2)).intValue();
                                            } else {
                                                n53 = n7 = hashMap2.size();
                                                hashMap2.put(string2, n53);
                                            }
                                            while ((n53 & 0xFFFFFF80) != 0) {
                                                byteArrayOutputStream2.write(n53 & 0x7F | 0x80);
                                                n53 >>>= 7;
                                            }
                                            byteArrayOutputStream2.write(n53);
                                        }
                                    }
                                    ++this.currentX;
                                }
                                this.currentX = n;
                                ++this.currentZ;
                            }
                            this.currentZ = n2;
                            ++this.currentY;
                        }
                        TaskManager.runTaskAsync(() -> {
                            SchematicHandler.this.writeSchematicData(map, hashMap, hashMap2, arrayList, byteArrayOutputStream, byteArrayOutputStream2);
                            completableFuture.complete(new CompoundTag(map));
                        });
                    }
                };
                yieldRunnable.run();
            });
        });
        return completableFuture;
    }

    public static class UnsupportedFormatException
    extends Exception {
        public UnsupportedFormatException(String string) {
            super(string);
        }

        public UnsupportedFormatException(String string, Throwable throwable) {
            super(string, throwable);
        }
    }
}

