/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;

public class StringMan {
    private static final Pattern STRING_SPLIT_PATTERN = Pattern.compile("[^\\s\"]+|\"([^\"]*)\"");

    public static int intersection(Set<String> set, String[] stringArray) {
        int n = 0;
        for (String string : stringArray) {
            if (!set.contains(string)) continue;
            ++n;
        }
        return n;
    }

    public static boolean isAlphanumericUnd(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (!(c < '0' || c >= ':' && c <= '@' || c > 'Z' && c <= '`') && c <= 'z') continue;
            return false;
        }
        return true;
    }

    public static String join(Collection<?> collection, String string) {
        return StringMan.join(collection.toArray(), string);
    }

    public static String joinOrdered(Collection<?> collection, String string) {
        Object[] objectArray = collection.toArray();
        Arrays.sort(objectArray, Comparator.comparingInt(Object::hashCode));
        return StringMan.join(objectArray, string);
    }

    public static int getLevenshteinDistance(String string, String string2) {
        int n;
        Object object;
        int n2 = string.length();
        int n3 = string2.length();
        if (n2 == 0) {
            return n3;
        }
        if (n3 == 0) {
            return n2;
        }
        if (n2 > n3) {
            object = string;
            string = string2;
            string2 = object;
            n2 = n3;
            n3 = string2.length();
        }
        object = new int[n2 + 1];
        Object object2 = new int[n2 + 1];
        for (n = 0; n <= n2; ++n) {
            object[n] = n;
        }
        for (int i = 1; i <= n3; ++i) {
            char c = string2.charAt(i - 1);
            object2[0] = i;
            for (n = 1; n <= n2; ++n) {
                boolean bl = string.charAt(n - 1) != c;
                object2[n] = Math.min(Math.min(object2[n - 1] + 1, (int)(object[n] + true)), (int)(object[n - 1] + bl));
            }
            Object object3 = object;
            object = object2;
            object2 = object3;
        }
        return (int)object[n2];
    }

    public static String join(Object[] objectArray, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                stringBuilder.append(string);
            }
            stringBuilder.append(objectArray[i]);
        }
        return stringBuilder.toString();
    }

    public static boolean isEqualIgnoreCaseToAny(@NonNull String string, String ... stringArray) {
        for (String string2 : stringArray) {
            if (!string.equalsIgnoreCase(string2)) continue;
            return true;
        }
        return false;
    }

    public static boolean isEqual(String string, String string2) {
        if (string == null && string2 != null || string != null && string2 == null) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return string.equals(string2);
    }

    public static String repeat(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(String.valueOf(string).repeat(Math.max(0, n)));
        return stringBuilder.toString();
    }

    public static @NonNull List<String> splitMessage(@NonNull String string) {
        Matcher matcher = STRING_SPLIT_PATTERN.matcher(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (matcher.find()) {
            arrayList.add(matcher.group(matcher.groupCount() - 1).replaceAll("\"", ""));
        }
        return arrayList;
    }
}

