/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.helpmenu;

import com.plotsquared.core.command.Command;
import com.plotsquared.core.command.CommandCategory;
import com.plotsquared.core.command.MainCommand;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.util.helpmenu.HelpObject;
import com.plotsquared.core.util.helpmenu.HelpPage;
import java.util.List;

public class HelpMenu {
    private static final int PER_PAGE = 5;
    private final PlotPlayer<?> commandCaller;
    private HelpPage page = new HelpPage(CommandCategory.INFO, 0, 0);
    private int maxPage;
    private CommandCategory commandCategory;
    private List<Command> commands;

    public HelpMenu(PlotPlayer<?> plotPlayer) {
        this.commandCaller = plotPlayer;
    }

    public HelpMenu setCategory(CommandCategory commandCategory) {
        this.commandCategory = commandCategory;
        return this;
    }

    public HelpMenu getCommands() {
        this.commands = MainCommand.getInstance().getCommands(this.commandCategory, this.commandCaller);
        return this;
    }

    public HelpMenu setCommands(List<Command> list) {
        this.commands = list;
        return this;
    }

    public HelpMenu generateMaxPages() {
        this.maxPage = Math.max((this.commands.size() - 1) / 5, 0);
        return this;
    }

    public HelpMenu generatePage(int n, String string, PlotPlayer<?> plotPlayer) {
        if (n > this.maxPage) {
            n = this.maxPage;
        }
        if (n < 0) {
            n = 0;
        }
        this.page = new HelpPage(this.commandCategory, n, this.maxPage);
        int n2 = Math.min(n * 5 + 4, this.commands.size());
        for (int i = n * 5; i < n2; ++i) {
            this.page.addHelpItem(new HelpObject(this.commands.get(i), string, plotPlayer));
        }
        return this;
    }

    public void render() {
        this.page.render(this.commandCaller);
    }
}

