/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.query;

import com.google.common.base.Preconditions;
import com.plotsquared.core.plot.Plot;
import java.util.Collections;
import java.util.List;
import org.checkerframework.checker.nullness.qual.NonNull;

public final class PaginatedPlotResult {
    private final List<Plot> plots;
    private final int pageSize;

    PaginatedPlotResult(@NonNull List<Plot> list, int n) {
        this.plots = list;
        this.pageSize = n;
    }

    public List<Plot> getPage(int n) {
        Preconditions.checkState((n >= 0 ? 1 : 0) != 0, (Object)"Page must be positive");
        int n2 = (n - 1) * this.pageSize;
        if (this.plots.size() < n2) {
            return Collections.emptyList();
        }
        int n3 = Math.max(n2 + this.pageSize, this.plots.size());
        return this.plots.subList(n2, n3);
    }

    public int getPages() {
        return (int)Math.ceil((double)this.plots.size() / (double)this.pageSize);
    }
}

