/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.task;

import com.plotsquared.core.configuration.adventure.text.Component;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.Tag;
import com.plotsquared.core.configuration.adventure.text.minimessage.tag.resolver.TagResolver;
import com.plotsquared.core.configuration.caption.Caption;
import com.plotsquared.core.configuration.caption.TranslatableCaption;
import com.plotsquared.core.events.PlotMergeEvent;
import com.plotsquared.core.events.Result;
import com.plotsquared.core.location.Direction;
import com.plotsquared.core.player.MetaDataAccess;
import com.plotsquared.core.player.PlayerMetaDataKeys;
import com.plotsquared.core.player.PlotPlayer;
import com.plotsquared.core.plot.Plot;
import com.plotsquared.core.plot.PlotArea;
import com.plotsquared.core.util.EventDispatcher;
import java.util.concurrent.Callable;

public final class AutoClaimFinishTask
implements Callable<Boolean> {
    private final PlotPlayer<?> player;
    private final Plot plot;
    private final PlotArea area;
    private final String schematic;
    private final EventDispatcher eventDispatcher;

    public AutoClaimFinishTask(PlotPlayer<?> plotPlayer, Plot plot, PlotArea plotArea, String string, EventDispatcher eventDispatcher) {
        this.player = plotPlayer;
        this.plot = plot;
        this.area = plotArea;
        this.schematic = string;
        this.eventDispatcher = eventDispatcher;
    }

    @Override
    public Boolean call() {
        try (Object object = this.player.accessTemporaryMetaData(PlayerMetaDataKeys.TEMPORARY_AUTO);){
            ((MetaDataAccess)object).remove();
        }
        if (this.plot == null) {
            this.player.sendMessage((Caption)TranslatableCaption.of("errors.no_free_plots"), new TagResolver[0]);
            return false;
        }
        this.plot.claim(this.player, true, this.schematic, false, true);
        this.eventDispatcher.callPostAuto(this.player, this.plot);
        if (this.area.isAutoMerge()) {
            object = this.eventDispatcher.callMerge(this.plot, Direction.ALL, Integer.MAX_VALUE, this.player);
            if (((PlotMergeEvent)object).getEventResult() == Result.DENY) {
                this.player.sendMessage((Caption)TranslatableCaption.of("events.event_denied"), TagResolver.resolver("value", Tag.inserting(Component.text("Auto Merge"))));
            } else if (this.plot.getPlotModificationManager().autoMerge(((PlotMergeEvent)object).getDir(), ((PlotMergeEvent)object).getMax(), this.player.getUUID(), this.player, true)) {
                this.eventDispatcher.callPostMerge(this.player, this.plot);
            }
        }
        return true;
    }
}

