/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.util.task;

import com.plotsquared.core.util.task.ObjectTaskRunnable;
import com.plotsquared.core.util.task.PlotSquaredTask;
import com.plotsquared.core.util.task.RunnableVal;
import com.plotsquared.core.util.task.TaskTime;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicInteger;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class TaskManager {
    private static final Set<String> teleportQueue = new HashSet<String>();
    private static final Map<Integer, PlotSquaredTask> tasks = new HashMap<Integer, PlotSquaredTask>();
    public static AtomicInteger index = new AtomicInteger(0);
    private static TaskManager platformImplementation;

    public static void addToTeleportQueue(@NonNull String string) {
        teleportQueue.add(string);
    }

    public static boolean removeFromTeleportQueue(@NonNull String string) {
        return teleportQueue.remove(string);
    }

    public static void addTask(@NonNull PlotSquaredTask plotSquaredTask, int n) {
        tasks.put(n, plotSquaredTask);
    }

    public static @Nullable PlotSquaredTask removeTask(int n) {
        return tasks.remove(n);
    }

    public static @NonNull PlotSquaredTask runTaskRepeat(@Nullable Runnable runnable, @NonNull TaskTime taskTime) {
        if (runnable != null) {
            if (TaskManager.getPlatformImplementation() == null) {
                throw new IllegalArgumentException("disabled");
            }
            return TaskManager.getPlatformImplementation().taskRepeat(runnable, taskTime);
        }
        return PlotSquaredTask.nullTask();
    }

    public static void runTaskAsync(@Nullable Runnable runnable) {
        if (runnable != null) {
            if (TaskManager.getPlatformImplementation() == null) {
                runnable.run();
                return;
            }
            TaskManager.getPlatformImplementation().taskAsync(runnable);
        }
    }

    public static void runTask(@Nullable Runnable runnable) {
        if (runnable != null) {
            if (TaskManager.getPlatformImplementation() == null) {
                runnable.run();
                return;
            }
            TaskManager.getPlatformImplementation().task(runnable);
        }
    }

    public static void runTaskLater(@Nullable Runnable runnable, @NonNull TaskTime taskTime) {
        if (runnable != null) {
            if (TaskManager.getPlatformImplementation() == null) {
                runnable.run();
                return;
            }
            TaskManager.getPlatformImplementation().taskLater(runnable, taskTime);
        }
    }

    public static void runTaskLaterAsync(@Nullable Runnable runnable, @NonNull TaskTime taskTime) {
        if (runnable != null) {
            if (TaskManager.getPlatformImplementation() == null) {
                runnable.run();
                return;
            }
            TaskManager.getPlatformImplementation().taskLaterAsync(runnable, taskTime);
        }
    }

    public static @Nullable TaskManager getPlatformImplementation() {
        return platformImplementation;
    }

    public static void setPlatformImplementation(@NonNull TaskManager taskManager) {
        platformImplementation = taskManager;
    }

    public <T> CompletableFuture<Void> objectTask(@NonNull Collection<T> collection, @NonNull RunnableVal<T> runnableVal) {
        Iterator<T> iterator = collection.iterator();
        ObjectTaskRunnable<T> objectTaskRunnable = new ObjectTaskRunnable<T>(iterator, runnableVal);
        TaskManager.runTask(objectTaskRunnable);
        return objectTaskRunnable.getCompletionFuture();
    }

    public <T> T sync(@NonNull Callable<T> callable) {
        return this.sync(callable, Integer.MAX_VALUE);
    }

    public abstract <T> T sync(@NonNull Callable<T> var1, int var2);

    public abstract <T> Future<T> callMethodSync(@NonNull Callable<T> var1);

    public abstract PlotSquaredTask taskRepeat(@NonNull Runnable var1, @NonNull TaskTime var2);

    public abstract PlotSquaredTask taskRepeatAsync(@NonNull Runnable var1, @NonNull TaskTime var2);

    public abstract void taskAsync(@NonNull Runnable var1);

    public abstract void task(@NonNull Runnable var1);

    public abstract void taskLater(@NonNull Runnable var1, @NonNull TaskTime var2);

    public abstract void taskLaterAsync(@NonNull Runnable var1, @NonNull TaskTime var2);
}

