/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.uuid;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.function.Consumer;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CacheUUIDService
implements UUIDService,
Consumer<List<UUIDMapping>> {
    private final Cache<String, UUIDMapping> usernameCache;
    private final Cache<UUID, UUIDMapping> uuidCache;

    public CacheUUIDService(int n) {
        this.usernameCache = CacheBuilder.newBuilder().maximumSize((long)n).build();
        this.uuidCache = CacheBuilder.newBuilder().maximumSize((long)n).build();
    }

    @Override
    public @NonNull List<UUIDMapping> getNames(@NonNull List<@NonNull UUID> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        arrayList.addAll((Collection<UUIDMapping>)this.uuidCache.getAllPresent(list).values());
        return arrayList;
    }

    @Override
    public @NonNull List<UUIDMapping> getUUIDs(@NonNull List<@NonNull String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        arrayList.addAll((Collection<UUIDMapping>)this.usernameCache.getAllPresent(list).values());
        return arrayList;
    }

    @Override
    public void accept(@NonNull List<@NonNull UUIDMapping> list) {
        for (UUIDMapping uUIDMapping : list) {
            this.uuidCache.put((Object)uUIDMapping.uuid(), (Object)uUIDMapping);
            this.usernameCache.put((Object)uUIDMapping.username(), (Object)uUIDMapping);
        }
    }

    @Override
    public @NonNull Collection<@NonNull UUIDMapping> getImmediately() {
        return this.usernameCache.asMap().values();
    }

    @Override
    public boolean canBeSynchronous() {
        return true;
    }

    @Override
    public @Nullable UUIDMapping getImmediately(@NonNull Object object) {
        List<Object> list = object instanceof String ? this.getUUIDs(Collections.singletonList((String)object)) : (object instanceof UUID ? this.getNames(Collections.singletonList((UUID)object)) : Collections.emptyList());
        if (list.isEmpty()) {
            return null;
        }
        return (UUIDMapping)list.get(0);
    }
}

