/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.core.uuid.offline;

import com.google.common.base.Charsets;
import com.plotsquared.core.configuration.Settings;
import com.plotsquared.core.uuid.UUIDMapping;
import com.plotsquared.core.uuid.UUIDService;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.checkerframework.checker.nullness.qual.NonNull;

public class OfflineModeUUIDService
implements UUIDService {
    protected final @NonNull UUID getFromUsername(@NonNull String string) {
        if (Settings.UUID.FORCE_LOWERCASE) {
            string = string.toLowerCase(Locale.ENGLISH);
        }
        return UUID.nameUUIDFromBytes(("OfflinePlayer:" + string).getBytes(Charsets.UTF_8));
    }

    @Override
    public @NonNull List<@NonNull UUIDMapping> getNames(@NonNull List<@NonNull UUID> list) {
        return Collections.emptyList();
    }

    @Override
    public @NonNull List<@NonNull UUIDMapping> getUUIDs(@NonNull List<@NonNull String> list) {
        ArrayList<UUIDMapping> arrayList = new ArrayList<UUIDMapping>(list.size());
        for (String string : list) {
            arrayList.add(new UUIDMapping(this.getFromUsername(string), string));
        }
        return arrayList;
    }
}

