/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.assistedinject;

import com.google.common.collect.Lists;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.assistedinject.Parameter;
import com.plotsquared.google.assistedinject.ParameterListKey;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

class AssistedConstructor<T> {
    private final Constructor<T> constructor;
    private final ParameterListKey assistedParameters;
    private final List<Parameter> allParameters;

    public static <T> AssistedConstructor<T> create(Constructor<T> constructor, List<TypeLiteral<?>> list) {
        return new AssistedConstructor<T>(constructor, list);
    }

    private AssistedConstructor(Constructor<T> constructor, List<TypeLiteral<?>> list) {
        this.constructor = constructor;
        Annotation[][] annotationArray = constructor.getParameterAnnotations();
        ArrayList arrayList = Lists.newArrayList();
        this.allParameters = new ArrayList<Parameter>();
        for (int i = 0; i < list.size(); ++i) {
            Parameter parameter = new Parameter(list.get(i).getType(), annotationArray[i]);
            this.allParameters.add(parameter);
            if (!parameter.isProvidedByFactory()) continue;
            arrayList.add(parameter.getType());
        }
        this.assistedParameters = new ParameterListKey(arrayList);
    }

    public ParameterListKey getAssistedParameters() {
        return this.assistedParameters;
    }

    public List<Parameter> getAllParameters() {
        return this.allParameters;
    }

    public Set<Class<?>> getDeclaredExceptions() {
        return new HashSet(Arrays.asList(this.constructor.getExceptionTypes()));
    }

    public T newInstance(Object[] objectArray) {
        this.constructor.setAccessible(true);
        try {
            return this.constructor.newInstance(objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw invocationTargetException.getCause();
        }
    }

    public String toString() {
        return this.constructor.toString();
    }
}

