/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.assistedinject;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Inject;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.assistedinject.Assisted;
import com.plotsquared.google.assistedinject.AssistedConstructor;
import com.plotsquared.google.assistedinject.AssistedInject;
import com.plotsquared.google.assistedinject.BindingCollector;
import com.plotsquared.google.assistedinject.FactoryProvider2;
import com.plotsquared.google.assistedinject.Parameter;
import com.plotsquared.google.assistedinject.ParameterListKey;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.Message;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

@Deprecated
public class FactoryProvider<F>
implements Provider<F>,
HasDependencies {
    private Injector injector;
    private final TypeLiteral<F> factoryType;
    private final TypeLiteral<?> implementationType;
    private final Map<Method, AssistedConstructor<?>> factoryMethodToConstructor;

    public static <F> Provider<F> newFactory(Class<F> clazz, Class<?> clazz2) {
        return FactoryProvider.newFactory(TypeLiteral.get(clazz), TypeLiteral.get(clazz2));
    }

    public static <F> Provider<F> newFactory(TypeLiteral<F> typeLiteral, TypeLiteral<?> typeLiteral2) {
        Map<Method, AssistedConstructor<?>> map = FactoryProvider.createMethodMapping(typeLiteral, typeLiteral2);
        if (!map.isEmpty()) {
            return new FactoryProvider<F>(typeLiteral, typeLiteral2, map);
        }
        BindingCollector bindingCollector = new BindingCollector();
        Errors errors = new Errors();
        Key<?> key = Key.get(typeLiteral2);
        try {
            for (Method method : typeLiteral.getRawType().getMethods()) {
                Key<?> key2 = Annotations.getKey(typeLiteral.getReturnType(method), method, method.getAnnotations(), errors);
                if (key.equals(key2)) continue;
                bindingCollector.addBinding(key2, typeLiteral2);
            }
        }
        catch (ErrorsException errorsException) {
            throw new ConfigurationException(errorsException.getErrors().getMessages());
        }
        return new FactoryProvider2<F>(Key.get(typeLiteral), bindingCollector, null);
    }

    private FactoryProvider(TypeLiteral<F> typeLiteral, TypeLiteral<?> typeLiteral2, Map<Method, AssistedConstructor<?>> map) {
        this.factoryType = typeLiteral;
        this.implementationType = typeLiteral2;
        this.factoryMethodToConstructor = map;
        this.checkDeclaredExceptionsMatch();
    }

    @Inject
    void setInjectorAndCheckUnboundParametersAreInjectable(Injector injector) {
        this.injector = injector;
        for (AssistedConstructor<?> assistedConstructor : this.factoryMethodToConstructor.values()) {
            for (Parameter parameter : assistedConstructor.getAllParameters()) {
                if (parameter.isProvidedByFactory() || this.paramCanBeInjected(parameter, injector)) continue;
                throw FactoryProvider.newConfigurationException("Parameter of type '%s' is not injectable or annotated with @Assisted for Constructor '%s'", parameter, assistedConstructor);
            }
        }
    }

    private void checkDeclaredExceptionsMatch() {
        for (Map.Entry<Method, AssistedConstructor<?>> entry : this.factoryMethodToConstructor.entrySet()) {
            for (Class<?> clazz : entry.getValue().getDeclaredExceptions()) {
                if (this.isConstructorExceptionCompatibleWithFactoryExeception(clazz, entry.getKey().getExceptionTypes())) continue;
                throw FactoryProvider.newConfigurationException("Constructor %s declares an exception, but no compatible exception is thrown by the factory method %s", entry.getValue(), entry.getKey());
            }
        }
    }

    private boolean isConstructorExceptionCompatibleWithFactoryExeception(Class<?> clazz, Class<?>[] classArray) {
        for (Class<?> clazz2 : classArray) {
            if (!clazz2.isAssignableFrom(clazz)) continue;
            return true;
        }
        return false;
    }

    private boolean paramCanBeInjected(Parameter parameter, Injector injector) {
        return parameter.isBound(injector);
    }

    private static Map<Method, AssistedConstructor<?>> createMethodMapping(TypeLiteral<?> typeLiteral, TypeLiteral<?> typeLiteral2) {
        ArrayList arrayList = Lists.newArrayList();
        for (Constructor<?> object : typeLiteral2.getRawType().getDeclaredConstructors()) {
            if (!object.isAnnotationPresent(AssistedInject.class)) continue;
            AssistedConstructor<?> assistedConstructor = AssistedConstructor.create(object, typeLiteral2.getParameterTypes(object));
            arrayList.add(assistedConstructor);
        }
        if (arrayList.isEmpty()) {
            return ImmutableMap.of();
        }
        Executable[] executableArray = typeLiteral.getRawType().getMethods();
        if (arrayList.size() != executableArray.length) {
            throw FactoryProvider.newConfigurationException("Constructor mismatch: %s has %s @AssistedInject constructors, factory %s has %s creation methods", typeLiteral2, arrayList.size(), typeLiteral, executableArray.length);
        }
        HashMap hashMap = Maps.newHashMap();
        for (AssistedConstructor assistedConstructor : arrayList) {
            if (hashMap.containsKey(assistedConstructor.getAssistedParameters())) {
                throw new RuntimeException("Duplicate constructor, " + assistedConstructor);
            }
            hashMap.put(assistedConstructor.getAssistedParameters(), assistedConstructor);
        }
        HashMap hashMap2 = Maps.newHashMap();
        for (Executable executable : executableArray) {
            if (!((Method)executable).getReturnType().isAssignableFrom(typeLiteral2.getRawType())) {
                throw FactoryProvider.newConfigurationException("Return type of method %s is not assignable from %s", executable, typeLiteral2);
            }
            ArrayList arrayList2 = Lists.newArrayList();
            for (TypeLiteral<?> typeLiteral3 : typeLiteral.getParameterTypes(executable)) {
                arrayList2.add(typeLiteral3.getType());
            }
            ParameterListKey parameterListKey = new ParameterListKey(arrayList2);
            if (!hashMap.containsKey(parameterListKey)) {
                throw FactoryProvider.newConfigurationException("%s has no @AssistInject constructor that takes the @Assisted parameters %s in that order. @AssistInject constructors are %s", typeLiteral2, parameterListKey, hashMap.values());
            }
            ((Method)executable).getParameterAnnotations();
            Annotation[][] annotationArray = ((Method)executable).getParameterAnnotations();
            int n = annotationArray.length;
            for (int i = 0; i < n; ++i) {
                Annotation[] annotationArray2;
                for (Annotation annotation : annotationArray2 = annotationArray[i]) {
                    if (annotation.annotationType() != Assisted.class) continue;
                    throw FactoryProvider.newConfigurationException("Factory method %s has an @Assisted parameter, which is incompatible with the deprecated @AssistedInject annotation. Please replace @AssistedInject with @Inject on the %s constructor.", executable, typeLiteral2);
                }
            }
            AssistedConstructor assistedConstructor = (AssistedConstructor)hashMap.remove(parameterListKey);
            hashMap2.put(executable, assistedConstructor);
        }
        return hashMap2;
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        ArrayList arrayList = Lists.newArrayList();
        for (AssistedConstructor<?> assistedConstructor : this.factoryMethodToConstructor.values()) {
            for (Parameter parameter : assistedConstructor.getAllParameters()) {
                if (parameter.isProvidedByFactory()) continue;
                arrayList.add(Dependency.get(parameter.getPrimaryBindingKey()));
            }
        }
        return ImmutableSet.copyOf((Collection)arrayList);
    }

    @Override
    public F get() {
        InvocationHandler invocationHandler = new InvocationHandler(){

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) {
                if (method.getDeclaringClass().equals(Object.class)) {
                    if ("equals".equals(method.getName())) {
                        return object == objectArray[0];
                    }
                    if ("hashCode".equals(method.getName())) {
                        return System.identityHashCode(object);
                    }
                    return method.invoke((Object)this, objectArray);
                }
                AssistedConstructor assistedConstructor = (AssistedConstructor)FactoryProvider.this.factoryMethodToConstructor.get(method);
                Object[] objectArray2 = this.gatherArgsForConstructor(assistedConstructor, objectArray);
                Object t = assistedConstructor.newInstance(objectArray2);
                FactoryProvider.this.injector.injectMembers(t);
                return t;
            }

            public Object[] gatherArgsForConstructor(AssistedConstructor<?> assistedConstructor, Object[] objectArray) {
                int n = assistedConstructor.getAllParameters().size();
                int n2 = 0;
                Object[] objectArray2 = new Object[n];
                for (int i = 0; i < n; ++i) {
                    Parameter parameter = assistedConstructor.getAllParameters().get(i);
                    if (parameter.isProvidedByFactory()) {
                        objectArray2[i] = objectArray[n2];
                        ++n2;
                        continue;
                    }
                    objectArray2[i] = parameter.getValue(FactoryProvider.this.injector);
                }
                return objectArray2;
            }
        };
        Class<F> clazz = this.factoryType.getRawType();
        return clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, invocationHandler));
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.factoryType, this.implementationType});
    }

    public boolean equals(Object object) {
        if (!(object instanceof FactoryProvider)) {
            return false;
        }
        FactoryProvider factoryProvider = (FactoryProvider)object;
        return this.factoryType.equals(factoryProvider.factoryType) && this.implementationType.equals(factoryProvider.implementationType);
    }

    private static ConfigurationException newConfigurationException(String string, Object ... objectArray) {
        return new ConfigurationException((Iterable<Message>)ImmutableSet.of((Object)new Message(Errors.format(string, objectArray))));
    }
}

