/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.plotsquared.google.BindingAnnotation;
import com.plotsquared.google.Key;
import com.plotsquared.google.ScopeAnnotation;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.name.Names;
import jakarta.inject.Named;
import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class Annotations {
    private static final LoadingCache<Class<? extends Annotation>, Annotation> cache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Class<? extends Annotation>, Annotation>(){

        public Annotation load(Class<? extends Annotation> clazz) {
            return Annotations.generateAnnotationImpl(clazz);
        }
    });
    private static final Joiner.MapJoiner JOINER = Joiner.on((String)", ").withKeyValueSeparator("=");
    private static final AnnotationToStringConfig ANNOTATION_TO_STRING_CONFIG = Annotations.determineAnnotationToStringConfig();
    private static final AnnotationChecker scopeChecker = new AnnotationChecker(Arrays.asList(ScopeAnnotation.class, Scope.class));
    private static final AnnotationChecker bindingAnnotationChecker = new AnnotationChecker(Arrays.asList(BindingAnnotation.class, Qualifier.class));

    public static boolean isMarker(Class<? extends Annotation> clazz) {
        return clazz.getDeclaredMethods().length == 0;
    }

    public static boolean isAllDefaultMethods(Class<? extends Annotation> clazz) {
        boolean bl = false;
        for (Method method : clazz.getDeclaredMethods()) {
            bl = true;
            if (method.getDefaultValue() != null) continue;
            return false;
        }
        return bl;
    }

    public static <T extends Annotation> T generateAnnotation(Class<T> clazz) {
        Preconditions.checkState((boolean)Annotations.isAllDefaultMethods(clazz), (String)"%s is not all default methods", clazz);
        return (T)((Annotation)cache.getUnchecked(clazz));
    }

    private static <T extends Annotation> T generateAnnotationImpl(final Class<T> clazz) {
        ImmutableMap<String, Object> immutableMap = Annotations.resolveMembers(clazz);
        return (T)((Annotation)clazz.cast(Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new InvocationHandler((Map)immutableMap){
            final /* synthetic */ Map val$members;
            {
                this.val$members = map;
            }

            @Override
            public Object invoke(Object object, Method method, Object[] objectArray) {
                String string = method.getName();
                if (string.equals("annotationType")) {
                    return clazz;
                }
                if (string.equals("toString")) {
                    return Annotations.annotationToString(clazz, this.val$members);
                }
                if (string.equals("hashCode")) {
                    return Annotations.annotationHashCode(clazz, this.val$members);
                }
                if (string.equals("equals")) {
                    return Annotations.annotationEquals(clazz, this.val$members, objectArray[0]);
                }
                return this.val$members.get(string);
            }
        })));
    }

    private static ImmutableMap<String, Object> resolveMembers(Class<? extends Annotation> clazz) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : clazz.getDeclaredMethods()) {
            builder.put((Object)method.getName(), method.getDefaultValue());
        }
        return builder.buildOrThrow();
    }

    private static boolean annotationEquals(Class<? extends Annotation> clazz, Map<String, Object> map, Object object) {
        if (!clazz.isInstance(object)) {
            return false;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            String string = method.getName();
            if (Arrays.deepEquals(new Object[]{method.invoke(object, new Object[0])}, new Object[]{map.get(string)})) continue;
            return false;
        }
        return true;
    }

    private static int annotationHashCode(Class<? extends Annotation> clazz, Map<String, Object> map) {
        int n = 0;
        for (Method method : clazz.getDeclaredMethods()) {
            String string = method.getName();
            Object object = map.get(string);
            n += 127 * string.hashCode() ^ Arrays.deepHashCode(new Object[]{object}) - 31;
        }
        return n;
    }

    private static String annotationToString(Class<? extends Annotation> clazz, Map<String, Object> map) {
        StringBuilder stringBuilder = new StringBuilder().append('@').append(clazz.getName()).append('(');
        JOINER.appendTo(stringBuilder, Maps.transformValues(map, object -> {
            String string = Arrays.deepToString(new Object[]{object});
            return string.substring(1, string.length() - 1);
        }));
        return stringBuilder.append(')').toString();
    }

    public static boolean isRetainedAtRuntime(Class<? extends Annotation> clazz) {
        Retention retention = clazz.getAnnotation(Retention.class);
        return retention != null && retention.value() == RetentionPolicy.RUNTIME;
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Class<?> clazz) {
        return Annotations.findScopeAnnotation(errors, clazz.getAnnotations());
    }

    public static Class<? extends Annotation> findScopeAnnotation(Errors errors, Annotation[] annotationArray) {
        Class<? extends Annotation> clazz = null;
        for (Annotation annotation : annotationArray) {
            Class<? extends Annotation> clazz2 = annotation.annotationType();
            if (!Annotations.isScopeAnnotation(clazz2)) continue;
            if (clazz != null) {
                errors.duplicateScopeAnnotations(clazz, clazz2);
                continue;
            }
            clazz = clazz2;
        }
        return clazz;
    }

    static boolean containsComponentAnnotation(Annotation[] annotationArray) {
        for (Annotation annotation : annotationArray) {
            if (!annotation.annotationType().getSimpleName().equals("Component")) continue;
            return true;
        }
        return false;
    }

    public static String memberValueString(String string) {
        return Annotations.ANNOTATION_TO_STRING_CONFIG.quote ? "\"" + string + "\"" : string;
    }

    public static String memberValueString(String string, Object object) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = Annotations.ANNOTATION_TO_STRING_CONFIG.quote;
        boolean bl2 = Annotations.ANNOTATION_TO_STRING_CONFIG.includeMemberName;
        if (bl2) {
            stringBuilder.append(string).append('=');
        }
        if (bl && object instanceof String) {
            stringBuilder.append('\"').append(object).append('\"');
        } else {
            stringBuilder.append(object);
        }
        return stringBuilder.toString();
    }

    public static String annotationInstanceClassString(Class<? extends Annotation> clazz, boolean bl) {
        if (Annotations.ANNOTATION_TO_STRING_CONFIG.dollarSeparator) {
            if (bl || clazz.getPackage() == null) {
                return "@" + clazz.getName();
            }
            return "@" + clazz.getName().substring(clazz.getPackage().getName().length() + 1);
        }
        return "@" + Annotations.dotSeparatedParentOrPackage(clazz, bl);
    }

    private static String dotSeparatedParentOrPackage(Class<?> clazz, boolean bl) {
        if (clazz.getDeclaringClass() == null) {
            if (bl) {
                return clazz.getPackage().getName() + "." + clazz.getSimpleName();
            }
            return clazz.getSimpleName();
        }
        return Annotations.dotSeparatedParentOrPackage(clazz.getDeclaringClass(), bl) + "." + clazz.getSimpleName();
    }

    @TestAnnotation(value="determineAnnotationToStringConfig")
    private static AnnotationToStringConfig determineAnnotationToStringConfig() {
        try {
            String string = Annotations.class.getDeclaredMethod("determineAnnotationToStringConfig", new Class[0]).getAnnotation(TestAnnotation.class).toString();
            boolean bl = string.contains("\"determineAnnotationToStringConfig\"");
            boolean bl2 = string.contains("value=");
            boolean bl3 = string.contains("Annotations$TestAnnotation");
            return new AnnotationToStringConfig(bl, bl2, bl3);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
    }

    public static boolean isScopeAnnotation(Class<? extends Annotation> clazz) {
        return scopeChecker.hasAnnotations(clazz);
    }

    public static void checkForMisplacedScopeAnnotations(Class<?> clazz, Object object, Errors errors) {
        if (Classes.isConcrete(clazz)) {
            return;
        }
        Class<? extends Annotation> clazz2 = Annotations.findScopeAnnotation(errors, clazz);
        if (clazz2 != null && !Annotations.containsComponentAnnotation(clazz.getAnnotations())) {
            errors.withSource(clazz).scopeAnnotationOnAbstractType(clazz2, clazz, object);
        }
    }

    public static Key<?> getKey(TypeLiteral<?> typeLiteral, Member member, Annotation[] annotationArray, Errors errors) {
        int n = errors.size();
        Annotation annotation = Annotations.findBindingAnnotation(errors, member, annotationArray);
        errors.throwIfNewErrors(n);
        return annotation == null ? Key.get(typeLiteral) : Key.get(typeLiteral, annotation);
    }

    public static Annotation findBindingAnnotation(Errors errors, Member member, Annotation[] annotationArray) {
        Annotation annotation = null;
        for (Annotation annotation2 : annotationArray) {
            Class<? extends Annotation> clazz = annotation2.annotationType();
            if (!Annotations.isBindingAnnotation(clazz)) continue;
            if (annotation != null) {
                errors.duplicateBindingAnnotations(member, annotation.annotationType(), clazz);
                continue;
            }
            annotation = annotation2;
        }
        return annotation;
    }

    public static boolean isBindingAnnotation(Class<? extends Annotation> clazz) {
        return bindingAnnotationChecker.hasAnnotations(clazz);
    }

    public static Annotation canonicalizeIfNamed(Annotation annotation) {
        if (annotation instanceof Named) {
            return Names.named(((Named)annotation).value());
        }
        return annotation;
    }

    public static Class<? extends Annotation> canonicalizeIfNamed(Class<? extends Annotation> clazz) {
        if (clazz == Named.class) {
            return com.plotsquared.google.name.Named.class;
        }
        return clazz;
    }

    public static String nameOf(Key<?> key) {
        Annotation annotation = key.getAnnotation();
        Class<Annotation> clazz = key.getAnnotationType();
        if (annotation != null && !Annotations.isMarker(clazz)) {
            return key.getAnnotation().toString();
        }
        if (key.getAnnotationType() != null) {
            return '@' + key.getAnnotationType().getName();
        }
        return "";
    }

    static class AnnotationChecker {
        private final Collection<Class<? extends Annotation>> annotationTypes;
        private CacheLoader<Class<? extends Annotation>, Boolean> hasAnnotations = new CacheLoader<Class<? extends Annotation>, Boolean>(){

            public Boolean load(Class<? extends Annotation> clazz) {
                for (Annotation annotation : clazz.getAnnotations()) {
                    if (!annotationTypes.contains(annotation.annotationType())) continue;
                    return true;
                }
                return false;
            }
        };
        final LoadingCache<Class<? extends Annotation>, Boolean> cache = CacheBuilder.newBuilder().weakKeys().build(this.hasAnnotations);

        AnnotationChecker(Collection<Class<? extends Annotation>> collection) {
            this.annotationTypes = collection;
        }

        boolean hasAnnotations(Class<? extends Annotation> clazz) {
            return (Boolean)this.cache.getUnchecked(clazz);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface TestAnnotation {
        public String value();
    }

    private static class AnnotationToStringConfig {
        final boolean quote;
        final boolean includeMemberName;
        final boolean dollarSeparator;

        AnnotationToStringConfig(boolean bl, boolean bl2, boolean bl3) {
            this.quote = bl;
            this.includeMemberName = bl2;
            this.dollarSeparator = bl3;
        }
    }
}

