/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.spi.ErrorDetail;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;

final class ChildBindingAlreadySetError
extends InternalErrorDetail<ChildBindingAlreadySetError> {
    private final Key<?> key;
    private final ImmutableList<Object> existingSources;

    ChildBindingAlreadySetError(Key<?> key, Iterable<Object> iterable, List<Object> list) {
        super(ErrorId.CHILD_BINDING_ALREADY_SET, String.format("Unable to create binding for %s because it was already configured on one or more child injectors or private modules.", Messages.convert(key)), list, null);
        this.key = key;
        this.existingSources = ImmutableList.copyOf((Collection)Streams.stream(iterable).map(object -> object == null ? "" : object).collect(Collectors.toList()));
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        return errorDetail instanceof ChildBindingAlreadySetError && ((ChildBindingAlreadySetError)errorDetail).key.equals(this.key);
    }

    @Override
    public void formatDetail(List<ErrorDetail<?>> list2, Formatter formatter) {
        Object object2;
        formatter.format("\n%s\n", Messages.bold("Bound at:"));
        int n = 1;
        for (Object object2 : this.existingSources) {
            formatter.format("%-2s: ", n++);
            if (object2.equals("")) {
                formatter.format("as a just-in-time binding\n", new Object[0]);
                continue;
            }
            new SourceFormatter(object2, formatter, true).format();
        }
        ArrayList arrayList = new ArrayList();
        arrayList.add(this.getSources());
        list2.forEach(errorDetail -> arrayList.add(errorDetail.getSources()));
        object2 = arrayList.stream().map(this::trimSource).filter(list -> !list.isEmpty()).collect(Collectors.toList());
        if (!object2.isEmpty()) {
            formatter.format("\n%s\n", Messages.bold("Requested by:"));
            for (int i = 0; i < arrayList.size(); ++i) {
                ErrorFormatter.formatSources(i + 1, (List)arrayList.get(i), formatter);
            }
        }
    }

    @Override
    public ChildBindingAlreadySetError withSources(List<Object> list) {
        return new ChildBindingAlreadySetError(this.key, (Iterable<Object>)this.existingSources, list);
    }

    private List<Object> trimSource(List<Object> list) {
        return list.stream().filter(object -> !object.equals(this.key)).collect(Collectors.toList());
    }
}

