/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

interface CycleDetectingLock<ID> {
    public ListMultimap<Thread, ID> lockOrDetectPotentialLocksCycle();

    public void unlock();

    public static class CycleDetectingLockFactory<ID> {
        private static Map<Thread, ReentrantCycleDetectingLock<?>> lockThreadIsWaitingOn = Maps.newHashMap();
        private static final Multimap<Thread, ReentrantCycleDetectingLock<?>> locksOwnedByThread = LinkedHashMultimap.create();

        CycleDetectingLock<ID> create(ID ID) {
            return new ReentrantCycleDetectingLock<ID>(this, ID, new ReentrantLock());
        }

        static class ReentrantCycleDetectingLock<ID>
        implements CycleDetectingLock<ID> {
            private final Lock lockImplementation;
            private final ID userLockId;
            private final CycleDetectingLockFactory<ID> lockFactory;
            private Thread lockOwnerThread = null;
            private int lockReentranceCount = 0;

            ReentrantCycleDetectingLock(CycleDetectingLockFactory<ID> cycleDetectingLockFactory, ID ID, Lock lock) {
                this.lockFactory = cycleDetectingLockFactory;
                this.userLockId = Preconditions.checkNotNull(ID, (Object)"userLockId");
                this.lockImplementation = (Lock)Preconditions.checkNotNull((Object)lock, (Object)"lockImplementation");
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ListMultimap<Thread, ID> lockOrDetectPotentialLocksCycle() {
                Thread thread = Thread.currentThread();
                Class<CycleDetectingLockFactory> clazz = CycleDetectingLockFactory.class;
                synchronized (CycleDetectingLockFactory.class) {
                    this.checkState();
                    if (this.lockOwnerThread != thread) {
                        lockThreadIsWaitingOn.put(thread, this);
                        ListMultimap<Thread, ID> listMultimap = this.detectPotentialLocksCycle();
                        if (!listMultimap.isEmpty()) {
                            lockThreadIsWaitingOn.remove(thread);
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            return listMultimap;
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    this.lockImplementation.lock();
                    clazz = CycleDetectingLockFactory.class;
                    synchronized (CycleDetectingLockFactory.class) {
                        lockThreadIsWaitingOn.remove(thread);
                        this.checkState();
                        this.lockOwnerThread = thread;
                        ++this.lockReentranceCount;
                        locksOwnedByThread.put((Object)thread, (Object)this);
                        // ** MonitorExit[var2_2] (shouldn't be in output)
                        return ImmutableListMultimap.of();
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void unlock() {
                Thread thread = Thread.currentThread();
                Class<CycleDetectingLockFactory> clazz = CycleDetectingLockFactory.class;
                synchronized (CycleDetectingLockFactory.class) {
                    this.checkState();
                    Preconditions.checkState((this.lockOwnerThread != null ? 1 : 0) != 0, (Object)"Thread is trying to unlock a lock that is not locked");
                    Preconditions.checkState((this.lockOwnerThread == thread ? 1 : 0) != 0, (Object)"Thread is trying to unlock a lock owned by another thread");
                    this.lockImplementation.unlock();
                    --this.lockReentranceCount;
                    if (this.lockReentranceCount == 0) {
                        this.lockOwnerThread = null;
                        Preconditions.checkState((boolean)locksOwnedByThread.remove((Object)thread, (Object)this), (Object)"Internal error: Can not find this lock in locks owned by a current thread");
                        if (locksOwnedByThread.get((Object)thread).isEmpty()) {
                            locksOwnedByThread.removeAll((Object)thread);
                        }
                    }
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    return;
                }
            }

            void checkState() {
                Thread thread = Thread.currentThread();
                Preconditions.checkState((!lockThreadIsWaitingOn.containsKey(thread) ? 1 : 0) != 0, (Object)"Internal error: Thread should not be in a waiting thread on a lock now");
                if (this.lockOwnerThread != null) {
                    Preconditions.checkState((this.lockReentranceCount >= 0 ? 1 : 0) != 0, (Object)"Internal error: Lock ownership and reentrance count internal states do not match");
                    Preconditions.checkState((boolean)locksOwnedByThread.get((Object)this.lockOwnerThread).contains(this), (Object)"Internal error: Set of locks owned by a current thread and lock ownership status do not match");
                } else {
                    Preconditions.checkState((this.lockReentranceCount == 0 ? 1 : 0) != 0, (Object)"Internal error: Reentrance count of a non locked lock is expect to be zero");
                    Preconditions.checkState((!locksOwnedByThread.values().contains(this) ? 1 : 0) != 0, (Object)"Internal error: Non locked lock should not be owned by any thread");
                }
            }

            private ListMultimap<Thread, ID> detectPotentialLocksCycle() {
                Thread thread = Thread.currentThread();
                if (this.lockOwnerThread == null || this.lockOwnerThread == thread) {
                    return ImmutableListMultimap.of();
                }
                ListMultimap listMultimap = MultimapBuilder.linkedHashKeys().arrayListValues().build();
                ReentrantCycleDetectingLock<?> reentrantCycleDetectingLock = this;
                while (reentrantCycleDetectingLock != null && reentrantCycleDetectingLock.lockOwnerThread != null) {
                    Thread thread2 = reentrantCycleDetectingLock.lockOwnerThread;
                    reentrantCycleDetectingLock = this.addAllLockIdsAfter(thread2, reentrantCycleDetectingLock, listMultimap);
                    if (thread2 != thread) continue;
                    return listMultimap;
                }
                return ImmutableListMultimap.of();
            }

            private ReentrantCycleDetectingLock<?> addAllLockIdsAfter(Thread thread, ReentrantCycleDetectingLock<?> reentrantCycleDetectingLock, ListMultimap<Thread, ID> listMultimap) {
                boolean bl = false;
                Collection collection = locksOwnedByThread.get((Object)thread);
                Preconditions.checkNotNull((Object)collection, (Object)"Internal error: No locks were found taken by a thread");
                for (ReentrantCycleDetectingLock<ID> reentrantCycleDetectingLock2 : collection) {
                    if (reentrantCycleDetectingLock2 == reentrantCycleDetectingLock) {
                        bl = true;
                    }
                    if (!bl || reentrantCycleDetectingLock2.lockFactory != this.lockFactory) continue;
                    ID ID = reentrantCycleDetectingLock2.userLockId;
                    listMultimap.put((Object)thread, ID);
                }
                Preconditions.checkState((boolean)bl, (Object)"Internal error: We can not find locks that created a cycle that we detected");
                ReentrantCycleDetectingLock reentrantCycleDetectingLock3 = (ReentrantCycleDetectingLock)lockThreadIsWaitingOn.get(thread);
                if (reentrantCycleDetectingLock3 != null && reentrantCycleDetectingLock3.lockFactory == this.lockFactory) {
                    ReentrantCycleDetectingLock<ID> reentrantCycleDetectingLock2;
                    reentrantCycleDetectingLock2 = reentrantCycleDetectingLock3.userLockId;
                    listMultimap.put((Object)thread, (Object)reentrantCycleDetectingLock2);
                }
                return reentrantCycleDetectingLock3;
            }

            public String toString() {
                Thread thread = this.lockOwnerThread;
                if (thread != null) {
                    return String.format("%s[%s][locked by %s]", super.toString(), this.userLockId, thread);
                }
                return String.format("%s[%s][unlocked]", super.toString(), this.userLockId);
            }
        }
    }
}

