/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableMultimap;
import com.plotsquared.google.Binding;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.ErrorDetail;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

final class DuplicateElementError<T>
extends InternalErrorDetail<DuplicateElementError<T>> {
    private final Key<Set<T>> setKey;
    private final ImmutableMultimap<T, Element<T>> elements;

    DuplicateElementError(Key<Set<T>> key, List<Binding<T>> list, T[] TArray, List<Object> list2) {
        this(key, DuplicateElementError.indexElements(list, TArray), list2);
    }

    private DuplicateElementError(Key<Set<T>> key, ImmutableMultimap<T, Element<T>> immutableMultimap, List<Object> list) {
        super(ErrorId.DUPLICATE_ELEMENT, String.format("Duplicate elements found in Multibinder %s.", Messages.convert(key)), list, null);
        this.setKey = key;
        this.elements = immutableMultimap;
    }

    @Override
    protected void formatDetail(List<ErrorDetail<?>> list, Formatter formatter) {
        formatter.format("\n%s\n", Messages.bold("Duplicates:"));
        int n = 1;
        for (Map.Entry entry : this.elements.asMap().entrySet()) {
            int n2;
            formatter.format("%-2s: ", n++);
            if (((Collection)entry.getValue()).size() <= 1) continue;
            Set set = ((Collection)entry.getValue()).stream().map(element -> element.value.toString()).collect(Collectors.toSet());
            if (set.size() == 1) {
                formatter.format("Element: %s\n", Messages.redBold((String)set.iterator().next()));
                formatter.format("    Bound at:\n", new Object[0]);
                n2 = 1;
                for (Element element2 : (Collection)entry.getValue()) {
                    formatter.format("    %-2s: ", n2++);
                    this.formatElement(element2, formatter);
                }
                continue;
            }
            n2 = 0;
            for (Element element2 : (Collection)entry.getValue()) {
                if (n2 != 0) {
                    formatter.format("    ", new Object[0]);
                } else {
                    n2 = 1;
                }
                formatter.format("Element: %s\n", Messages.redBold(element2.value.toString()));
                formatter.format("    Bound at: ", new Object[0]);
                this.formatElement(element2, formatter);
            }
        }
        formatter.format("\n%s\n", Messages.bold("Multibinder declared at:"));
        Object object2 = this.getSources().stream().filter(object -> {
            if (object instanceof Dependency) {
                return !((Dependency)object).getKey().equals(this.setKey);
            }
            return true;
        }).collect(Collectors.toList());
        ErrorFormatter.formatSources((List<Object>)object2, formatter);
    }

    private void formatElement(Element<T> element, Formatter formatter) {
        Object object = element.binding.getSource();
        new SourceFormatter(object, formatter, true).format();
    }

    @Override
    public DuplicateElementError<T> withSources(List<Object> list) {
        return new DuplicateElementError<T>(this.setKey, this.elements, list);
    }

    static <T> ImmutableMultimap<T, Element<T>> indexElements(List<Binding<T>> list, T[] TArray) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (int i = 0; i < TArray.length; ++i) {
            builder.put(TArray[i], new Element<T>(TArray[i], list.get(i)));
        }
        return builder.build();
    }

    static class Element<T> {
        T value;
        Binding<T> binding;

        Element(T t, Binding<T> binding) {
            this.value = t;
            this.binding = binding;
        }
    }
}

