/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.plotsquared.google.Binding;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.CreationException;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.ProvisionException;
import com.plotsquared.google.Scope;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.BindingAlreadySetError;
import com.plotsquared.google.internal.ChildBindingAlreadySetError;
import com.plotsquared.google.internal.DuplicateMapKeyError;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.GuiceInternal;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.internal.MissingConstructorError;
import com.plotsquared.google.internal.MissingImplementationError;
import com.plotsquared.google.internal.ScopeNotFoundError;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.internal.util.SourceProvider;
import com.plotsquared.google.spi.ElementSource;
import com.plotsquared.google.spi.InterceptorBinding;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ScopeBinding;
import com.plotsquared.google.spi.TypeConverterBinding;
import com.plotsquared.google.spi.TypeListenerBinding;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class Errors
implements Serializable {
    private final Errors root;
    private final Errors parent;
    private final Object source;
    private List<Message> errors;
    private static final String CONSTRUCTOR_RULES = "Injectable classes must have either one (and only one) constructor annotated with @Inject or a zero-argument constructor that is not private.";

    static <T> T checkNotNull(T t, String string) {
        if (t != null) {
            return t;
        }
        NullPointerException nullPointerException = new NullPointerException(string);
        throw new ConfigurationException((Iterable<Message>)ImmutableSet.of((Object)new Message(nullPointerException.toString(), nullPointerException)));
    }

    static void checkConfiguration(boolean bl, String string, Object ... objectArray) {
        if (bl) {
            return;
        }
        throw new ConfigurationException((Iterable<Message>)ImmutableSet.of((Object)new Message(Errors.format(string, objectArray))));
    }

    public Errors() {
        this.root = this;
        this.parent = null;
        this.source = SourceProvider.UNKNOWN_SOURCE;
    }

    public Errors(Object object) {
        this.root = this;
        this.parent = null;
        this.source = object;
    }

    private Errors(Errors errors, Object object) {
        this.root = errors.root;
        this.parent = errors;
        this.source = object;
    }

    public Errors withSource(Object object) {
        return object == this.source || object == SourceProvider.UNKNOWN_SOURCE ? this : new Errors(this, object);
    }

    public Errors aopDisabled(InterceptorBinding interceptorBinding) {
        return this.addMessage(ErrorId.AOP_DISABLED, "Binding interceptor is not supported when bytecode generation is disabled. \nInterceptor bound at: %s", interceptorBinding.getSource());
    }

    public Errors missingImplementation(Key<?> key) {
        return this.addMessage(ErrorId.MISSING_IMPLEMENTATION, "No implementation for %s was bound.", key);
    }

    <T> Errors missingImplementationWithHint(Key<T> key, Injector injector) {
        MissingImplementationError<T> missingImplementationError = new MissingImplementationError<T>(key, injector, this.getSources());
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.MISSING_IMPLEMENTATION, missingImplementationError));
    }

    public Errors jitDisabled(Key<?> key) {
        return this.addMessage(ErrorId.JIT_DISABLED, "Explicit bindings are required and %s is not explicitly bound.", key);
    }

    public Errors jitDisabledInParent(Key<?> key) {
        return this.addMessage(ErrorId.JIT_DISABLED_IN_PARENT, "Explicit bindings are required and %s would be bound in a parent injector.\nPlease add an explicit binding for it, either in the child or the parent.", key);
    }

    public Errors atInjectRequired(TypeLiteral<?> typeLiteral) {
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.MISSING_CONSTRUCTOR, new MissingConstructorError(typeLiteral, true, this.getSources())));
    }

    public Errors converterReturnedNull(String string, Object object, TypeLiteral<?> typeLiteral, TypeConverterBinding typeConverterBinding) {
        return this.addMessage(ErrorId.CONVERTER_RETURNED_NULL, "Received null converting '%s' (bound at %s) to %s\n using %s.", string, Errors.convert(object), typeLiteral, typeConverterBinding);
    }

    public Errors conversionTypeError(String string, Object object, TypeLiteral<?> typeLiteral, TypeConverterBinding typeConverterBinding, Object object2) {
        return this.addMessage(ErrorId.CONVERSION_TYPE_ERROR, "Type mismatch converting '%s' (bound at %s) to %s\n using %s.\n Converter returned %s.", string, Errors.convert(object), typeLiteral, typeConverterBinding, object2);
    }

    public Errors conversionError(String string, Object object, TypeLiteral<?> typeLiteral, TypeConverterBinding typeConverterBinding, RuntimeException runtimeException) {
        return this.errorInUserCode(runtimeException, "Error converting '%s' (bound at %s) to %s\n using %s.\n Reason: %s", string, Errors.convert(object), typeLiteral, typeConverterBinding, runtimeException);
    }

    public Errors ambiguousTypeConversion(String string, Object object, TypeLiteral<?> typeLiteral, TypeConverterBinding typeConverterBinding, TypeConverterBinding typeConverterBinding2) {
        return this.addMessage(ErrorId.AMBIGUOUS_TYPE_CONVERSION, "Multiple converters can convert '%s' (bound at %s) to %s:\n %s and\n %s.\n Please adjust your type converter configuration to avoid overlapping matches.", string, Errors.convert(object), typeLiteral, typeConverterBinding, typeConverterBinding2);
    }

    public Errors bindingToProvider() {
        return this.addMessage(ErrorId.BINDING_TO_PROVIDER, "Binding to Provider is not allowed.", new Object[0]);
    }

    public Errors notASubtype(Class<?> clazz, Class<?> clazz2) {
        return this.addMessage(ErrorId.NOT_A_SUBTYPE, "%s doesn't extend %s.", clazz, clazz2);
    }

    public Errors recursiveImplementationType() {
        return this.addMessage(ErrorId.RECURSIVE_IMPLEMENTATION_TYPE, "@ImplementedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors recursiveProviderType() {
        return this.addMessage(ErrorId.RECURSIVE_PROVIDER_TYPE, "@ProvidedBy points to the same class it annotates.", new Object[0]);
    }

    public Errors missingRuntimeRetention(Class<? extends Annotation> clazz) {
        return this.addMessage(ErrorId.MISSING_RUNTIME_RETENTION, Errors.format("Please annotate %s with @Retention(RUNTIME).", clazz), new Object[0]);
    }

    public Errors missingScopeAnnotation(Class<? extends Annotation> clazz) {
        return this.addMessage(ErrorId.MISSING_SCOPE_ANNOTATION, Errors.format("Please annotate %s with @ScopeAnnotation.", clazz), new Object[0]);
    }

    public Errors optionalConstructor(Constructor<?> constructor) {
        return this.addMessage(ErrorId.OPTIONAL_CONSTRUCTOR, "%s is annotated @Inject(optional=true), but constructors cannot be optional.", constructor);
    }

    public Errors cannotBindToGuiceType(String string) {
        return this.addMessage(ErrorId.BINDING_TO_GUICE_TYPE, "Binding to core guice framework type is not allowed: %s.", string);
    }

    public Errors scopeNotFound(Class<? extends Annotation> clazz) {
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.SCOPE_NOT_FOUND, new ScopeNotFoundError(clazz, this.getSources())));
    }

    public Errors scopeAnnotationOnAbstractType(Class<? extends Annotation> clazz, Class<?> clazz2, Object object) {
        return this.addMessage(ErrorId.SCOPE_ANNOTATION_ON_ABSTRACT_TYPE, "%s is annotated with %s, but scope annotations are not supported for abstract types.\n Bound at %s.", clazz2, clazz, Errors.convert(object));
    }

    public Errors misplacedBindingAnnotation(Member member, Annotation annotation) {
        return this.addMessage(ErrorId.MISPLACED_BINDING_ANNOTATION, "%s is annotated with %s, but binding annotations should be applied to its parameters instead.", member, annotation);
    }

    public Errors missingConstructor(TypeLiteral<?> typeLiteral) {
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.MISSING_CONSTRUCTOR, new MissingConstructorError(typeLiteral, false, this.getSources())));
    }

    public Errors tooManyConstructors(Class<?> clazz) {
        return this.addMessage(ErrorId.TOO_MANY_CONSTRUCTORS, "%s has more than one constructor annotated with @Inject. %s", clazz, CONSTRUCTOR_RULES);
    }

    public Errors constructorNotDefinedByType(Constructor<?> constructor, TypeLiteral<?> typeLiteral) {
        return this.addMessage(ErrorId.CONSTRUCTOR_NOT_DEFINED_BY_TYPE, "%s does not define %s", typeLiteral, constructor);
    }

    public <K, V> Errors duplicateMapKey(Key<Map<K, V>> key, Multimap<K, Binding<V>> multimap) {
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.DUPLICATE_MAP_KEY, new DuplicateMapKeyError<K, V>(key, multimap, this.getSources())));
    }

    public Errors duplicateScopes(ScopeBinding scopeBinding, Class<? extends Annotation> clazz, Scope scope) {
        return this.addMessage(ErrorId.DUPLICATE_SCOPES, "Scope %s is already bound to %s at %s.\n Cannot bind %s.", scopeBinding.getScope(), clazz, scopeBinding.getSource(), scope);
    }

    public Errors voidProviderMethod() {
        return this.addMessage(ErrorId.VOID_PROVIDER_METHOD, "Provider methods must return a value. Do not return void.", new Object[0]);
    }

    public Errors missingConstantValues() {
        return this.addMessage(ErrorId.MISSING_CONSTANT_VALUES, "Missing constant value. Please call to(...).", new Object[0]);
    }

    public Errors cannotInjectInnerClass(Class<?> clazz) {
        return this.addMessage(ErrorId.INJECT_INNER_CLASS, "Injecting into inner classes is not supported.  Please use a 'static' class (top-level or nested) instead of %s.", clazz);
    }

    public Errors cannotInjectLocalClass(Class<?> clazz) {
        return this.addMessage(ErrorId.INJECT_LOCAL_CLASS, "Injecting into local classes is not supported.  Please use a non-local class instead of %s.", clazz);
    }

    public Errors duplicateBindingAnnotations(Member member, Class<? extends Annotation> clazz, Class<? extends Annotation> clazz2) {
        return this.addMessage(ErrorId.DUPLICATE_BINDING_ANNOTATIONS, "%s has more than one annotation annotated with @BindingAnnotation: %s and %s", member, clazz, clazz2);
    }

    public Errors staticInjectionOnInterface(Class<?> clazz) {
        return this.addMessage(ErrorId.STATIC_INJECTION_ON_INTERFACE, "%s is an interface, but interfaces have no static injection points.", clazz);
    }

    public Errors cannotInjectFinalField(Field field) {
        return this.addMessage(ErrorId.INJECT_FINAL_FIELD, "Injected field %s cannot be final.", field);
    }

    public Errors atTargetIsMissingParameter(Annotation annotation, String string, Class<?> clazz) {
        return this.addMessage(ErrorId.AT_TARGET_IS_MISSING_PARAMETER, "Binding annotation %s must have PARAMETER listed in its @Targets. It was used on constructor parameter %s in %s.", annotation, string, clazz);
    }

    public Errors cannotInjectAbstractMethod(Method method) {
        return this.addMessage(ErrorId.INJECT_ABSTRACT_METHOD, "Injected method %s cannot be abstract.", method);
    }

    public Errors cannotInjectMethodWithTypeParameters(Method method) {
        return this.addMessage(ErrorId.INJECT_METHOD_WITH_TYPE_PARAMETER, "Injected method %s cannot declare type parameters of its own.", method);
    }

    public Errors duplicateScopeAnnotations(Class<? extends Annotation> clazz, Class<? extends Annotation> clazz2) {
        return this.addMessage(ErrorId.DUPLICATE_SCOPE_ANNOTATIONS, "More than one scope annotation was found: %s and %s.", clazz, clazz2);
    }

    public Errors recursiveBinding(Key<?> key, Key<?> key2) {
        return this.addMessage(ErrorId.RECURSIVE_BINDING, "Binding points to itself. Key: %s", Messages.convert(key));
    }

    Errors bindingAlreadySet(Binding<?> binding, Binding<?> binding2) {
        BindingAlreadySetError bindingAlreadySetError = new BindingAlreadySetError(binding, binding2, this.getSources());
        return this.addMessage(new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.BINDING_ALREADY_SET, bindingAlreadySetError));
    }

    public Errors bindingAlreadySet(Key<?> key, Object object) {
        return this.addMessage(ErrorId.BINDING_ALREADY_SET, "A binding to %s was already configured at %s.", key, Errors.convert(object));
    }

    public Errors jitBindingAlreadySet(Key<?> key) {
        return this.addMessage(ErrorId.JIT_BINDING_ALREADY_SET, "A just-in-time binding to %s was already configured on a parent injector.", key);
    }

    public Errors childBindingAlreadySet(Key<?> key, Set<Object> set) {
        Message message = new Message(GuiceInternal.GUICE_INTERNAL, ErrorId.CHILD_BINDING_ALREADY_SET, new ChildBindingAlreadySetError(key, set, this.getSources()));
        return this.addMessage(message);
    }

    public Errors errorCheckingDuplicateBinding(Key<?> key, Object object, Throwable throwable) {
        return this.addMessage(ErrorId.OTHER, "A binding to %s was already configured at %s and an error was thrown while checking duplicate bindings.  Error: %s", key, Errors.convert(object), throwable);
    }

    public Errors requestInjectionWithDifferentTypes(Object object, TypeLiteral<?> typeLiteral, Object object2, TypeLiteral<?> typeLiteral2) {
        return this.addMessage(ErrorId.REQUEST_INJECTION_WITH_DIFFERENT_TYPES, "Cannot request injection on one instance with two different types. requestInjection was already called for instance %s at %s (with type %s), which is different than type %s.", object.getClass().getName() + "@" + System.identityHashCode(object), object2, typeLiteral, typeLiteral2);
    }

    public Errors errorNotifyingTypeListener(TypeListenerBinding typeListenerBinding, TypeLiteral<?> typeLiteral, Throwable throwable) {
        return this.errorInUserCode(throwable, "Error notifying TypeListener %s (bound at %s) of %s.\n Reason: %s", typeListenerBinding.getListener(), Errors.convert(typeListenerBinding.getSource()), typeLiteral, throwable);
    }

    public Errors exposedButNotBound(Key<?> key) {
        return this.addMessage(ErrorId.EXPOSED_BUT_NOT_BOUND, "Could not expose() %s, it must be explicitly bound.", key);
    }

    public Errors keyNotFullySpecified(TypeLiteral<?> typeLiteral) {
        return this.addMessage(ErrorId.KEY_NOT_FULLY_SPECIFIED, "%s cannot be used as a key; It is not fully specified.", typeLiteral);
    }

    public Errors errorEnhancingClass(Class<?> clazz, Throwable throwable) {
        return this.errorInUserCode(throwable, "Unable to method intercept: %s", clazz);
    }

    public static Collection<Message> getMessagesFromThrowable(Throwable throwable) {
        if (throwable instanceof ProvisionException) {
            return ((ProvisionException)throwable).getErrorMessages();
        }
        if (throwable instanceof ConfigurationException) {
            return ((ConfigurationException)throwable).getErrorMessages();
        }
        if (throwable instanceof CreationException) {
            return ((CreationException)throwable).getErrorMessages();
        }
        return ImmutableSet.of();
    }

    public Errors errorInUserCode(Throwable throwable, String string, Object ... objectArray) {
        Collection<Message> collection = Errors.getMessagesFromThrowable(throwable);
        if (!collection.isEmpty()) {
            return this.merge(collection);
        }
        return this.addMessage(ErrorId.ERROR_IN_USER_CODE, throwable, string, objectArray);
    }

    public Errors cannotInjectRawProvider() {
        return this.addMessage(ErrorId.INJECT_RAW_PROVIDER, "Cannot inject a Provider that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectRawMembersInjector() {
        return this.addMessage(ErrorId.INJECT_RAW_MEMBERS_INJECTOR, "Cannot inject a MembersInjector that has no type parameter", new Object[0]);
    }

    public Errors cannotInjectTypeLiteralOf(Type type) {
        return this.addMessage(ErrorId.OTHER, "Cannot inject a TypeLiteral of %s", type);
    }

    public Errors cannotInjectRawTypeLiteral() {
        return this.addMessage(ErrorId.INJECT_RAW_TYPE_LITERAL, "Cannot inject a TypeLiteral that has no type parameter", new Object[0]);
    }

    public void throwCreationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        CreationException creationException = new CreationException(this.getMessages());
        throw creationException;
    }

    public void throwConfigurationExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        ConfigurationException configurationException = new ConfigurationException(this.getMessages());
        throw configurationException;
    }

    public void throwProvisionExceptionIfErrorsExist() {
        if (!this.hasErrors()) {
            return;
        }
        ProvisionException provisionException = new ProvisionException(this.getMessages());
        throw provisionException;
    }

    public Errors merge(Collection<Message> collection) {
        List<Object> list = this.getSources();
        for (Message message : collection) {
            this.addMessage(Messages.mergeSources(list, message));
        }
        return this;
    }

    public Errors merge(Errors errors) {
        if (errors.root == this.root || errors.root.errors == null) {
            return this;
        }
        this.merge(errors.root.errors);
        return this;
    }

    public Errors merge(InternalProvisionException internalProvisionException) {
        this.merge((Collection<Message>)internalProvisionException.getErrors());
        return this;
    }

    private List<Object> getSources() {
        ArrayList arrayList = Lists.newArrayList();
        Errors errors = this;
        while (errors != null) {
            if (errors.source != SourceProvider.UNKNOWN_SOURCE) {
                arrayList.add(0, errors.source);
            }
            errors = errors.parent;
        }
        return arrayList;
    }

    public void throwIfNewErrors(int n) {
        if (this.size() == n) {
            return;
        }
        throw this.toException();
    }

    public ErrorsException toException() {
        return new ErrorsException(this);
    }

    public boolean hasErrors() {
        return this.root.errors != null;
    }

    public Errors addMessage(String string, Object ... objectArray) {
        return this.addMessage(ErrorId.OTHER, null, string, objectArray);
    }

    public Errors addMessage(ErrorId errorId, String string, Object ... objectArray) {
        return this.addMessage(errorId, null, string, objectArray);
    }

    private Errors addMessage(ErrorId errorId, Throwable throwable, String string, Object ... objectArray) {
        this.addMessage(Messages.create(errorId, throwable, this.getSources(), string, objectArray));
        return this;
    }

    public Errors addMessage(Message message) {
        if (this.root.errors == null) {
            this.root.errors = Lists.newArrayList();
        }
        this.root.errors.add(message);
        return this;
    }

    public static String format(String string, Object ... objectArray) {
        return Messages.format(string, objectArray);
    }

    public List<Message> getMessages() {
        if (this.root.errors == null) {
            return ImmutableList.of();
        }
        return new Ordering<Message>(this){

            public int compare(Message message, Message message2) {
                return message.getSource().compareTo(message2.getSource());
            }
        }.sortedCopy(this.root.errors);
    }

    public int size() {
        return this.root.errors == null ? 0 : this.root.errors.size();
    }

    public static Object convert(Object object) {
        return Messages.convert(object);
    }

    public static Object convert(Object object, ElementSource elementSource) {
        return Messages.convert(object, elementSource);
    }

    public static void formatSource(Formatter formatter, Object object) {
        formatter.format("  ", new Object[0]);
        new SourceFormatter(object, formatter, false).format();
    }
}

