/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Injector;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.BindingTargetVisitor;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.ExposedBinding;
import com.plotsquared.google.spi.PrivateElements;
import java.util.Set;

final class ExposedBindingImpl<T>
extends BindingImpl<T>
implements ExposedBinding<T> {
    private final PrivateElements privateElements;

    ExposedBindingImpl(InjectorImpl injectorImpl, Object object, Key<T> key, InternalFactory<T> internalFactory, PrivateElements privateElements) {
        super(injectorImpl, key, object, internalFactory, Scoping.UNSCOPED);
        this.privateElements = privateElements;
    }

    @Override
    public <V> V acceptTargetVisitor(BindingTargetVisitor<? super T, V> bindingTargetVisitor) {
        return bindingTargetVisitor.visit(this);
    }

    @Override
    public Set<Dependency<?>> getDependencies() {
        return ImmutableSet.of(Dependency.get(Key.get(Injector.class)));
    }

    @Override
    public PrivateElements getPrivateElements() {
        return this.privateElements;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(ExposedBinding.class).add("key", this.getKey()).add("source", this.getSource()).add("privateElements", (Object)this.privateElements).toString();
    }

    @Override
    public void applyTo(Binder binder) {
        throw new UnsupportedOperationException("This element represents a synthetic binding.");
    }
}

