/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.binder.AnnotatedElementBuilder;
import java.lang.annotation.Annotation;

public class ExposureBuilder<T>
implements AnnotatedElementBuilder {
    private final Binder binder;
    private final Object source;
    private Key<T> key;

    public ExposureBuilder(Binder binder, Object object, Key<T> key) {
        this.binder = binder;
        this.source = object;
        this.key = key;
    }

    protected void checkNotAnnotated() {
        if (this.key.getAnnotationType() != null) {
            this.binder.addError("More than one annotation is specified for this binding.", new Object[0]);
        }
    }

    @Override
    public void annotatedWith(Class<? extends Annotation> clazz) {
        Preconditions.checkNotNull(clazz, (Object)"annotationType");
        this.checkNotAnnotated();
        this.key = this.key.withAnnotation(clazz);
    }

    @Override
    public void annotatedWith(Annotation annotation) {
        Preconditions.checkNotNull((Object)annotation, (Object)"annotation");
        this.checkNotAnnotated();
        this.key = this.key.withAnnotation(annotation);
    }

    public Key<?> getKey() {
        return this.key;
    }

    public Object getSource() {
        return this.source;
    }

    public String toString() {
        return "AnnotatedElementBuilder";
    }
}

