/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public abstract class FailableCache<K, V> {
    private final Set<K> loadingSet = ConcurrentHashMap.newKeySet();
    private final LoadingCache<K, Object> delegate = CacheBuilder.newBuilder().build(new CacheLoader<K, Object>(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object load(K k) {
            FailableCache.this.loadingSet.add(k);
            Errors errors = new Errors();
            Object var3_3 = null;
            try {
                var3_3 = FailableCache.this.create(k, errors);
            }
            catch (ErrorsException errorsException) {
                errors.merge(errorsException.getErrors());
            }
            finally {
                FailableCache.this.loadingSet.remove(k);
            }
            return errors.hasErrors() ? errors : var3_3;
        }
    });

    protected abstract V create(K var1, Errors var2);

    public V get(K k, Errors errors) {
        Object object = this.delegate.getUnchecked(k);
        if (object instanceof Errors) {
            errors.merge((Errors)object);
            throw errors.toException();
        }
        Object object2 = object;
        return (V)object2;
    }

    boolean remove(K k) {
        return this.delegate.asMap().remove(k) != null;
    }

    boolean isLoading(K k) {
        return this.loadingSet.contains(k);
    }

    Map<K, V> asMap() {
        return Maps.transformValues((Map)Maps.filterValues((Map)ImmutableMap.copyOf((Map)this.delegate.asMap()), object -> !(object instanceof Errors)), object -> {
            Object object2 = object;
            return object2;
        });
    }
}

