/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.Stage;
import com.plotsquared.google.internal.AbstractProcessor;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.Initializable;
import com.plotsquared.google.internal.Initializer;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.SingleMemberInjector;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.InjectionRequest;
import com.plotsquared.google.spi.StaticInjectionRequest;
import java.util.List;
import java.util.Set;

final class InjectionRequestProcessor
extends AbstractProcessor {
    private final List<StaticInjection> staticInjections = Lists.newArrayList();
    private final Initializer initializer;

    InjectionRequestProcessor(Errors errors, Initializer initializer) {
        super(errors);
        this.initializer = initializer;
    }

    @Override
    public Boolean visit(StaticInjectionRequest staticInjectionRequest) {
        this.staticInjections.add(new StaticInjection(this.injector, staticInjectionRequest));
        this.injector.getBindingData().putStaticInjectionRequest(staticInjectionRequest);
        return true;
    }

    @Override
    public Boolean visit(InjectionRequest<?> injectionRequest) {
        Set set;
        try {
            set = injectionRequest.getInjectionPoints();
        }
        catch (ConfigurationException configurationException) {
            this.errors.merge(configurationException.getErrorMessages());
            set = (Set)configurationException.getPartialValue();
        }
        this.requestInjection(injectionRequest, set, this.errors);
        this.injector.getBindingData().putInjectionRequest(new InjectionRequest<Object>(injectionRequest.getSource(), injectionRequest.getType(), null));
        return true;
    }

    private <T> void requestInjection(InjectionRequest<T> injectionRequest, Set<InjectionPoint> set, Errors errors) {
        Initializable<T> initializable = this.initializer.requestInjection(this.injector, injectionRequest.getType(), injectionRequest.getInstance(), null, injectionRequest.getSource(), set, errors);
    }

    void validate() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.validate();
        }
    }

    void injectMembers() {
        for (StaticInjection staticInjection : this.staticInjections) {
            staticInjection.injectMembers();
        }
    }

    private class StaticInjection {
        final InjectorImpl injector;
        final Object source;
        final StaticInjectionRequest request;
        ImmutableList<SingleMemberInjector> memberInjectors;

        public StaticInjection(InjectorImpl injectorImpl, StaticInjectionRequest staticInjectionRequest) {
            this.injector = injectorImpl;
            this.source = staticInjectionRequest.getSource();
            this.request = staticInjectionRequest;
        }

        void validate() {
            Set set;
            Errors errors = InjectionRequestProcessor.this.errors.withSource(this.source);
            try {
                set = this.request.getInjectionPoints();
            }
            catch (ConfigurationException configurationException) {
                errors.merge(configurationException.getErrorMessages());
                set = (Set)configurationException.getPartialValue();
            }
            this.memberInjectors = set != null ? this.injector.membersInjectorStore.getInjectors(set, errors) : ImmutableList.of();
            InjectionRequestProcessor.this.errors.merge(errors);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void injectMembers() {
            try (InternalContext internalContext = this.injector.enterContext();){
                boolean bl = this.injector.options.stage == Stage.TOOL;
                for (SingleMemberInjector singleMemberInjector : this.memberInjectors) {
                    if (bl && !singleMemberInjector.getInjectionPoint().isToolable()) continue;
                    try {
                        singleMemberInjector.inject(internalContext, null);
                    }
                    catch (InternalProvisionException internalProvisionException) {
                        InjectionRequestProcessor.this.errors.merge(internalProvisionException);
                    }
                }
            }
        }
    }
}

