/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.spi.Dependency;
import java.util.IdentityHashMap;

final class InternalContext
implements AutoCloseable {
    private final InjectorImpl.InjectorOptions options;
    private final IdentityHashMap<Object, ConstructionContext<?>> constructionContexts = new IdentityHashMap();
    private Dependency<?> dependency;
    private int enterCount;
    private final Object[] toClear;

    InternalContext(InjectorImpl.InjectorOptions injectorOptions, Object[] objectArray) {
        this.options = injectorOptions;
        this.toClear = objectArray;
        this.enterCount = 1;
    }

    void enter() {
        ++this.enterCount;
    }

    @Override
    public void close() {
        int n;
        if ((n = --this.enterCount) < 0) {
            throw new IllegalStateException("Called close() too many times");
        }
        if (n == 0) {
            this.toClear[0] = null;
        }
    }

    InjectorImpl.InjectorOptions getInjectorOptions() {
        return this.options;
    }

    <T> ConstructionContext<T> getConstructionContext(Object object) {
        ConstructionContext<Object> constructionContext = this.constructionContexts.get(object);
        if (constructionContext == null) {
            constructionContext = new ConstructionContext();
            this.constructionContexts.put(object, constructionContext);
        }
        return constructionContext;
    }

    Dependency<?> getDependency() {
        return this.dependency;
    }

    void setDependency(Dependency<?> dependency) {
        this.dependency = dependency;
    }
}

