/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.spi.Dependency;

final class InternalFactoryToProviderAdapter<T>
implements InternalFactory<T> {
    private final Provider<? extends T> provider;
    private final Object source;

    public InternalFactoryToProviderAdapter(Provider<? extends T> provider, Object object) {
        this.provider = (Provider)Preconditions.checkNotNull(provider, (Object)"provider");
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
    }

    @Override
    public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
        internalContext.setDependency(dependency);
        try {
            T t = this.provider.get();
            if (t == null && !dependency.isNullable()) {
                InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
            }
            return t;
        }
        catch (RuntimeException runtimeException) {
            throw InternalProvisionException.errorInProvider(runtimeException).addSource(this.source);
        }
    }

    public String toString() {
        return this.provider.toString();
    }
}

