/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Key;
import com.plotsquared.google.Provider;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.DelayedInitialize;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProviderInstanceBindingImpl;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.internal.Scoping;
import com.plotsquared.google.spi.Dependency;
import com.plotsquared.google.spi.HasDependencies;
import com.plotsquared.google.spi.InjectionPoint;
import java.util.Set;

final class InternalProviderInstanceBindingImpl<T>
extends ProviderInstanceBindingImpl<T>
implements DelayedInitialize {
    private final Factory<T> originalFactory;

    InternalProviderInstanceBindingImpl(InjectorImpl injectorImpl, Key<T> key, Object object, Factory<T> factory, InternalFactory<? extends T> internalFactory, Scoping scoping) {
        super(injectorImpl, key, object, internalFactory, scoping, factory, (Set<InjectionPoint>)ImmutableSet.of());
        this.originalFactory = factory;
    }

    InitializationTiming getInitializationTiming() {
        return ((Factory)this.originalFactory).initializationTiming;
    }

    @Override
    public void initialize(InjectorImpl injectorImpl, Errors errors) {
        ((Factory)this.originalFactory).source = this.getSource();
        this.originalFactory.provisionCallback = injectorImpl.provisionListenerStore.get(this);
        ((Factory)this.originalFactory).delegateProvider = this.getProvider();
        this.originalFactory.initialize(injectorImpl, errors);
    }

    static abstract class CyclicFactory<T>
    extends Factory<T> {
        CyclicFactory(InitializationTiming initializationTiming) {
            super(initializationTiming);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final T get(final InternalContext internalContext, final Dependency<?> dependency, boolean bl) {
            final ConstructionContext constructionContext = internalContext.getConstructionContext(this);
            if (constructionContext.isConstructing()) {
                Class<?> clazz = dependency.getKey().getTypeLiteral().getRawType();
                Object object = constructionContext.createProxy(internalContext.getInjectorOptions(), clazz);
                return (T)object;
            }
            constructionContext.startConstruction();
            try {
                if (this.provisionCallback == null) {
                    Object t = this.provision(dependency, internalContext, constructionContext);
                    return t;
                }
                Object t = this.provisionCallback.provision(internalContext, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                    @Override
                    public T call() {
                        return this.provision(dependency, internalContext, constructionContext);
                    }
                });
                return t;
            }
            finally {
                constructionContext.removeCurrentReference();
                constructionContext.finishConstruction();
            }
        }

        private T provision(Dependency<?> dependency, InternalContext internalContext, ConstructionContext<T> constructionContext) {
            try {
                Object t = this.doProvision(internalContext, dependency);
                constructionContext.setProxyDelegates(t);
                return t;
            }
            catch (InternalProvisionException internalProvisionException) {
                throw internalProvisionException.addSource(this.getSource());
            }
            catch (Throwable throwable) {
                throw InternalProvisionException.errorInProvider(throwable).addSource(this.getSource());
            }
        }
    }

    static abstract class Factory<T>
    implements InternalFactory<T>,
    Provider<T>,
    HasDependencies {
        private final InitializationTiming initializationTiming;
        private Object source;
        private Provider<T> delegateProvider;
        ProvisionListenerStackCallback<T> provisionCallback;

        Factory(InitializationTiming initializationTiming) {
            this.initializationTiming = initializationTiming;
        }

        final Object getSource() {
            return this.source;
        }

        abstract void initialize(InjectorImpl var1, Errors var2);

        @Override
        public final T get() {
            Provider<T> provider = this.delegateProvider;
            if (provider == null) {
                throw new IllegalStateException("This Provider cannot be used until the Injector has been created.");
            }
            return provider.get();
        }

        @Override
        public T get(final InternalContext internalContext, final Dependency<?> dependency, boolean bl) {
            if (this.provisionCallback == null) {
                return this.doProvision(internalContext, dependency);
            }
            return this.provisionCallback.provision(internalContext, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() {
                    return this.doProvision(internalContext, dependency);
                }
            });
        }

        protected abstract T doProvision(InternalContext var1, Dependency<?> var2);
    }

    static enum InitializationTiming {
        EAGER,
        DELAYED;

    }
}

