/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.plotsquared.google.ConfigurationException;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.EncounterImpl;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ErrorsException;
import com.plotsquared.google.internal.FailableCache;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.MembersInjectorImpl;
import com.plotsquared.google.internal.SingleFieldInjector;
import com.plotsquared.google.internal.SingleMemberInjector;
import com.plotsquared.google.internal.SingleMethodInjector;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.TypeListener;
import com.plotsquared.google.spi.TypeListenerBinding;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

final class MembersInjectorStore {
    private final InjectorImpl injector;
    private final ImmutableList<TypeListenerBinding> typeListenerBindings;
    private final FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>> cache = new FailableCache<TypeLiteral<?>, MembersInjectorImpl<?>>(){

        @Override
        protected MembersInjectorImpl<?> create(TypeLiteral<?> typeLiteral, Errors errors) {
            return MembersInjectorStore.this.createWithListeners(typeLiteral, errors);
        }
    };

    MembersInjectorStore(InjectorImpl injectorImpl, List<TypeListenerBinding> list) {
        this.injector = injectorImpl;
        this.typeListenerBindings = ImmutableList.copyOf(list);
    }

    public boolean hasTypeListeners() {
        return !this.typeListenerBindings.isEmpty();
    }

    public <T> MembersInjectorImpl<T> get(TypeLiteral<T> typeLiteral, Errors errors) {
        return this.cache.get(typeLiteral, errors);
    }

    boolean remove(TypeLiteral<?> typeLiteral) {
        return this.cache.remove(typeLiteral);
    }

    private <T> MembersInjectorImpl<T> createWithListeners(TypeLiteral<T> typeLiteral, Errors errors) {
        Set set;
        int n = errors.size();
        try {
            set = InjectionPoint.forInstanceMethodsAndFields(typeLiteral);
        }
        catch (ConfigurationException configurationException) {
            errors.merge(configurationException.getErrorMessages());
            set = (Set)configurationException.getPartialValue();
        }
        ImmutableList<SingleMemberInjector> immutableList = this.getInjectors(set, errors);
        errors.throwIfNewErrors(n);
        EncounterImpl encounterImpl = new EncounterImpl(errors, this.injector.lookups);
        HashSet hashSet = Sets.newHashSet();
        for (TypeListenerBinding typeListenerBinding : this.typeListenerBindings) {
            TypeListener typeListener = typeListenerBinding.getListener();
            if (hashSet.contains(typeListener) || !typeListenerBinding.getTypeMatcher().matches(typeLiteral)) continue;
            hashSet.add(typeListener);
            try {
                typeListener.hear(typeLiteral, encounterImpl);
            }
            catch (RuntimeException runtimeException) {
                errors.errorNotifyingTypeListener(typeListenerBinding, typeLiteral, runtimeException);
            }
        }
        encounterImpl.invalidate();
        errors.throwIfNewErrors(n);
        return new MembersInjectorImpl<T>(this.injector, typeLiteral, encounterImpl, immutableList);
    }

    ImmutableList<SingleMemberInjector> getInjectors(Set<InjectionPoint> set, Errors errors) {
        ArrayList arrayList = Lists.newArrayList();
        for (InjectionPoint injectionPoint : set) {
            try {
                Errors errors2 = injectionPoint.isOptional() ? new Errors(injectionPoint) : errors.withSource(injectionPoint);
                SingleMemberInjector singleMemberInjector = injectionPoint.getMember() instanceof Field ? new SingleFieldInjector(this.injector, injectionPoint, errors2) : new SingleMethodInjector(this.injector, injectionPoint, errors2);
                arrayList.add(singleMemberInjector);
            }
            catch (ErrorsException errorsException) {}
        }
        return ImmutableList.copyOf((Collection)arrayList);
    }

    ImmutableListMultimap<TypeLiteral<?>, InjectionPoint> getAllInjectionPoints() {
        return (ImmutableListMultimap)this.cache.asMap().entrySet().stream().collect(ImmutableListMultimap.flatteningToImmutableListMultimap(Map.Entry::getKey, entry -> ((MembersInjectorImpl)entry.getValue()).getInjectionPoints().stream()));
    }
}

