/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Equivalence;
import com.google.common.base.Objects;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.plotsquared.google.Key;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalFlags;
import com.plotsquared.google.internal.PackageNameCompressor;
import com.plotsquared.google.internal.SourceFormatter;
import com.plotsquared.google.internal.util.Classes;
import com.plotsquared.google.spi.ElementSource;
import com.plotsquared.google.spi.ErrorDetail;
import com.plotsquared.google.spi.Message;
import java.lang.reflect.Member;
import java.util.Arrays;
import java.util.Collection;
import java.util.Formatter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public final class Messages {
    private static final Collection<Converter<?>> converters = ImmutableList.of((Object)new Converter<Class>(Class.class){

        @Override
        public String toString(Class clazz) {
            return clazz.getName();
        }
    }, (Object)new Converter<Member>(Member.class){

        @Override
        public String toString(Member member) {
            return Classes.toString(member);
        }
    }, (Object)new Converter<Key>(Key.class){

        @Override
        public String toString(Key key) {
            if (key.getAnnotationType() != null) {
                return key.getTypeLiteral() + " annotated with " + (key.getAnnotation() != null ? key.getAnnotation() : key.getAnnotationType());
            }
            return key.getTypeLiteral().toString();
        }
    });

    private Messages() {
    }

    static Message mergeSources(List<Object> list, Message message) {
        List<Object> list2 = message.getSources();
        if (!list.isEmpty() && !list2.isEmpty() && Objects.equal((Object)list2.get(0), (Object)list.get(list.size() - 1))) {
            list2 = list2.subList(1, list2.size());
        }
        return message.withSource((List<Object>)ImmutableList.builder().addAll(list).addAll(list2).build());
    }

    public static String format(String string, Object ... objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = Messages.convert(objectArray[i]);
        }
        return String.format(string, objectArray);
    }

    public static String formatMessages(String string, Collection<Message> collection) {
        Formatter formatter = new Formatter().format(string, new Object[0]).format(":\n\n", new Object[0]);
        int n = 1;
        boolean bl = Messages.getOnlyCause(collection) == null;
        List<Object> list = collection.stream().map(Message::getErrorDetail).collect(Collectors.toList());
        HashMap hashMap = Maps.newHashMap();
        while (!list.isEmpty()) {
            ErrorDetail errorDetail = (ErrorDetail)list.get(0);
            Map<Boolean, List<ErrorDetail>> map = list.subList(1, list.size()).stream().collect(Collectors.partitioningBy(errorDetail::isMergeable));
            list = map.get(false);
            errorDetail.format(n, map.get(true), formatter);
            Throwable throwable = errorDetail.getCause();
            if (bl && throwable != null) {
                Equivalence.Wrapper wrapper = ThrowableEquivalence.INSTANCE.wrap(throwable);
                if (!hashMap.containsKey(wrapper)) {
                    hashMap.put(wrapper, n);
                    formatter.format("Caused by: %s", Throwables.getStackTraceAsString((Throwable)throwable));
                } else {
                    int n2 = (Integer)hashMap.get(wrapper);
                    formatter.format("Caused by: %s (same stack trace as error #%s)", throwable.getClass().getName(), n2);
                }
            }
            formatter.format("\n", new Object[0]);
            ++n;
        }
        if (n == 2) {
            formatter.format("1 error", new Object[0]);
        } else {
            formatter.format("%s errors", n - 1);
        }
        return PackageNameCompressor.compressPackagesInMessage(formatter.toString());
    }

    public static Message create(ErrorId errorId, String string, Object ... objectArray) {
        return Messages.create(errorId, null, string, objectArray);
    }

    public static Message create(ErrorId errorId, Throwable throwable, String string, Object ... objectArray) {
        return Messages.create(errorId, throwable, (List<Object>)ImmutableList.of(), string, objectArray);
    }

    public static Message create(ErrorId errorId, Throwable throwable, List<Object> list, String string, Object ... objectArray) {
        String string2 = Messages.format(string, objectArray);
        return new Message(errorId, list, string2, throwable);
    }

    static Object convert(Object object) {
        ElementSource elementSource = null;
        if (object instanceof ElementSource) {
            elementSource = (ElementSource)object;
            object = elementSource.getDeclaringSource();
        }
        return Messages.convert(object, elementSource);
    }

    static Object convert(Object object, ElementSource elementSource) {
        for (Converter<?> converter : converters) {
            if (!converter.appliesTo(object)) continue;
            return Messages.appendModules(converter.convert(object), elementSource);
        }
        return Messages.appendModules(object, elementSource);
    }

    private static Object appendModules(Object object, ElementSource elementSource) {
        String string = SourceFormatter.getModuleStack(elementSource);
        if (string.length() == 0) {
            return object;
        }
        return object + " (installed by: " + string + ")";
    }

    public static Throwable getOnlyCause(Collection<Message> collection) {
        Throwable throwable = null;
        for (Message message : collection) {
            Throwable throwable2 = message.getCause();
            if (throwable2 == null) continue;
            if (throwable != null && !ThrowableEquivalence.INSTANCE.equivalent(throwable, throwable2)) {
                return null;
            }
            throwable = throwable2;
        }
        return throwable;
    }

    private static final String formatText(String string, FormatOptions ... formatOptionsArray) {
        if (!InternalFlags.enableColorizeErrorMessages()) {
            return string;
        }
        return String.format("%s%s%s", Arrays.stream(formatOptionsArray).map(formatOptions -> ((FormatOptions)formatOptions).ansiCode).collect(Collectors.joining()), string, FormatOptions.RESET.ansiCode);
    }

    public static final String bold(String string) {
        return Messages.formatText(string, FormatOptions.BOLD);
    }

    public static final String redBold(String string) {
        return Messages.formatText(string, FormatOptions.RED, FormatOptions.BOLD);
    }

    public static final String underline(String string) {
        return Messages.formatText(string, FormatOptions.UNDERLINE);
    }

    public static final String faint(String string) {
        return Messages.formatText(string, FormatOptions.FAINT);
    }

    private static enum FormatOptions {
        RED("\u001b[31m"),
        BOLD("\u001b[1m"),
        FAINT("\u001b[2m"),
        ITALIC("\u001b[3m"),
        UNDERLINE("\u001b[4m"),
        RESET("\u001b[0m");

        private final String ansiCode;

        private FormatOptions(String string2) {
            this.ansiCode = string2;
        }
    }

    private static final class ThrowableEquivalence
    extends Equivalence<Throwable> {
        static final ThrowableEquivalence INSTANCE = new ThrowableEquivalence();

        private ThrowableEquivalence() {
        }

        protected boolean doEquivalent(Throwable throwable, Throwable throwable2) {
            return throwable.getClass().equals(throwable2.getClass()) && Objects.equal((Object)throwable.getMessage(), (Object)throwable2.getMessage()) && Arrays.equals(throwable.getStackTrace(), throwable2.getStackTrace()) && this.equivalent(throwable.getCause(), throwable2.getCause());
        }

        protected int doHash(Throwable throwable) {
            return Objects.hashCode((Object[])new Object[]{throwable.getClass().hashCode(), throwable.getMessage(), this.hash(throwable.getCause())});
        }
    }

    private static abstract class Converter<T> {
        final Class<T> type;

        Converter(Class<T> clazz) {
            this.type = clazz;
        }

        boolean appliesTo(Object object) {
            return object != null && this.type.isAssignableFrom(object.getClass());
        }

        String convert(Object object) {
            return this.toString(this.type.cast(object));
        }

        abstract String toString(T var1);
    }
}

