/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.ErrorFormatter;
import com.plotsquared.google.internal.ErrorId;
import com.plotsquared.google.internal.InternalErrorDetail;
import com.plotsquared.google.internal.Messages;
import com.plotsquared.google.spi.ErrorDetail;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.Iterator;
import java.util.List;

final class MissingConstructorError
extends InternalErrorDetail<MissingConstructorError> {
    private final TypeLiteral<?> type;
    private final boolean atInjectRequired;

    MissingConstructorError(TypeLiteral<?> typeLiteral, boolean bl, List<Object> list) {
        super(ErrorId.MISSING_CONSTRUCTOR, "No injectable constructor for type " + typeLiteral + ".", list, null);
        this.type = typeLiteral;
        this.atInjectRequired = bl;
    }

    @Override
    public boolean isMergeable(ErrorDetail<?> errorDetail) {
        if (errorDetail instanceof MissingConstructorError) {
            MissingConstructorError missingConstructorError = (MissingConstructorError)errorDetail;
            return Objects.equal(this.type, missingConstructorError.type) && Objects.equal((Object)this.atInjectRequired, (Object)missingConstructorError.atInjectRequired);
        }
        return false;
    }

    @Override
    protected void formatDetail(List<ErrorDetail<?>> list, Formatter formatter) {
        Object object;
        formatter.format("\n", new Object[0]);
        Class<?> clazz = this.type.getRawType();
        if (this.atInjectRequired) {
            formatter.format("Injector is configured to require @Inject constructors but %s does not have a @Inject annotated constructor.\n", clazz);
        } else {
            object = null;
            try {
                object = this.type.getRawType().getDeclaredConstructor(new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (object == null) {
                formatter.format("%s does not have a @Inject annotated constructor or a no-arg constructor.\n", clazz);
            } else if (Modifier.isPrivate(((Constructor)object).getModifiers()) && !Modifier.isPrivate(clazz.getModifiers())) {
                formatter.format("%s has a private no-arg constructor but the class is not private. Guice can only use a private no-arg constructor if it is defined in a private class.\n", clazz);
            }
        }
        formatter.format("\n", new Object[0]);
        object = new ArrayList();
        object.add(this.getSources());
        list.forEach(arg_0 -> MissingConstructorError.lambda$formatDetail$0((List)object, arg_0));
        formatter.format("%s\n", Messages.bold("Requested by:"));
        int n = 1;
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            List list2 = (List)iterator.next();
            ErrorFormatter.formatSources(n++, Lists.reverse((List)list2), formatter);
        }
    }

    @Override
    public MissingConstructorError withSources(List<Object> list) {
        return new MissingConstructorError(this.type, this.atInjectRequired, list);
    }

    private static /* synthetic */ void lambda$formatDetail$0(List list, ErrorDetail errorDetail) {
        list.add(errorDetail.getSources());
    }
}

