/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.plotsquared.google.Key;
import com.plotsquared.google.internal.BindingImpl;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.DelayedInitialize;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.InjectorImpl;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProviderInternalFactory;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.Dependency;
import jakarta.inject.Provider;

class ProvidedByInternalFactory<T>
extends ProviderInternalFactory<T>
implements DelayedInitialize {
    private final Class<?> rawType;
    private final Class<? extends Provider<?>> providerType;
    private final Key<? extends Provider<T>> providerKey;
    private BindingImpl<? extends Provider<T>> providerBinding;
    private ProvisionListenerStackCallback<T> provisionCallback;

    ProvidedByInternalFactory(Class<?> clazz, Class<? extends Provider<?>> clazz2, Key<? extends Provider<T>> key) {
        super(key);
        this.rawType = clazz;
        this.providerType = clazz2;
        this.providerKey = key;
    }

    void setProvisionListenerCallback(ProvisionListenerStackCallback<T> provisionListenerStackCallback) {
        this.provisionCallback = provisionListenerStackCallback;
    }

    @Override
    public void initialize(InjectorImpl injectorImpl, Errors errors) {
        this.providerBinding = injectorImpl.getBindingOrThrow(this.providerKey, errors, InjectorImpl.JitLimitation.NEW_OR_EXISTING_JIT);
    }

    @Override
    public T get(InternalContext internalContext, Dependency<?> dependency, boolean bl) {
        BindingImpl<Provider<T>> bindingImpl = this.providerBinding;
        if (bindingImpl == null) {
            throw new IllegalStateException("not initialized");
        }
        Key<? extends Provider<T>> key = this.providerKey;
        try {
            Provider<T> provider = bindingImpl.getInternalFactory().get(internalContext, dependency, true);
            return this.circularGet(provider, internalContext, dependency, this.provisionCallback);
        }
        catch (InternalProvisionException internalProvisionException) {
            throw internalProvisionException.addSource(key);
        }
    }

    @Override
    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) {
        try {
            T t = super.provision(provider, dependency, constructionContext);
            if (t != null && !this.rawType.isInstance(t)) {
                throw InternalProvisionException.subtypeNotProvided(this.providerType, this.rawType);
            }
            T t2 = t;
            return t2;
        }
        catch (RuntimeException runtimeException) {
            throw InternalProvisionException.errorInProvider(runtimeException).addSource(this.source);
        }
    }
}

