/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Preconditions;
import com.plotsquared.core.annotation.Nullable;
import com.plotsquared.google.internal.ConstructionContext;
import com.plotsquared.google.internal.InternalContext;
import com.plotsquared.google.internal.InternalFactory;
import com.plotsquared.google.internal.InternalProvisionException;
import com.plotsquared.google.internal.ProvisionListenerStackCallback;
import com.plotsquared.google.spi.Dependency;
import jakarta.inject.Provider;

abstract class ProviderInternalFactory<T>
implements InternalFactory<T> {
    protected final Object source;

    ProviderInternalFactory(Object object) {
        this.source = Preconditions.checkNotNull((Object)object, (Object)"source");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T circularGet(final Provider<? extends T> provider, InternalContext internalContext, final Dependency<?> dependency, @Nullable ProvisionListenerStackCallback<T> provisionListenerStackCallback) {
        final ConstructionContext constructionContext = internalContext.getConstructionContext(this);
        if (constructionContext.isConstructing()) {
            Class<?> clazz = dependency.getKey().getTypeLiteral().getRawType();
            Object object = constructionContext.createProxy(internalContext.getInjectorOptions(), clazz);
            return (T)object;
        }
        constructionContext.startConstruction();
        try {
            if (provisionListenerStackCallback == null) {
                T t = this.provision(provider, dependency, constructionContext);
                return t;
            }
            T t = provisionListenerStackCallback.provision(internalContext, new ProvisionListenerStackCallback.ProvisionCallback<T>(){

                @Override
                public T call() {
                    return ProviderInternalFactory.this.provision(provider, dependency, constructionContext);
                }
            });
            return t;
        }
        finally {
            constructionContext.removeCurrentReference();
            constructionContext.finishConstruction();
        }
    }

    protected T provision(Provider<? extends T> provider, Dependency<?> dependency, ConstructionContext<T> constructionContext) {
        T t = provider.get();
        if (t == null && !dependency.isNullable()) {
            InternalProvisionException.onNullInjectedIntoNonNullableDependency(this.source, dependency);
        }
        constructionContext.setProxyDelegates(t);
        return t;
    }
}

