/*
 * Decompiled with CFR 0.152.
 */
package com.plotsquared.google.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.plotsquared.google.Binder;
import com.plotsquared.google.Key;
import com.plotsquared.google.Module;
import com.plotsquared.google.Provides;
import com.plotsquared.google.TypeLiteral;
import com.plotsquared.google.internal.Annotations;
import com.plotsquared.google.internal.DeclaredMembers;
import com.plotsquared.google.internal.Errors;
import com.plotsquared.google.internal.ProviderMethod;
import com.plotsquared.google.internal.ProvidesMethodScanner;
import com.plotsquared.google.spi.InjectionPoint;
import com.plotsquared.google.spi.Message;
import com.plotsquared.google.spi.ModuleAnnotatedMethodScanner;
import com.plotsquared.google.util.Modules;
import java.lang.annotation.Annotation;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProviderMethodsModule
implements Module {
    private final Object delegate;
    private final TypeLiteral<?> typeLiteral;
    private final boolean skipFastClassGeneration;
    private final ModuleAnnotatedMethodScanner scanner;

    private ProviderMethodsModule(Object object, boolean bl, ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner) {
        this.delegate = Preconditions.checkNotNull((Object)object, (Object)"delegate");
        this.typeLiteral = TypeLiteral.get(this.getDelegateModuleClass());
        this.skipFastClassGeneration = bl;
        this.scanner = moduleAnnotatedMethodScanner;
    }

    public static Module forModule(Module module) {
        return ProviderMethodsModule.forObject(module, false, ProvidesMethodScanner.INSTANCE);
    }

    public static Module forModule(Object object, ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner) {
        return ProviderMethodsModule.forObject(object, false, moduleAnnotatedMethodScanner);
    }

    public static Module forObject(Object object) {
        return ProviderMethodsModule.forObject(object, true, ProvidesMethodScanner.INSTANCE);
    }

    private static Module forObject(Object object, boolean bl, ModuleAnnotatedMethodScanner moduleAnnotatedMethodScanner) {
        if (object instanceof ProviderMethodsModule) {
            return Modules.EMPTY_MODULE;
        }
        return new ProviderMethodsModule(object, bl, moduleAnnotatedMethodScanner);
    }

    public Class<?> getDelegateModuleClass() {
        return this.isStaticModule() ? (Class<?>)this.delegate : this.delegate.getClass();
    }

    private boolean isStaticModule() {
        return this.delegate instanceof Class;
    }

    @Override
    public void configure(Binder binder) {
        for (ProviderMethod<?> providerMethod : this.getProviderMethods(binder)) {
            providerMethod.configure(binder);
        }
    }

    public List<ProviderMethod<?>> getProviderMethods(Binder binder) {
        Object object;
        HashMultimap hashMultimap;
        HashMultimap hashMultimap2;
        ArrayList arrayList = null;
        ArrayList<MethodAndAnnotation> arrayList2 = null;
        for (hashMultimap2 = hashMultimap = this.getDelegateModuleClass(); hashMultimap2 != Object.class && hashMultimap2 != null; hashMultimap2 = hashMultimap2.getSuperclass()) {
            object = DeclaredMembers.getDeclaredMethods(hashMultimap2);
            int n = ((Method[])object).length;
            for (int i = 0; i < n; ++i) {
                Object object2;
                Object object3 = object[i];
                Annotation object4 = this.getAnnotation(binder, (Method)object3);
                if (object4 == null) continue;
                if (this.isStaticModule() && !Modifier.isStatic(((Method)object3).getModifiers()) && !Modifier.isAbstract(((Method)object3).getModifiers())) {
                    binder.addError("%s is an instance method, but a class literal was passed. Make this method static or pass an instance of the module instead.", object3);
                    continue;
                }
                if (arrayList == null) {
                    arrayList = new ArrayList();
                    arrayList2 = new ArrayList<MethodAndAnnotation>();
                }
                if ((object2 = this.createProviderMethod(binder, (Method)object3, object4)) != null) {
                    arrayList.add((ProviderMethod)object2);
                }
                arrayList2.add(new MethodAndAnnotation((Method)object3, object4));
                hashMultimap = hashMultimap2;
            }
        }
        if (arrayList == null) {
            return ImmutableList.of();
        }
        hashMultimap2 = null;
        for (object = this.getDelegateModuleClass(); object != hashMultimap; object = ((Class)object).getSuperclass()) {
            for (Method method : ((Class)object).getDeclaredMethods()) {
                if ((method.getModifiers() & 0xA) != 0 || method.isBridge() || method.isSynthetic()) continue;
                if (hashMultimap2 == null) {
                    hashMultimap2 = HashMultimap.create();
                }
                hashMultimap2.put((Object)new Signature(this.typeLiteral, method), (Object)method);
            }
        }
        if (hashMultimap2 != null) {
            block4: for (MethodAndAnnotation methodAndAnnotation : arrayList2) {
                Method method = methodAndAnnotation.method;
                Annotation annotation = methodAndAnnotation.annotation;
                for (Object object2 : hashMultimap2.get((Object)new Signature(this.typeLiteral, method))) {
                    if (((Method)object2).getDeclaringClass().isAssignableFrom(method.getDeclaringClass()) || !ProviderMethodsModule.overrides((Method)object2, method)) continue;
                    String string = annotation.annotationType() == Provides.class ? "@Provides" : "@" + annotation.annotationType().getCanonicalName();
                    binder.addError("Overriding " + string + " methods is not allowed.\n\t" + string + " method: %s\n\toverridden by: %s", method, object2);
                    continue block4;
                }
            }
        }
        return arrayList;
    }

    private Annotation getAnnotation(Binder binder, Method method) {
        if (method.isBridge() || method.isSynthetic()) {
            return null;
        }
        Annotation annotation = null;
        for (Class<? extends Annotation> clazz : this.scanner.annotationClasses()) {
            Annotation annotation2 = method.getAnnotation(clazz);
            if (annotation2 == null) continue;
            if (annotation != null) {
                binder.addError("More than one annotation claimed by %s on method %s. Methods can only have one annotation claimed per scanner.", this.scanner, method);
                return null;
            }
            annotation = annotation2;
        }
        return annotation;
    }

    private static boolean overrides(Method method, Method method2) {
        int n = method2.getModifiers();
        if (Modifier.isPublic(n) || Modifier.isProtected(n)) {
            return true;
        }
        if (Modifier.isPrivate(n)) {
            return false;
        }
        return method.getDeclaringClass().getPackage().equals(method2.getDeclaringClass().getPackage());
    }

    private <T> ProviderMethod<T> createProviderMethod(Binder binder, Method method, Annotation annotation) {
        binder = binder.withSource(method);
        Errors errors = new Errors(method);
        InjectionPoint injectionPoint = InjectionPoint.forMethod(method, this.typeLiteral);
        TypeLiteral<?> typeLiteral = this.typeLiteral.getReturnType(method);
        Key<?> key = this.getKey(errors, typeLiteral, method, method.getAnnotations());
        boolean bl = false;
        try {
            key = this.scanner.prepareMethod(binder, annotation, key, injectionPoint);
        }
        catch (Throwable throwable) {
            bl = true;
            binder.addError(throwable);
        }
        if (Modifier.isAbstract(method.getModifiers())) {
            Preconditions.checkState((bl || key == null ? 1 : 0) != 0, (String)"%s returned a non-null key (%s) for %s. prepareMethod() must return null for abstract methods", (Object)this.scanner, key, (Object)method);
            return null;
        }
        if (key == null) {
            return null;
        }
        Class<? extends Annotation> clazz = Annotations.findScopeAnnotation(errors, method.getAnnotations());
        for (Message message : errors.getMessages()) {
            binder.addError(message);
        }
        return ProviderMethod.create(key, method, this.isStaticModule() || Modifier.isStatic(method.getModifiers()) ? null : this.delegate, ImmutableSet.copyOf(injectionPoint.getDependencies()), clazz, this.skipFastClassGeneration, annotation);
    }

    <T> Key<T> getKey(Errors errors, TypeLiteral<T> typeLiteral, Member member, Annotation[] annotationArray) {
        Annotation annotation = Annotations.findBindingAnnotation(errors, member, annotationArray);
        return annotation == null ? Key.get(typeLiteral) : Key.get(typeLiteral, annotation);
    }

    public boolean equals(Object object) {
        return object instanceof ProviderMethodsModule && ((ProviderMethodsModule)object).delegate == this.delegate && ((ProviderMethodsModule)object).scanner.equals(this.scanner);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.delegate, this.scanner});
    }

    public boolean isScanningBuiltInProvidesMethods() {
        return this.scanner == ProvidesMethodScanner.INSTANCE;
    }

    public ModuleAnnotatedMethodScanner getScanner() {
        return this.scanner;
    }

    private static final class Signature {
        final Class<?>[] parameters;
        final String name;
        final int hashCode;

        Signature(TypeLiteral<?> typeLiteral, Method method) {
            this.name = method.getName();
            List<TypeLiteral<?>> list = typeLiteral.getParameterTypes(method);
            this.parameters = new Class[list.size()];
            int n = 0;
            for (TypeLiteral<?> typeLiteral2 : list) {
                this.parameters[n] = typeLiteral2.getRawType();
            }
            this.hashCode = this.name.hashCode() + 31 * Arrays.hashCode(this.parameters);
        }

        public boolean equals(Object object) {
            if (object instanceof Signature) {
                Signature signature = (Signature)object;
                return signature.name.equals(this.name) && Arrays.equals(this.parameters, signature.parameters);
            }
            return false;
        }

        public int hashCode() {
            return this.hashCode;
        }
    }

    private static class MethodAndAnnotation {
        final Method method;
        final Annotation annotation;

        MethodAndAnnotation(Method method, Annotation annotation) {
            this.method = method;
            this.annotation = annotation;
        }
    }
}

